/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.mtom_xop;

import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.MTOM;

@WebServiceProvider(portName="TestMtomProviderPort", serviceName="TestMtomService", targetNamespace="http://cxf.apache.org/mime", wsdlLocation="testutils/mtom_xop.wsdl")
@ServiceMode(value=Service.Mode.MESSAGE)
@MTOM
public class TestMtomProviderImpl
implements Provider<SOAPMessage> {
    public SOAPMessage invoke(SOAPMessage request) {
        try {
            System.out.println("=== Received client request ===");
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            SOAPPart part = message.getSOAPPart();
            SOAPEnvelope envelope = part.getEnvelope();
            SOAPBody body = envelope.getBody();
            SOAPBodyElement testResponse = body.addBodyElement(envelope.createName("testXopResponse", null, "http://cxf.apache.org/mime/types"));
            SOAPElement name = testResponse.addChildElement("name", null, "http://cxf.apache.org/mime/types");
            name.setTextContent("return detail + call detail");
            SOAPElement attachinfo = testResponse.addChildElement("attachinfo", null, "http://cxf.apache.org/mime/types");
            SOAPElement include = attachinfo.addChildElement("Include", "xop", "http://www.w3.org/2004/08/xop/include");
            int fileSize = 0;
            try (InputStream pre = this.getClass().getResourceAsStream("/wsdl/mtom_xop.wsdl");){
                int i = pre.read();
                while (i != -1) {
                    ++fileSize;
                    i = pre.read();
                }
            }
            int count = 50;
            byte[] data = new byte[fileSize * count];
            for (int x = 0; x < count; ++x) {
                this.getClass().getResourceAsStream("/wsdl/mtom_xop.wsdl").read(data, fileSize * x, fileSize);
            }
            DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(data, "application/octet-stream"));
            AttachmentPart attachment = message.createAttachmentPart(dh);
            attachment.setContentId("mtom_xop.wsdl");
            message.addAttachmentPart(attachment);
            System.out.println("Adding attachment: " + attachment.getContentId() + ":" + attachment.getSize());
            include.addAttribute(envelope.createName("href"), "cid:" + attachment.getContentId());
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

