/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.customer.wraped;

import java.util.HashMap;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.cxf.customer.Customer;
import org.apache.cxf.customer.Customers;
import org.codehaus.jra.Delete;
import org.codehaus.jra.Get;
import org.codehaus.jra.HttpResource;
import org.codehaus.jra.Post;
import org.codehaus.jra.Put;

@WebService(targetNamespace="http://cxf.apache.org/jra")
public class CustomerService {
    long currentId = 1L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();

    public CustomerService() {
        Customer customer = this.createCustomer();
        this.customers.put(customer.getId(), customer);
    }

    @Get
    @HttpResource(location="/customers")
    @WebMethod
    @WebResult(name="customers")
    public Customers getCustomers() {
        Customers cbean = new Customers();
        cbean.setCustomer(this.customers.values());
        return cbean;
    }

    @Get
    @HttpResource(location="/customers/{id}")
    @WebMethod
    @WebResult(name="customer")
    public Customer getCustomer(@WebParam(name="id") Long id) {
        return this.customers.get(id);
    }

    @Put
    @HttpResource(location="/customers/{id}")
    @WebMethod
    public void updateCustomer(@WebParam(name="id") String id, @WebParam(name="customer") Customer c) {
        this.customers.put(c.getId(), c);
    }

    @Post
    @HttpResource(location="/customers")
    @WebMethod
    public void addCustomer(@WebParam(name="customer") Customer c) {
        long id = ++this.currentId;
        c.setId(id);
        this.customers.put(id, c);
    }

    @Delete
    @HttpResource(location="/customers/{id}")
    @WebMethod
    public void deleteCustomer(String id) {
        this.customers.remove(new Long(id));
    }

    final Customer createCustomer() {
        Customer c = new Customer();
        c.setName("Dan Diephouse");
        c.setId(123L);
        return c;
    }
}

