/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.RSSecurityUtils;
import org.apache.cxf.rs.security.common.TrustValidator;
import org.apache.cxf.rs.security.xml.AbstractXmlSecInHandler;
import org.apache.cxf.rs.security.xml.EncryptionProperties;
import org.apache.cxf.rs.security.xml.EncryptionUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXmlEncInHandler
extends AbstractXmlSecInHandler {
    private EncryptionProperties encProps;

    public void decryptContent(Message message) {
        Message outMs = message.getExchange().getOutMessage();
        Message inMsg = outMs == null ? message : outMs.getExchange().getInMessage();
        Document doc = this.getDocument(inMsg);
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        byte[] symmetricKeyBytes = this.getSymmetricKeyBytes(message, root);
        String symKeyAlgo = this.getEncodingMethodAlgorithm(root);
        if (this.encProps != null && this.encProps.getEncryptionSymmetricKeyAlgo() != null && !this.encProps.getEncryptionSymmetricKeyAlgo().equals(symKeyAlgo)) {
            this.throwFault("Encryption Symmetric Key Algorithm is not supported", null);
        }
        byte[] decryptedPayload = null;
        try {
            decryptedPayload = this.decryptPayload(root, symmetricKeyBytes, symKeyAlgo);
        }
        catch (Exception ex) {
            this.throwFault("Payload can not be decrypted", ex);
        }
        Document payloadDoc = null;
        try {
            payloadDoc = StaxUtils.read((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(decryptedPayload), StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            this.throwFault("Payload document can not be created", ex);
        }
        message.setContent(XMLStreamReader.class, (Object)new W3CDOMStreamReader(payloadDoc));
        message.setContent(InputStream.class, null);
    }

    protected byte[] getSymmetricKeyBytes(Message message, Element encDataElement) {
        Element cipherValue;
        String cryptoKey = null;
        String propKey = null;
        if (RSSecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "security.signature.crypto";
            propKey = "security.signature.properties";
        } else {
            cryptoKey = "security.encryption.crypto";
            propKey = "security.encryption.properties";
        }
        Crypto crypto = null;
        try {
            crypto = new CryptoLoader().getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
        }
        Element encKeyElement = this.getNode(encDataElement, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey", 0);
        if (encKeyElement == null) {
            this.throwFault("EncryptedKey element is not available", null);
        }
        X509Certificate cert = this.loadCertificate(crypto, encKeyElement);
        try {
            new TrustValidator().validateTrust(crypto, cert, null);
        }
        catch (Exception ex) {
            this.throwFault(ex.getMessage(), ex);
        }
        String keyEncAlgo = this.getEncodingMethodAlgorithm(encKeyElement);
        String digestAlgo = this.getDigestMethodAlgorithm(encKeyElement);
        if (this.encProps != null) {
            if (this.encProps.getEncryptionKeyTransportAlgo() != null && !this.encProps.getEncryptionKeyTransportAlgo().equals(keyEncAlgo)) {
                this.throwFault("Key Transport Algorithm is not supported", null);
            }
            if (!(this.encProps.getEncryptionDigestAlgo() == null || digestAlgo != null && this.encProps.getEncryptionDigestAlgo().equals(digestAlgo))) {
                this.throwFault("Digest Algorithm is not supported", null);
            }
        } else if (!"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(keyEncAlgo)) {
            this.throwFault("Key Transport Algorithm is not supported", null);
        }
        if ((cipherValue = this.getNode(encKeyElement, "http://www.w3.org/2001/04/xmlenc#", "CipherValue", 0)) == null) {
            this.throwFault("CipherValue element is not available", null);
        }
        try {
            return this.decryptSymmetricKey(cipherValue.getTextContent().trim(), cert, crypto, keyEncAlgo, digestAlgo, message);
        }
        catch (Exception ex) {
            this.throwFault(ex.getMessage(), ex);
            return null;
        }
    }

    private X509Certificate loadCertificate(Crypto crypto, Element encKeyElement) {
        Element certNode;
        String keyIdentifierType;
        String string = keyIdentifierType = this.encProps != null ? this.encProps.getEncryptionKeyIdType() : null;
        if ((keyIdentifierType == null || keyIdentifierType.equals("X509Certificate")) && (certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate", 0)) != null) {
            try {
                return RSSecurityUtils.loadX509Certificate(crypto, certNode);
            }
            catch (Exception ex) {
                this.throwFault("X509Certificate can not be created", ex);
            }
        }
        if ((keyIdentifierType == null || keyIdentifierType.equals("X509IssuerSerial")) && (certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial", 0)) != null) {
            try {
                return RSSecurityUtils.loadX509IssuerSerial(crypto, certNode);
            }
            catch (Exception ex) {
                this.throwFault("X509Certificate can not be created", ex);
            }
        }
        this.throwFault("Certificate is missing", null);
        return null;
    }

    private String getEncodingMethodAlgorithm(Element parent) {
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod == null) {
            this.throwFault("EncryptionMethod element is not available", null);
        }
        return encMethod.getAttribute("Algorithm");
    }

    private String getDigestMethodAlgorithm(Element parent) {
        Element digestMethod;
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod != null && (digestMethod = this.getNode(encMethod, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod", 0)) != null) {
            return digestMethod.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    protected byte[] decryptSymmetricKey(String base64EncodedKey, X509Certificate cert, Crypto crypto, String keyEncAlgo, Message message) throws WSSecurityException {
        return this.decryptSymmetricKey(base64EncodedKey, cert, crypto, keyEncAlgo, null, message);
    }

    protected byte[] decryptSymmetricKey(String base64EncodedKey, X509Certificate cert, Crypto crypto, String keyEncAlgo, String digestAlgo, Message message) throws WSSecurityException {
        CallbackHandler callback = RSSecurityUtils.getCallbackHandler(message, this.getClass());
        PrivateKey key = null;
        try {
            key = crypto.getPrivateKey(cert, callback);
        }
        catch (Exception ex) {
            this.throwFault("Encrypted key can not be decrypted", ex);
        }
        Cipher cipher = EncryptionUtils.initCipherWithKey(keyEncAlgo, digestAlgo, 2, key);
        try {
            byte[] encryptedBytes = Base64Utility.decode((String)base64EncodedKey);
            return cipher.doFinal(encryptedBytes);
        }
        catch (Base64Exception ex) {
            this.throwFault("Base64 decoding has failed", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.throwFault("Encrypted key can not be decrypted", ex);
        }
        return null;
    }

    protected byte[] decryptPayload(Element root, byte[] secretKeyBytes, String symEncAlgo) throws WSSecurityException {
        SecretKey key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])secretKeyBytes);
        try {
            XMLCipher xmlCipher = EncryptionUtils.initXMLCipher(symEncAlgo, 2, key);
            return xmlCipher.decryptToByteArray(root);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
    }

    public void setEncryptionProperties(EncryptionProperties properties) {
        this.encProps = properties;
    }
}

