/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.TrustValidator;
import org.apache.cxf.rs.security.xml.AbstractXmlSecInHandler;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractXmlSigInHandler
extends AbstractXmlSecInHandler {
    private boolean removeSignature = true;
    private boolean persistSignature = true;

    public void setRemoveSignature(boolean remove) {
        this.removeSignature = remove;
    }

    public void setPersistSignature(boolean persist) {
        this.persistSignature = persist;
    }

    protected void checkSignature(Message message) {
        Document doc = this.getDocument(message);
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        Element signatureElement = this.getSignatureElement(root);
        if (signatureElement == null) {
            this.throwFault("XML Signature is not available", null);
        }
        Crypto crypto = null;
        try {
            CryptoLoader loader = new CryptoLoader();
            crypto = loader.getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties");
            if (crypto == null) {
                crypto = loader.getCrypto(message, "ws-security.encryption.crypto", "ws-security.encryption.properties");
            }
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
        }
        boolean valid = false;
        Reference ref = null;
        try {
            XMLSignature signature = new XMLSignature(signatureElement, "");
            KeyInfo keyInfo = signature.getKeyInfo();
            X509Certificate cert = keyInfo.getX509Certificate();
            if (cert != null) {
                valid = signature.checkSignatureValue(cert);
            } else {
                PublicKey pk = keyInfo.getPublicKey();
                if (pk != null) {
                    valid = signature.checkSignatureValue((Key)pk);
                }
            }
            ref = this.getReference(signature);
            Element signedElement = this.validateReference(root, ref);
            new TrustValidator().validateTrust(crypto, cert, keyInfo.getPublicKey());
            if (this.persistSignature) {
                message.setContent(XMLSignature.class, (Object)signature);
                message.setContent(Element.class, (Object)signedElement);
            }
        }
        catch (Exception ex) {
            this.throwFault("Signature validation failed", ex);
        }
        if (!valid) {
            this.throwFault("Signature validation failed", null);
        }
        if (this.removeSignature) {
            if (!this.isEnveloping(root)) {
                Element signedEl = this.getSignedElement(root, ref);
                signedEl.removeAttribute("ID");
                root.removeChild(signatureElement);
            } else {
                Element actualBody = this.getActualBody(root);
                Document newDoc = DOMUtils.createDocument();
                newDoc.adoptNode(actualBody);
                root = actualBody;
            }
        }
        message.setContent(XMLStreamReader.class, (Object)new W3CDOMStreamReader(root));
        message.setContent(InputStream.class, null);
    }

    private Element getActualBody(Element envelopingSigElement) {
        Element node;
        Element objectNode = this.getNode(envelopingSigElement, "http://www.w3.org/2000/09/xmldsig#", "Object", 0);
        if (objectNode == null) {
            this.throwFault("Object envelope is not available", null);
        }
        if ((node = DOMUtils.getFirstElement((Node)objectNode)) == null) {
            this.throwFault("No signed data is found", null);
        }
        return node;
    }

    private Element getSignatureElement(Element sigParentElement) {
        if (this.isEnveloping(sigParentElement)) {
            return sigParentElement;
        }
        return DOMUtils.getFirstChildWithName((Element)sigParentElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
    }

    protected boolean isEnveloping(Element root) {
        return "http://www.w3.org/2000/09/xmldsig#".equals(root.getNamespaceURI()) && "Signature".equals(root.getLocalName());
    }

    protected Reference getReference(XMLSignature sig) {
        int count = sig.getSignedInfo().getLength();
        if (count != 1) {
            this.throwFault("Multiple Signature Reference are not currently supported", null);
        }
        try {
            return sig.getSignedInfo().item(0);
        }
        catch (XMLSecurityException ex) {
            this.throwFault("Signature Reference is not available", (Exception)((Object)ex));
            return null;
        }
    }

    protected Element validateReference(Element root, Reference ref) {
        Element signedEl;
        boolean enveloped = false;
        String refId = ref.getURI();
        if (!refId.startsWith("#") || refId.length() <= 1) {
            this.throwFault("Only local Signature References are supported", null);
        }
        if ((signedEl = this.getSignedElement(root, ref)) != null) {
            enveloped = signedEl == root;
        } else {
            this.throwFault("Signature Reference ID is invalid", null);
        }
        Transforms transforms = null;
        try {
            transforms = ref.getTransforms();
        }
        catch (XMLSecurityException ex) {
            this.throwFault("Signature transforms can not be obtained", (Exception)((Object)ex));
        }
        if (enveloped) {
            boolean isEnveloped = false;
            for (int i = 0; i < transforms.getLength(); ++i) {
                try {
                    Transform tr = transforms.item(i);
                    if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(tr.getURI())) continue;
                    isEnveloped = true;
                    break;
                }
                catch (Exception ex) {
                    this.throwFault("Problem accessing Transform instance", ex);
                }
            }
            if (!isEnveloped) {
                this.throwFault("Only enveloped signatures are currently supported", null);
            }
        }
        return signedEl;
    }

    private Element getSignedElement(Element root, Reference ref) {
        String rootId = root.getAttribute("ID");
        String expectedID = ref.getURI().substring(1);
        if (!expectedID.equals(rootId)) {
            return (Element)DOMUtils.findChildWithAtt((Node)root, null, (String)"ID", (String)expectedID);
        }
        return root;
    }
}

