/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaUtils {
    public static final XmlSchemaForm QUALIFIED = new XmlSchemaForm("qualified");
    public static final XmlSchemaForm UNQUALIFIED = new XmlSchemaForm("unqualified");
    public static final String XSI_NS_ATTR = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";
    public static final String XSI_NIL_WITH_PREFIX = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:nil='true'";
    public static final String XSI_NIL = "xsi:nil='true'";
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSchemaUtils.class);
    private static final XmlSchemaSequence EMPTY_SEQUENCE = new XmlSchemaSequence();

    private XmlSchemaUtils() {
    }

    static String cleanedUpSchemaSource(XmlSchemaObject subject) {
        if (subject.getSourceURI() == null) {
            return "";
        }
        return subject.getSourceURI() + ":" + subject.getLineNumber();
    }

    public static void unsupportedConstruct(String messageKey, XmlSchemaType subject) {
        Message message = new Message(messageKey, LOG, new Object[]{subject.getQName(), XmlSchemaUtils.cleanedUpSchemaSource((XmlSchemaObject)subject)});
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public static void unsupportedConstruct(String messageKey, String what, QName subjectName, XmlSchemaObject subject) {
        Message message = new Message(messageKey, LOG, new Object[]{what, subjectName == null ? "anonymous" : subjectName, XmlSchemaUtils.cleanedUpSchemaSource(subject)});
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public static QName getBaseType(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content = model.getContent();
        if (content == null) {
            return null;
        }
        if (!(content instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content;
        return ext.getBaseTypeName();
    }

    public static XmlSchemaSequence getContentSequence(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content = model.getContent();
        if (content == null) {
            return null;
        }
        if (!(content instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content;
        XmlSchemaParticle particle = ext.getParticle();
        if (particle == null) {
            return null;
        }
        XmlSchemaSequence sequence = null;
        try {
            sequence = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            XmlSchemaUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", (XmlSchemaType)type);
        }
        return sequence;
    }

    public static XmlSchemaObjectCollection getContentAttributes(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content = model.getContent();
        if (content == null) {
            return null;
        }
        if (!(content instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content;
        return ext.getAttributes();
    }

    public static List<XmlSchemaObject> getContentElements(XmlSchemaComplexType type, SchemaCollection collection) {
        ArrayList<XmlSchemaObject> results = new ArrayList<XmlSchemaObject>();
        QName baseTypeName = XmlSchemaUtils.getBaseType(type);
        if (baseTypeName != null) {
            XmlSchemaComplexType baseType = (XmlSchemaComplexType)collection.getTypeByQName(baseTypeName);
            results.addAll(XmlSchemaUtils.getContentElements(baseType, collection));
            XmlSchemaSequence extSequence = XmlSchemaUtils.getContentSequence(type);
            for (int i = 0; i < extSequence.getItems().getCount(); ++i) {
                results.add(extSequence.getItems().getItem(i));
            }
            return results;
        }
        XmlSchemaSequence sequence = XmlSchemaUtils.getSequence(type);
        for (int i = 0; i < sequence.getItems().getCount(); ++i) {
            results.add(sequence.getItems().getItem(i));
        }
        return results;
    }

    public static List<XmlSchemaAnnotated> getContentAttributes(XmlSchemaComplexType type, SchemaCollection collection) {
        ArrayList<XmlSchemaAnnotated> results = new ArrayList<XmlSchemaAnnotated>();
        QName baseTypeName = XmlSchemaUtils.getBaseType(type);
        if (baseTypeName != null) {
            XmlSchemaComplexType baseType = (XmlSchemaComplexType)collection.getTypeByQName(baseTypeName);
            results.addAll(XmlSchemaUtils.getContentAttributes(baseType, collection));
            XmlSchemaObjectCollection extAttrs = XmlSchemaUtils.getContentAttributes(type);
            for (int i = 0; i < extAttrs.getCount(); ++i) {
                results.add((XmlSchemaAnnotated)extAttrs.getItem(i));
            }
            return results;
        }
        XmlSchemaObjectCollection attrs = type.getAttributes();
        for (int i = 0; i < attrs.getCount(); ++i) {
            results.add((XmlSchemaAnnotated)attrs.getItem(i));
        }
        return results;
    }

    public static XmlSchemaSequence getSequence(XmlSchemaComplexType type) {
        XmlSchemaParticle particle = type.getParticle();
        XmlSchemaSequence sequence = null;
        if (particle == null) {
            return EMPTY_SEQUENCE;
        }
        try {
            sequence = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            XmlSchemaUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", (XmlSchemaType)type);
        }
        return sequence;
    }

    public static XmlSchemaElement findElementByRefName(SchemaCollection xmlSchemaCollection, QName name, String referencingURI) {
        String uri = name.getNamespaceURI();
        if ("".equals(uri)) {
            uri = referencingURI;
        }
        QName copyName = new QName(uri, name.getLocalPart());
        XmlSchemaElement target = xmlSchemaCollection.getElementByQName(copyName);
        assert (target != null);
        return target;
    }

    public static XmlSchemaType getElementType(SchemaCollection xmlSchemaCollection, String referencingURI, XmlSchemaElement element, XmlSchemaType containingType) {
        if (element.getSchemaTypeName() != null) {
            XmlSchemaType type = xmlSchemaCollection.getTypeByQName(element.getSchemaTypeName());
            if (type == null) {
                Message message = new Message("ELEMENT_TYPE_MISSING", LOG, new Object[]{element.getQName(), element.getSchemaTypeName().toString()});
                throw new UnsupportedConstruct(message);
            }
            return type;
        }
        assert (element != null);
        if (xmlSchemaCollection.getSchemaByTargetNamespace(referencingURI) == null) {
            referencingURI = null;
        }
        if (referencingURI == null && containingType != null) {
            referencingURI = containingType.getQName().getNamespaceURI();
        }
        XmlSchemaElement originalElement = element;
        while (element.getSchemaType() == null && element.getRefName() != null) {
            XmlSchemaElement nextElement = XmlSchemaUtils.findElementByRefName(xmlSchemaCollection, element.getRefName(), referencingURI);
            assert (nextElement != null);
            element = nextElement;
        }
        if (element.getSchemaType() == null) {
            XmlSchemaUtils.unsupportedConstruct("ELEMENT_HAS_NO_TYPE", originalElement.getName(), containingType.getQName(), (XmlSchemaObject)containingType);
        }
        return element.getSchemaType();
    }

    public static boolean isComplexType(XmlSchemaType type) {
        return type instanceof XmlSchemaComplexType;
    }

    public static boolean isElementNameQualified(XmlSchemaElement element, XmlSchema schema) {
        if (element.getRefName() != null) {
            throw new RuntimeException("isElementNameQualified on element with ref=");
        }
        if (element.getForm().equals((Object)QUALIFIED)) {
            return true;
        }
        if (element.getForm().equals((Object)UNQUALIFIED)) {
            return false;
        }
        return schema.getElementFormDefault().equals((Object)QUALIFIED);
    }

    public static boolean isAttributeNameQualified(XmlSchemaAttribute attribute, XmlSchema schema) {
        if (attribute.getRefName() != null) {
            throw new RuntimeException("isElementNameQualified on element with ref=");
        }
        if (attribute.getForm().equals((Object)QUALIFIED)) {
            return true;
        }
        if (attribute.getForm().equals((Object)UNQUALIFIED)) {
            return false;
        }
        return schema.getAttributeFormDefault().equals((Object)QUALIFIED);
    }

    public static boolean isElementQualified(XmlSchemaElement element, boolean global, XmlSchema localSchema, XmlSchema elementSchema) {
        if (element.getQName() == null) {
            throw new RuntimeException("getSchemaQualifier on anonymous element.");
        }
        if (element.getRefName() != null) {
            throw new RuntimeException("getSchemaQualified on the 'from' side of ref=.");
        }
        if (global) {
            return XmlSchemaUtils.isElementNameQualified(element, elementSchema) || localSchema != null && !element.getQName().getNamespaceURI().equals(localSchema.getTargetNamespace());
        }
        return XmlSchemaUtils.isElementNameQualified(element, elementSchema);
    }

    public static boolean isAttributeQualified(XmlSchemaAttribute attribute, boolean global, XmlSchema localSchema, XmlSchema attributeSchema) {
        if (attribute.getQName() == null) {
            throw new RuntimeException("getSchemaQualifier on anonymous element.");
        }
        if (attribute.getRefName() != null) {
            throw new RuntimeException("getSchemaQualified on the 'from' side of ref=.");
        }
        if (global) {
            return XmlSchemaUtils.isAttributeNameQualified(attribute, attributeSchema) || localSchema != null && !attribute.getQName().getNamespaceURI().equals(localSchema.getTargetNamespace());
        }
        return XmlSchemaUtils.isAttributeNameQualified(attribute, attributeSchema);
    }

    public static XmlSchemaParticle getObjectParticle(XmlSchemaObject object, QName contextName) {
        if (!(object instanceof XmlSchemaParticle)) {
            XmlSchemaUtils.unsupportedConstruct("NON_PARTICLE_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        if (!(object instanceof XmlSchemaElement) && !(object instanceof XmlSchemaAny)) {
            XmlSchemaUtils.unsupportedConstruct("GROUP_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaParticle)object;
    }

    public static XmlSchemaAnnotated getObjectAnnotated(XmlSchemaObject object, QName contextName) {
        if (!(object instanceof XmlSchemaAnnotated)) {
            XmlSchemaUtils.unsupportedConstruct("NON_ANNOTATED_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        if (!(object instanceof XmlSchemaAttribute) && !(object instanceof XmlSchemaAnyAttribute)) {
            XmlSchemaUtils.unsupportedConstruct("EXOTIC_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaAnnotated)object;
    }

    public static boolean isParticleArray(XmlSchemaParticle particle) {
        return particle.getMaxOccurs() > 1L;
    }

    public static boolean isParticleOptional(XmlSchemaParticle particle) {
        return particle.getMinOccurs() == 0L && particle.getMaxOccurs() == 1L;
    }

    public static XmlSchemaElement getReferredElement(XmlSchemaElement element, SchemaCollection xmlSchemaCollection) {
        if (element.getRefName() != null) {
            XmlSchemaElement refElement = xmlSchemaCollection.getElementByQName(element.getRefName());
            if (refElement == null) {
                throw new RuntimeException("Dangling reference");
            }
            return refElement;
        }
        return null;
    }
}

