/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.AbstractLoggingInterceptor;
import org.apache.cxf.ext.logging.LoggingOutputStream;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrintWriterEventSender;
import org.apache.cxf.ext.logging.slf4j.Slf4jVerboseEventSender;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

@NoJSR250Annotations
public class LoggingOutInterceptor
extends AbstractLoggingInterceptor {
    public LoggingOutInterceptor() {
        this(new Slf4jVerboseEventSender());
    }

    public LoggingOutInterceptor(PrintWriter writer) {
        this(new PrintWriterEventSender(writer));
    }

    public LoggingOutInterceptor(LogEventSender sender) {
        super("pre-stream", sender);
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        if (LoggingOutInterceptor.isLoggingDisabledNow(message)) {
            return;
        }
        this.createExchangeId(message);
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (os != null) {
            LoggingCallback callback = new LoggingCallback(this.sender, message, os, this.limit);
            message.setContent(OutputStream.class, (Object)this.createCachingOut(message, os, callback));
        } else {
            Writer iowriter = (Writer)message.getContent(Writer.class);
            if (iowriter != null) {
                message.setContent(Writer.class, (Object)new LogEventSendingWriter(this.sender, message, iowriter, this.limit));
            }
        }
    }

    private OutputStream createCachingOut(Message message, OutputStream os, CachedOutputStreamCallback callback) {
        LoggingOutputStream newOut = new LoggingOutputStream(os);
        if (this.threshold > 0L) {
            newOut.setThreshold(this.threshold);
        }
        if (this.limit > 0) {
            newOut.setCacheLimit(this.getCacheLimit());
        }
        newOut.registerCallback(callback);
        return newOut;
    }

    private int getCacheLimit() {
        if (this.limit == Integer.MAX_VALUE) {
            return this.limit;
        }
        return this.limit + 1;
    }

    public class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;
        private final int lim;
        private LogEventSender sender;

        public LoggingCallback(LogEventSender sender, Message msg, OutputStream os, int limit) {
            this.sender = sender;
            this.message = msg;
            this.origStream = os;
            this.lim = limit == -1 ? Integer.MAX_VALUE : limit;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LogEvent event = LoggingOutInterceptor.this.eventMapper.map(this.message, LoggingOutInterceptor.this.sensitiveProtocolHeaderNames);
            if (LoggingOutInterceptor.this.shouldLogContent(event)) {
                this.copyPayload(cos, event);
            } else {
                event.setPayload("--- Content suppressed ---");
            }
            this.sender.send(event);
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
        }

        private void copyPayload(CachedOutputStream cos, LogEvent event) {
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                StringBuilder payload = new StringBuilder();
                this.writePayload(payload, cos, encoding, event.getContentType());
                String maskedContent = LoggingOutInterceptor.this.maskSensitiveElements(this.message, payload.toString());
                event.setPayload(LoggingOutInterceptor.this.transform(this.message, maskedContent));
                boolean isTruncated = cos.size() > (long)LoggingOutInterceptor.this.limit && LoggingOutInterceptor.this.limit != -1;
                event.setTruncated(isTruncated);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
            if (StringUtils.isEmpty((String)encoding)) {
                cos.writeCacheTo(builder, (long)this.lim);
            } else {
                cos.writeCacheTo(builder, encoding, (long)this.lim);
            }
        }
    }

    private class LogEventSendingWriter
    extends FilterWriter {
        StringWriter out2;
        int count;
        Message message;
        final int lim;
        private LogEventSender sender;

        LogEventSendingWriter(LogEventSender sender, Message message, Writer writer, int limit) {
            super(writer);
            this.sender = sender;
            this.message = message;
            if (!(writer instanceof StringWriter)) {
                this.out2 = new StringWriter();
            }
            this.lim = limit == -1 ? Integer.MAX_VALUE : limit;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(c);
            }
            ++this.count;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(cbuf, off, len);
            }
            this.count += len;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(str, off, len);
            }
            this.count += len;
        }

        @Override
        public void close() throws IOException {
            LogEvent event = LoggingOutInterceptor.this.eventMapper.map(this.message, LoggingOutInterceptor.this.sensitiveProtocolHeaderNames);
            StringWriter w2 = this.out2;
            if (w2 == null) {
                w2 = (StringWriter)this.out;
            }
            String payload = LoggingOutInterceptor.this.shouldLogContent(event) ? this.getPayload(event, w2) : "--- Content suppressed ---";
            String maskedContent = LoggingOutInterceptor.this.maskSensitiveElements(this.message, payload);
            event.setPayload(LoggingOutInterceptor.this.transform(this.message, maskedContent));
            this.sender.send(event);
            this.message.setContent(Writer.class, (Object)this.out);
            super.close();
        }

        private String getPayload(LogEvent event, StringWriter w2) {
            StringBuilder payload = new StringBuilder();
            this.writePayload(payload, w2, event);
            return payload.toString();
        }

        private void writePayload(StringBuilder builder, StringWriter stringWriter, LogEvent event) {
            StringBuffer buffer = stringWriter.getBuffer();
            if (buffer.length() > this.lim) {
                builder.append(buffer.subSequence(0, this.lim));
                event.setTruncated(true);
            } else {
                builder.append(buffer);
                event.setTruncated(false);
            }
        }
    }
}

