/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.xacml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.xacml.RequestComponentBuilder;
import org.apache.cxf.rt.security.xacml.XACMLRequestBuilder;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.joda.time.DateTime;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.SubjectType;
import org.w3c.dom.Element;

public class DefaultXACMLRequestBuilder
implements XACMLRequestBuilder {
    private String action = "execute";
    private boolean sendDateTime = true;
    private boolean sendFullRequestURL;

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getAction() {
        return this.action;
    }

    @Override
    public RequestType createRequest(Principal principal, List<String> roles, Message message) throws Exception {
        String issuer = this.getIssuer(message);
        List<String> resources = this.getResources(message);
        String actionToUse = this.getAction(message);
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>();
        AttributeValueType subjectIdAttributeValue = RequestComponentBuilder.createAttributeValueType(principal.getName());
        AttributeType subjectIdAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:subject:subject-id", "http://www.w3.org/2001/XMLSchema#string", issuer, Collections.singletonList(subjectIdAttributeValue));
        attributes.add(subjectIdAttribute);
        if (roles != null) {
            ArrayList<AttributeValueType> roleAttributes = new ArrayList<AttributeValueType>();
            for (String role : roles) {
                if (role == null) continue;
                AttributeValueType subjectRoleAttributeValue = RequestComponentBuilder.createAttributeValueType(role);
                roleAttributes.add(subjectRoleAttributeValue);
            }
            if (!roleAttributes.isEmpty()) {
                AttributeType subjectRoleAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:2.0:subject:role", "http://www.w3.org/2001/XMLSchema#anyURI", issuer, roleAttributes);
                attributes.add(subjectRoleAttribute);
            }
        }
        SubjectType subjectType = RequestComponentBuilder.createSubjectType(attributes, null);
        attributes.clear();
        for (String resource : resources) {
            if (resource == null) continue;
            AttributeValueType resourceAttributeValue = RequestComponentBuilder.createAttributeValueType(resource);
            AttributeType resourceAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://www.w3.org/2001/XMLSchema#string", null, Collections.singletonList(resourceAttributeValue));
            attributes.add(resourceAttribute);
        }
        ResourceType resourceType = RequestComponentBuilder.createResourceType(attributes, null);
        AttributeValueType actionAttributeValue = RequestComponentBuilder.createAttributeValueType(actionToUse);
        AttributeType actionAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:action:action-id", "http://www.w3.org/2001/XMLSchema#string", null, Collections.singletonList(actionAttributeValue));
        attributes.clear();
        attributes.add(actionAttribute);
        ActionType actionType = RequestComponentBuilder.createActionType(attributes);
        attributes.clear();
        if (this.sendDateTime) {
            DateTime dateTime = new DateTime();
            AttributeValueType environmentAttributeValue = RequestComponentBuilder.createAttributeValueType(dateTime.toString());
            AttributeType environmentAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:environment:current-dateTime", "http://www.w3.org/2001/XMLSchema#dateTime", null, Collections.singletonList(environmentAttributeValue));
            attributes.add(environmentAttribute);
        }
        EnvironmentType environmentType = RequestComponentBuilder.createEnvironmentType(attributes);
        RequestType request = RequestComponentBuilder.createRequestType(Collections.singletonList(subjectType), Collections.singletonList(resourceType), actionType, environmentType);
        return request;
    }

    private String getIssuer(Message message) throws WSSecurityException {
        Element assertionElement;
        SecurityContext sc = message.get(SecurityContext.class);
        if (sc instanceof SAMLSecurityContext && (assertionElement = ((SAMLSecurityContext)sc).getAssertionElement()) != null) {
            AssertionWrapper wrapper = new AssertionWrapper(assertionElement);
            return wrapper.getIssuerString();
        }
        return null;
    }

    public boolean isSendDateTime() {
        return this.sendDateTime;
    }

    public void setSendDateTime(boolean sendDateTime) {
        this.sendDateTime = sendDateTime;
    }

    public boolean isSendFullRequestURL() {
        return this.sendFullRequestURL;
    }

    public void setSendFullRequestURL(boolean sendFullRequestURL) {
        this.sendFullRequestURL = sendFullRequestURL;
    }

    @Override
    public List<String> getResources(Message message) {
        if (message == null) {
            return Collections.emptyList();
        }
        ArrayList<String> resources = new ArrayList<String>();
        if (message.get("javax.xml.ws.wsdl.operation") != null) {
            resources.add(message.get("javax.xml.ws.wsdl.operation").toString());
        }
        if (this.sendFullRequestURL) {
            resources.add((String)message.get("org.apache.cxf.request.url"));
        } else {
            resources.add((String)message.get("org.apache.cxf.request.uri"));
        }
        return resources;
    }

    @Override
    public String getResource(Message message) {
        if (message == null) {
            return null;
        }
        String resource = null;
        resource = this.sendFullRequestURL ? (String)message.get("org.apache.cxf.request.url") : (message.get("javax.xml.ws.wsdl.operation") != null ? message.get("javax.xml.ws.wsdl.operation").toString() : (String)message.get("org.apache.cxf.request.uri"));
        return resource;
    }

    private String getAction(Message message) {
        String actionToUse = this.action;
        if (message.get("javax.xml.ws.wsdl.operation") == null && message.get("org.apache.cxf.request.method") != null) {
            actionToUse = (String)message.get("org.apache.cxf.request.method");
        }
        return actionToUse;
    }
}

