/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.visitor;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckStatement;
import org.apache.cxf.jaxrs.ext.search.visitor.PropertyValidator;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public abstract class AbstractSearchConditionVisitor<T, E>
implements SearchConditionVisitor<T, E> {
    private Map<String, String> fieldMap;
    private Map<String, Class<?>> primitiveFieldTypeMap;
    private PropertyValidator<Object> validator;

    protected AbstractSearchConditionVisitor(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    protected String getRealPropertyName(String name) {
        if (this.fieldMap != null && this.fieldMap.containsKey(name)) {
            return this.fieldMap.get(name);
        }
        return name;
    }

    protected Class<?> getPrimitiveFieldClass(String name, Class<?> valueCls) {
        return this.getPrimitiveFieldClass(name, valueCls, null).getCls();
    }

    protected ClassValue getPrimitiveFieldClass(String name, Class<?> valueCls, Object value) {
        return this.getPrimitiveFieldClass(null, name, valueCls, valueCls, value);
    }

    protected ClassValue getPrimitiveFieldClass(PrimitiveStatement ps, String name, Class<?> valueCls, Type type, Object value) {
        return this.doGetPrimitiveFieldClass(ps, name, valueCls, type, value, new HashSet<String>());
    }

    private ClassValue doGetPrimitiveFieldClass(PrimitiveStatement ps, String name, Class<?> valueCls, Type type, Object value, Set<String> set) {
        boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(valueCls);
        Class<?> actualCls = isCollection ? InjectionUtils.getActualType(type) : valueCls;
        CollectionCheckInfo collInfo = null;
        int index = name.indexOf(".");
        if (index != -1) {
            String[] names = name.split("\\.");
            name = name.substring(index + 1);
            if (value != null && !InjectionUtils.isPrimitive(actualCls)) {
                try {
                    String nextPart = names[1];
                    nextPart = nextPart.length() == 1 ? nextPart.toUpperCase() : Character.toUpperCase(nextPart.charAt(0)) + nextPart.substring(1);
                    Method m = actualCls.getMethod("get" + nextPart, new Class[0]);
                    if (isCollection) {
                        value = ((Collection)value).iterator().next();
                        set.add(names[0]);
                    }
                    value = m.invoke(value, new Object[0]);
                    valueCls = value.getClass();
                    type = m.getGenericReturnType();
                }
                catch (Throwable ex) {
                    throw new RuntimeException();
                }
                return this.doGetPrimitiveFieldClass(ps, name, valueCls, type, value, set);
            }
        } else if (isCollection) {
            set.add(name);
            Collection coll = (Collection)value;
            value = coll.isEmpty() ? null : coll.iterator().next();
            valueCls = actualCls;
            if (ps instanceof CollectionCheckStatement) {
                collInfo = ((CollectionCheckStatement)ps).getCollectionCheckInfo();
            }
        }
        Class<?> cls = null;
        if (this.primitiveFieldTypeMap != null) {
            cls = this.primitiveFieldTypeMap.get(name);
        }
        if (cls == null) {
            cls = valueCls;
        }
        return new ClassValue(cls, value, collInfo, set);
    }

    public void setPrimitiveFieldTypeMap(Map<String, Class<?>> primitiveFieldTypeMap) {
        this.primitiveFieldTypeMap = primitiveFieldTypeMap;
    }

    public SearchConditionVisitor<T, E> visitor() {
        return this;
    }

    protected void validatePropertyValue(String name, Object value) {
        if (this.validator != null) {
            this.validator.validate(name, value);
        }
    }

    public void setValidator(PropertyValidator<Object> validator) {
        this.validator = validator;
    }

    protected class ClassValue {
        private Class<?> cls;
        private Object value;
        private CollectionCheckInfo collInfo;
        private Set<String> collectionProps;

        public ClassValue(Class<?> cls, Object value, CollectionCheckInfo collInfo, Set<String> collectionProps) {
            this.cls = cls;
            this.value = value;
            this.collInfo = collInfo;
            this.collectionProps = collectionProps;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public void setCls(Class<?> cls) {
            this.cls = cls;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public CollectionCheckInfo getCollectionCheckInfo() {
            return this.collInfo;
        }

        public boolean isCollection(String name) {
            return this.collectionProps != null && this.collectionProps.contains(name);
        }
    }
}

