/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInvoker.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private static final String LAST_SERVICE_OBJECT = "org.apache.cxf.service.object.last";
    private static final String REQUEST_WAS_SUSPENDED = "org.apache.cxf.service.request.suspended";
    private static final String PROXY_INVOCATION_ERROR_FRAGMENT = "object is not an instance of declaring class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Exchange exchange, Object request) {
        boolean suspended;
        Object object;
        AsyncResponse asyncResp;
        Response response = exchange.get(Response.class);
        if (response == null && (asyncResp = exchange.get(AsyncResponse.class)) != null) {
            AsyncResponseImpl asyncImpl = (AsyncResponseImpl)asyncResp;
            asyncImpl.prepareContinuation();
            asyncImpl.handleTimeout();
            return this.handleAsyncResponse(exchange, asyncImpl.getResponseObject());
        }
        if (response != null) {
            return new MessageContentsList(response);
        }
        ResourceProvider provider = this.getResourceProvider(exchange);
        Object rootInstance = this.getServiceObject(exchange);
        Object serviceObject = this.getActualServiceObject(exchange, rootInstance);
        try {
            object = this.invoke(exchange, request, serviceObject);
            boolean bl = suspended = exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
        }
        catch (Throwable throwable) {
            boolean suspended2;
            boolean bl = suspended2 = exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
            if (!suspended2) {
                if (exchange.isOneWay()) {
                    ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
                }
                if (!this.isServiceObjectRequestScope(exchange.getInMessage())) {
                    provider.releaseInstance(exchange.getInMessage(), rootInstance);
                } else {
                    this.persistRoots(exchange, rootInstance, provider);
                }
            } else {
                this.persistRoots(exchange, rootInstance, provider);
                exchange.put(REQUEST_WAS_SUSPENDED, true);
            }
            throw throwable;
        }
        if (!suspended) {
            if (exchange.isOneWay()) {
                ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
            }
            if (!this.isServiceObjectRequestScope(exchange.getInMessage())) {
                provider.releaseInstance(exchange.getInMessage(), rootInstance);
            } else {
                this.persistRoots(exchange, rootInstance, provider);
            }
        } else {
            this.persistRoots(exchange, rootInstance, provider);
            exchange.put(REQUEST_WAS_SUSPENDED, true);
        }
        return object;
    }

    private Object handleAsyncResponse(Exchange exchange, Object asyncObj) {
        if (asyncObj instanceof Throwable) {
            return this.handleFault(new Fault((Throwable)asyncObj), exchange.getInMessage(), null, null);
        }
        return new MessageContentsList(asyncObj);
    }

    private void persistRoots(Exchange exchange, Object rootInstance, Object provider) {
        exchange.put("service.root.instance", rootInstance);
        exchange.put("service.root.provider", provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        boolean wasSuspended;
        OperationResourceInfo ori = exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Message inMessage = exchange.getInMessage();
        ProviderFactory providerFactory = ProviderFactory.getInstance(inMessage);
        boolean bl = wasSuspended = exchange.remove(REQUEST_WAS_SUSPENDED) != null;
        if (!wasSuspended) {
            ProviderInfo appProvider;
            this.pushOntoStack(ori, ClassHelper.getRealClass(resourceObject), inMessage);
            boolean contextsAvailable = cri.contextsAvailable();
            boolean paramsAvailable = cri.paramsAvailable();
            if (contextsAvailable || paramsAvailable) {
                Object realResourceObject = ClassHelper.getRealObject(resourceObject);
                if (paramsAvailable) {
                    JAXRSUtils.injectParameters(ori, realResourceObject, inMessage);
                }
                if (contextsAvailable) {
                    InjectionUtils.injectContexts(realResourceObject, cri, inMessage);
                }
            }
            if (cri.isRoot() && (appProvider = (ProviderInfo)exchange.getEndpoint().get(Application.class.getName())) != null) {
                InjectionUtils.injectContexts(appProvider.getProvider(), appProvider, inMessage);
            }
        }
        Method methodToInvoke = InjectionUtils.checkProxy(cri.getMethodDispatcher().getMethod(ori), resourceObject);
        MessageContentsList params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)request);
        } else if (request != null) {
            params = new MessageContentsList(request);
        }
        Object result = null;
        ClassLoaderUtils.ClassLoaderHolder contextLoader = null;
        try {
            if (this.setServiceLoaderAsContextLoader(inMessage)) {
                contextLoader = ClassLoaderUtils.setThreadContextClassloader(resourceObject.getClass().getClassLoader());
            }
            AsyncResponseImpl asyncResponse = null;
            if (!ori.isSubResourceLocator()) {
                asyncResponse = (AsyncResponseImpl)inMessage.get(AsyncResponse.class);
            }
            result = this.invoke(exchange, resourceObject, methodToInvoke, params);
            if (asyncResponse != null) {
                if (!asyncResponse.isSuspended() && !asyncResponse.isResumedByApplication()) {
                    asyncResponse.suspendContinuation();
                } else {
                    result = this.handleAsyncResponse(exchange, asyncResponse.getResponseObject());
                }
            }
        }
        catch (Fault ex) {
            Object object = this.handleFault(ex, inMessage, cri, methodToInvoke);
            return object;
        }
        finally {
            exchange.put(LAST_SERVICE_OBJECT, resourceObject);
            if (contextLoader != null) {
                contextLoader.reset();
            }
        }
        ClassResourceInfo subCri = null;
        if (ori.isSubResourceLocator()) {
            try {
                MultivaluedMap<String, String> values = this.getTemplateValues(inMessage);
                String subResourcePath = (String)values.getFirst((Object)"FINAL_MATCH_GROUP");
                String httpMethod = (String)inMessage.get("org.apache.cxf.request.method");
                String contentType = (String)inMessage.get("Content-Type");
                if (contentType == null) {
                    contentType = "*/*";
                }
                List acceptContentType = (List)exchange.get("Accept");
                result = JAXRSInvoker.checkResultObject(result, subResourcePath);
                subCri = cri.getSubResource(methodToInvoke.getReturnType(), ClassHelper.getRealClass(result), result);
                if (subCri == null) {
                    org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, subResourcePath);
                    LOG.severe(errorM.toString());
                    throw new NotFoundException();
                }
                OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(subCri, inMessage, httpMethod, values, contentType, acceptContentType, true);
                exchange.put(OperationResourceInfo.class, subOri);
                inMessage.put("jaxrs.template.parameters", values);
                if (JAXRSUtils.runContainerRequestFilters(providerFactory, inMessage, false, subOri.getNameBindings())) {
                    return new MessageContentsList(exchange.get(Response.class));
                }
                List<Object> newParams = JAXRSUtils.processParameters(subOri, values, inMessage);
                inMessage.setContent(List.class, newParams);
                return this.invoke(exchange, newParams, result);
            }
            catch (IOException ex) {
                Response resp = JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
                if (resp == null) {
                    resp = JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
                }
                return new MessageContentsList(resp);
            }
            catch (WebApplicationException ex) {
                Response excResponse = JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), (String)exchange.getInMessage().get("org.apache.cxf.request.method")) ? JAXRSUtils.createResponse(subCri, null, null, 200, true) : JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
                return new MessageContentsList(excResponse);
            }
        }
        return result;
    }

    private Object handleFault(Fault ex, Message inMessage, ClassResourceInfo cri, Method methodToInvoke) {
        Response excResponse;
        String errorMessage = ex.getCause().getMessage();
        if (errorMessage != null && cri != null && errorMessage.contains(PROXY_INVOCATION_ERROR_FRAGMENT)) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("PROXY_INVOCATION_FAILURE", BUNDLE, methodToInvoke, cri.getServiceClass().getName());
            LOG.severe(errorM.toString());
        }
        if ((excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause(), inMessage)) == null) {
            ProviderFactory.getInstance(inMessage).clearThreadLocalProxies();
            ClassResourceInfo criRoot = (ClassResourceInfo)inMessage.getExchange().get("root.resource.class");
            if (criRoot != null) {
                criRoot.clearThreadLocalProxies();
            }
            inMessage.getExchange().put(Message.PROPOGATE_EXCEPTION, JAXRSUtils.propogateException(inMessage));
            throw ex;
        }
        return new MessageContentsList(excResponse);
    }

    protected MultivaluedMap<String, String> getTemplateValues(Message msg) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get("jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll((Map)oldValues);
        }
        return values;
    }

    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    private boolean isServiceObjectRequestScope(Message inMessage) {
        Object scope = inMessage.getContextualProperty(SERVICE_OBJECT_SCOPE);
        return REQUEST_SCOPE.equals(scope);
    }

    private ResourceProvider getResourceProvider(Exchange exchange) {
        Object provider = exchange.remove("service.root.provider");
        if (provider == null) {
            OperationResourceInfo ori = exchange.get(OperationResourceInfo.class);
            ClassResourceInfo cri = ori.getClassResourceInfo();
            return cri.getResourceProvider();
        }
        return (ResourceProvider)provider;
    }

    @Override
    public Object getServiceObject(Exchange exchange) {
        Object root = exchange.remove("service.root.instance");
        if (root != null) {
            return root;
        }
        OperationResourceInfo ori = exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        return cri.getResourceProvider().getInstance(exchange.getInMessage());
    }

    protected Object getActualServiceObject(Exchange exchange, Object rootInstance) {
        Object last = exchange.get(LAST_SERVICE_OBJECT);
        return last != null ? last : rootInstance;
    }

    private static Object checkResultObject(Object result, String subResourcePath) {
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        if (result == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, subResourcePath);
            LOG.info(errorM.toString());
            throw new NotFoundException();
        }
        return result;
    }

    private void pushOntoStack(OperationResourceInfo ori, Class<?> realClass, Message msg) {
        OperationResourceInfoStack stack = msg.get(OperationResourceInfoStack.class);
        if (stack == null) {
            stack = new OperationResourceInfoStack();
            msg.put(OperationResourceInfoStack.class, stack);
        }
        MultivaluedMap params = (MultivaluedMap)msg.get("jaxrs.template.parameters");
        List<String> values = null;
        if (params == null || params.size() == 1) {
            values = Collections.emptyList();
        } else {
            values = new ArrayList<String>(params.size() - 1);
            for (Parameter pm : ori.getParameters()) {
                List paramValues;
                if (pm.getType() != ParameterType.PATH || (paramValues = (List)params.get((Object)pm.getName())) == null) continue;
                values.addAll(paramValues);
            }
        }
        stack.push(new MethodInvocationInfo(ori, realClass, values));
    }
}

