/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.xmlbeans.DataReaderImpl;
import org.apache.cxf.xmlbeans.DataWriterImpl;
import org.apache.cxf.xmlbeans.NodeDataWriterImpl;
import org.apache.cxf.xmlbeans.XmlBeansSchemaInitializer;
import org.apache.cxf.xmlbeans.XmlBeansWrapperHelper;
import org.w3c.dom.Node;

public class XmlBeansDataBinding
extends AbstractDataBinding
implements WrapperCapableDatabinding {
    public static final String XMLBEANS_NAMESPACE_HACK = XmlBeansDataBinding.class.getName() + ".NamespaceHack";
    private static final Logger LOG = LogUtils.getLogger(XmlBeansDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{XMLStreamWriter.class, Node.class};

    @Override
    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (c == XMLStreamWriter.class) {
            return new DataWriterImpl();
        }
        if (c == Node.class) {
            return new NodeDataWriterImpl();
        }
        return null;
    }

    @Override
    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl();
        }
        return dr;
    }

    @Override
    public Map<String, String> getDeclaredNamespaceMappings() {
        return null;
    }

    @Override
    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    @Override
    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    @Override
    public void initialize(Service service) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Creating XmlBeansDatabinding for " + service.getName());
        }
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) continue;
            XmlBeansSchemaInitializer schemaInit = new XmlBeansSchemaInitializer(serviceInfo, col, this);
            schemaInit.walk();
        }
    }

    @Override
    public WrapperHelper createWrapperHelper(Class<?> wrapperType, QName wrapperName, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList fields = new ArrayList(partNames.size());
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                continue;
            }
            String getAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            Class<?> valueClass = XmlBeansWrapperHelper.getXMLBeansValueType(wrapperType);
            Method[] allMethods = valueClass.getMethods();
            try {
                getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
            }
            catch (NoSuchMethodException ex) {
                try {
                    getMethod = valueClass.getMethod(getAccessor + "Array", AbstractWrapperHelper.NO_CLASSES);
                    getAccessor = getAccessor + "Array";
                    setAccessor = setAccessor + "Array";
                }
                catch (NoSuchMethodException ex2) {
                    // empty catch block
                }
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            fields.add(null);
        }
        return new XmlBeansWrapperHelper(wrapperType, setMethods.toArray(new Method[setMethods.size()]), getMethods.toArray(new Method[getMethods.size()]), fields.toArray(new Field[fields.size()]));
    }
}

