/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class OperationResourceInfoComparator
implements Comparator<OperationResourceInfo> {
    private String httpMethod;
    private boolean getMethod;
    private Message message;
    private ResourceComparator rc;
    private MediaType contentType = MediaType.WILDCARD_TYPE;
    private List<MediaType> acceptTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);

    public OperationResourceInfoComparator(Message m, String method) {
        Object o;
        this.message = m;
        if (this.message != null && (o = m.getExchange().get(Endpoint.class).get("org.apache.cxf.jaxrs.comparator")) != null) {
            this.rc = (ResourceComparator)o;
        }
        this.httpMethod = method;
    }

    public OperationResourceInfoComparator(Message m, String httpMethod, boolean getMethod, MediaType contentType, List<MediaType> acceptTypes) {
        this(m, httpMethod);
        this.contentType = contentType;
        this.acceptTypes = acceptTypes;
        this.getMethod = getMethod;
    }

    @Override
    public int compare(OperationResourceInfo e1, OperationResourceInfo e2) {
        int result;
        if (this.rc != null && (result = this.rc.compare(e1, e2, this.message)) != 0) {
            return result;
        }
        if (!this.getMethod && "HEAD".equals(this.httpMethod)) {
            if ("HEAD".equals(e1.getHttpMethod())) {
                return -1;
            }
            if ("HEAD".equals(e2.getHttpMethod())) {
                return 1;
            }
        }
        if ((result = URITemplate.compareTemplates(e1.getURITemplate(), e2.getURITemplate())) == 0 && (e1.getHttpMethod() != null && e2.getHttpMethod() == null || e1.getHttpMethod() == null && e2.getHttpMethod() != null)) {
            return e1.getHttpMethod() != null ? -1 : 1;
        }
        if (result == 0 && !this.getMethod) {
            result = JAXRSUtils.compareSortedConsumesMediaTypes(e1.getConsumeTypes(), e2.getConsumeTypes(), this.contentType);
        }
        if (result == 0) {
            result = JAXRSUtils.compareSortedAcceptMediaTypes(e1.getProduceTypes(), e2.getProduceTypes(), this.acceptTypes);
        }
        return result;
    }
}

