/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.kerberos;

import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.kerberos.KerberosClient;

public final class KerberosUtils {
    private KerberosUtils() {
    }

    public static KerberosClient getClient(Message message, String type) {
        KerberosClient client = (KerberosClient)message.getContextualProperty("ws-security.kerberos.client");
        if (client == null) {
            client = new KerberosClient();
            String jaasContext = (String)message.getContextualProperty("ws-security.kerberos.jaas.context");
            String kerberosSpn = (String)message.getContextualProperty("ws-security.kerberos.spn");
            CallbackHandler callbackHandler = KerberosUtils.getCallbackHandler(message.getContextualProperty("ws-security.callback-handler"));
            client.setContextName(jaasContext);
            client.setServiceName(kerberosSpn);
            client.setCallbackHandler(callbackHandler);
        }
        return client;
    }

    private static CallbackHandler getCallbackHandler(Object o) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, KerberosUtils.class).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }
}

