/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.util.UID;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.message.Attachment;

public final class AttachmentUtil {
    private AttachmentUtil() {
    }

    public static String createContentID(String ns) {
        String uid = UID.generate();
        try {
            URI uri = new URI(ns);
            return uid + "@" + uri;
        }
        catch (URISyntaxException e) {
            throw new DatabindingException("Could not create URI for namespace: " + ns);
        }
    }

    public static Attachment getAttachment(String id, Collection<Attachment> attachments) {
        if (id == null) {
            throw new DatabindingException("Cannot get attachment: null id");
        }
        int i = id.indexOf("cid:");
        if (i != -1) {
            id = id.substring(4).trim();
        }
        if (attachments == null) {
            return null;
        }
        for (Attachment a : attachments) {
            if (!a.getId().equals(id)) continue;
            return a;
        }
        try {
            URLDataSource source = new URLDataSource(new URL(id));
            return new AttachmentImpl(id, new DataHandler((DataSource)source));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

