/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class LuceneQueryVisitor<T>
extends AbstractSearchConditionVisitor<T, Query> {
    private String contentsFieldName;
    private Map<String, String> contentsFieldMap;
    private Stack<List<Query>> queryStack = new Stack();

    public LuceneQueryVisitor() {
        this(Collections.emptyMap());
    }

    public LuceneQueryVisitor(String contentsFieldAlias, String contentsFieldName) {
        this(Collections.singletonMap(contentsFieldAlias, contentsFieldName));
    }

    public LuceneQueryVisitor(String contentsFieldName) {
        this(Collections.emptyMap(), contentsFieldName);
    }

    public LuceneQueryVisitor(Map<String, String> fieldsMap) {
        this(fieldsMap, null);
    }

    public LuceneQueryVisitor(Map<String, String> fieldsMap, String contentsFieldName) {
        super(fieldsMap);
        this.contentsFieldName = contentsFieldName;
        this.queryStack.push(new ArrayList());
    }

    public void setContentsFieldMap(Map<String, String> map) {
        this.contentsFieldMap = map;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                this.queryStack.peek().add(this.buildSimpleQuery(sc.getConditionType(), statement.getProperty(), statement.getValue()));
            }
        } else {
            this.queryStack.push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            boolean orCondition = sc.getConditionType() == ConditionType.OR;
            List<Query> queries = this.queryStack.pop();
            this.queryStack.peek().add(this.createCompositeQuery(queries, orCondition));
        }
    }

    @Override
    public Query getQuery() {
        List<Query> queries = this.queryStack.peek();
        return queries.isEmpty() ? null : queries.get(0);
    }

    private Query buildSimpleQuery(ConditionType ct, String name, Object value) {
        name = super.getRealPropertyName(name);
        Class<?> clazz = this.getPrimitiveFieldClass(name, value.getClass());
        Query query = null;
        switch (ct) {
            case EQUALS: {
                query = this.createEqualsQuery(clazz, name, value);
                break;
            }
            case NOT_EQUALS: {
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add(this.createEqualsQuery(clazz, name, value), BooleanClause.Occur.MUST_NOT);
                query = booleanQuery;
                break;
            }
            case GREATER_THAN: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case GREATER_OR_EQUALS: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case LESS_THAN: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case LESS_OR_EQUALS: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
        }
        return query;
    }

    private Query createEqualsQuery(Class<?> cls, String name, Object value) {
        Object query = null;
        if (cls == String.class) {
            String strValue = value.toString();
            int wildCardIndex = strValue.indexOf(42);
            String theContentsFieldName = this.getContentsFieldName(name);
            if (theContentsFieldName == null) {
                Term term = new Term(name, strValue);
                query = wildCardIndex == -1 ? new TermQuery(term) : new WildcardQuery(term);
            } else if (wildCardIndex == -1) {
                PhraseQuery pquery = new PhraseQuery();
                pquery.add(new Term(theContentsFieldName, name));
                pquery.add(new Term(theContentsFieldName, strValue));
                query = pquery;
            } else {
                BooleanQuery pquery = new BooleanQuery();
                pquery.add((Query)new TermQuery(new Term(theContentsFieldName, name)), BooleanClause.Occur.MUST);
                pquery.add((Query)new WildcardQuery(new Term(theContentsFieldName, strValue)), BooleanClause.Occur.MUST);
                query = pquery;
            }
        } else {
            query = this.createRangeQuery(cls, name, value, ConditionType.EQUALS);
        }
        return query;
    }

    private String getContentsFieldName(String name) {
        String fieldName = null;
        if (this.contentsFieldMap != null) {
            fieldName = this.contentsFieldMap.get(name);
        }
        if (fieldName == null) {
            fieldName = this.contentsFieldName;
        }
        return fieldName;
    }

    private Query createRangeQuery(Class<?> cls, String name, Object value, ConditionType type) {
        if (String.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls)) {
            Integer intValue = Integer.valueOf(value.toString());
            Integer min = type == ConditionType.LESS_THAN || type == ConditionType.LESS_OR_EQUALS ? null : intValue;
            Integer max = type == ConditionType.GREATER_THAN || type == ConditionType.GREATER_OR_EQUALS ? null : intValue;
            boolean minInclusive = type == ConditionType.GREATER_OR_EQUALS || type == ConditionType.EQUALS;
            boolean maxInclusive = type == ConditionType.LESS_OR_EQUALS || type == ConditionType.EQUALS;
            NumericRangeQuery query = NumericRangeQuery.newIntRange((String)name, (Integer)min, (Integer)max, (boolean)minInclusive, (boolean)maxInclusive);
            return query;
        }
        if (Date.class.isAssignableFrom(cls)) {
            String luceneDateValue = DateTools.dateToString((Date)((Date)value), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
            String expression = null;
            expression = type == ConditionType.LESS_THAN ? "[ TO " + luceneDateValue + "]" : "[" + luceneDateValue + " TO " + DateTools.dateToString((Date)new Date(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND) + "]";
            return this.parseExpression(name, expression);
        }
        return null;
    }

    private Query createCompositeQuery(List<Query> queries, boolean orCondition) {
        BooleanClause.Occur clause = orCondition ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Query query : queries) {
            booleanQuery.add(query, clause);
        }
        return booleanQuery;
    }

    protected Query parseExpression(String fieldName, String expression) {
        return null;
    }
}

