/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UsernameTokenInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(UsernameTokenInterceptor.class);
    private static final Set<QName> HEADERS = new HashSet<QName>();

    public UsernameTokenInterceptor() {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addAfter(PolicyBasedWSS4JOutInterceptor.class.getName());
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        boolean isOut;
        boolean isReq = MessageUtils.isRequestor(message);
        if (isReq != (isOut = MessageUtils.isOutbound(message))) {
            this.assertUsernameTokens(message, null);
            return;
        }
        if (isReq) {
            if (message.containsKey(PolicyBasedWSS4JOutInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.addUsernameToken(message);
        } else {
            if (message.containsKey(WSS4JInInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.processUsernameToken(message);
        }
    }

    private void processUsernameToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement(el);
        while (child != null) {
            if ("UsernameToken".equals(child.getLocalName())) {
                try {
                    WSUsernameTokenPrincipal princ = this.getPrincipal(child, message);
                    if (princ != null) {
                        ArrayList<WSSecurityEngineResult> v = new ArrayList<WSSecurityEngineResult>();
                        int action = 1;
                        if (princ.getPassword() == null) {
                            action = 8192;
                        }
                        v.add(0, new WSSecurityEngineResult(action, (Principal)princ, null, null, null));
                        List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                        if (results == null) {
                            results = new ArrayList();
                            message.put("RECV_RESULTS", (Object)results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, v);
                        results.add(0, rResult);
                        this.assertUsernameTokens(message, princ);
                        message.put("wss4j.principal.result", (Object)princ);
                        SecurityContext sc = message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            Subject subject = this.createSubject(princ.getName(), princ.getPassword(), princ.isPasswordDigest(), princ.getNonce(), princ.getCreatedTime());
                            message.put(SecurityContext.class, this.createSecurityContext((Principal)princ, subject));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    protected WSUsernameTokenPrincipal getPrincipal(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        boolean utWithCallbacks = MessageUtils.getContextualBoolean(message, "ws-security.validate.token", true);
        if (utWithCallbacks) {
            UsernameTokenProcessor p = new UsernameTokenProcessor();
            WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
            RequestData data = new RequestData(){

                public CallbackHandler getCallbackHandler() {
                    return UsernameTokenInterceptor.this.getCallback(message);
                }

                public Validator getValidator(QName qName) throws WSSecurityException {
                    Object validator = message.getContextualProperty("ws-security.ut.validator");
                    if (validator == null) {
                        return super.getValidator(qName);
                    }
                    return (Validator)validator;
                }
            };
            data.setWssConfig(WSSConfig.getNewInstance());
            List results = p.handleToken(tokenElement, data, wsDocInfo);
            return (WSUsernameTokenPrincipal)((WSSecurityEngineResult)results.get(0)).get((Object)"principal");
        }
        WSUsernameTokenPrincipal principal = this.parseTokenAndCreatePrincipal(tokenElement);
        WSS4JTokenConverter.convertToken(message, (Principal)principal);
        return principal;
    }

    protected WSUsernameTokenPrincipal parseTokenAndCreatePrincipal(Element tokenElement) throws WSSecurityException {
        org.apache.ws.security.message.token.UsernameToken ut = new org.apache.ws.security.message.token.UsernameToken(tokenElement);
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
        principal.setNonce(ut.getNonce());
        principal.setPassword(ut.getPassword());
        principal.setCreatedTime(ut.getCreated());
        principal.setPasswordType(ut.getPasswordType());
        return principal;
    }

    protected SecurityContext createSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) throws SecurityException {
        return null;
    }

    private UsernameToken assertUsernameTokens(SoapMessage message, WSUsernameTokenPrincipal princ) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        UsernameToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (UsernameToken)ai.getAssertion();
            if (princ != null && tok.isHashPassword() != princ.isPasswordDigest()) {
                ai.setNotAsserted("Password hashing policy not enforced");
                continue;
            }
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        return tok;
    }

    private void addUsernameToken(SoapMessage message) {
        UsernameToken tok = this.assertUsernameTokens(message, null);
        Header h = this.findSecurityHeader(message, true);
        WSSecUsernameToken utBuilder = this.addUsernameToken(message, tok);
        if (utBuilder == null) {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            Collection<AssertionInfo> ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
            for (AssertionInfo ai : ais) {
                if (!ai.isAsserted()) continue;
                ai.setAsserted(false);
            }
            return;
        }
        Element el = (Element)h.getObject();
        utBuilder.prepare(el.getOwnerDocument());
        el.appendChild(utBuilder.getUsernameTokenElement());
    }

    private Header findSecurityHeader(SoapMessage message, boolean create) {
        for (Header h : message.getHeaders()) {
            QName n = h.getName();
            if (!n.getLocalPart().equals("Security") || !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
            return h;
        }
        if (!create) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SoapHeader sh = new SoapHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), el);
        sh.setMustUnderstand(true);
        message.getHeaders().add(sh);
        return sh;
    }

    protected WSSecUsernameToken addUsernameToken(SoapMessage message, UsernameToken token) {
        String userName = (String)message.getContextualProperty("ws-security.username");
        WSSConfig wssConfig = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        if (!StringUtils.isEmpty(userName)) {
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                return utBuilder;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty(password)) {
                password = this.getPassword(userName, token, 2, message);
            }
            if (!StringUtils.isEmpty(password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                return utBuilder;
            }
            this.policyNotAsserted(token, "No username available", message);
        } else {
            this.policyNotAsserted(token, "No username available", message);
        }
        return null;
    }

    private CallbackHandler getCallback(SoapMessage message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    public String getPassword(String userName, UsernameToken info, int type, SoapMessage message) {
        CallbackHandler handler = this.getCallback(message);
        if (handler == null) {
            this.policyNotAsserted(info, "No callback handler and no password available", message);
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            this.policyNotAsserted(info, e, message);
        }
        return cb[0].getPassword();
    }

    protected void policyNotAsserted(UsernameToken assertion, String reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason);
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new Message(reason, LOG, new Object[0]));
        }
    }

    protected void policyNotAsserted(UsernameToken assertion, Exception reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason.getMessage());
            }
        }
        throw new PolicyException(reason);
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
    }
}

