/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.validate.Validator;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlTokenInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlTokenInterceptor.class);
    private static final Set<QName> HEADERS = new HashSet<QName>();

    public SamlTokenInterceptor() {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JOutInterceptor.class.getName());
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        boolean isOut;
        boolean isReq = MessageUtils.isRequestor(message);
        if (isReq != (isOut = MessageUtils.isOutbound(message))) {
            this.assertSamlTokens(message);
            return;
        }
        if (isReq) {
            if (message.containsKey(PolicyBasedWSS4JOutInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.addSamlToken(message);
        } else {
            if (message.containsKey(WSS4JInInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.processSamlToken(message);
        }
    }

    private void processSamlToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement(el);
        while (child != null) {
            if ("Assertion".equals(child.getLocalName())) {
                try {
                    List<WSSecurityEngineResult> samlResults = this.processToken(child, message);
                    if (samlResults != null) {
                        List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                        if (results == null) {
                            results = new ArrayList();
                            message.put("RECV_RESULTS", (Object)results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, samlResults);
                        results.add(0, rResult);
                        this.assertSamlTokens(message);
                        Principal principal = (Principal)samlResults.get(0).get((Object)"principal");
                        message.put("wss4j.principal.result", (Object)principal);
                        SecurityContext sc = message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        SAMLTokenProcessor p = new SAMLTokenProcessor();
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return SamlTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = null;
                if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                    key = "ws-security.saml1.validator";
                } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                    key = "ws-security.saml2.validator";
                }
                if (key != null) {
                    Object o = message.getContextualProperty(key);
                    try {
                        if (o instanceof Validator) {
                            return (Validator)o;
                        }
                        if (o instanceof Class) {
                            return (Validator)((Class)o).newInstance();
                        }
                        if (o instanceof String) {
                            return (Validator)ClassLoaderUtils.loadClass(o.toString(), SamlTokenInterceptor.class).newInstance();
                        }
                    }
                    catch (RuntimeException t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        throw new WSSecurityException(t.getMessage(), t);
                    }
                }
                return super.getValidator(qName);
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    private SamlToken assertSamlTokens(SoapMessage message) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = aim.getAssertionInfo(SP12Constants.SAML_TOKEN);
        SamlToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (SamlToken)ai.getAssertion();
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        return tok;
    }

    private void addSamlToken(SoapMessage message) {
        SamlToken tok = this.assertSamlTokens(message);
        Header h = this.findSecurityHeader(message, true);
        try {
            AssertionWrapper wrapper = this.addSamlToken(tok, message);
            if (wrapper == null) {
                AssertionInfoMap aim = message.get(AssertionInfoMap.class);
                Collection<AssertionInfo> ais = aim.getAssertionInfo(SP12Constants.SAML_TOKEN);
                for (AssertionInfo ai : ais) {
                    if (!ai.isAsserted()) continue;
                    ai.setAsserted(false);
                }
                return;
            }
            Element el = (Element)h.getObject();
            el.appendChild(wrapper.toDOM(el.getOwnerDocument()));
        }
        catch (WSSecurityException ex) {
            this.policyNotAsserted(tok, ex.getMessage(), message);
        }
    }

    private AssertionWrapper addSamlToken(SamlToken token, SoapMessage message) throws WSSecurityException {
        Object o = message.getContextualProperty("ws-security.saml-callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            return null;
        }
        SAMLParms samlParms = new SAMLParms();
        samlParms.setCallbackHandler(handler);
        if (token.isUseSamlVersion11Profile10() || token.isUseSamlVersion11Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_11);
        } else if (token.isUseSamlVersion20Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_20);
        }
        AssertionWrapper assertion = new AssertionWrapper(samlParms);
        boolean selfSignAssertion = MessageUtils.getContextualBoolean(message, "ws-security.self-sign-saml-assertion", false);
        if (selfSignAssertion) {
            Crypto crypto = this.getCrypto(token, "ws-security.signature.crypto", "ws-security.signature.properties", message);
            String userNameKey = "ws-security.signature.username";
            String user = (String)message.getContextualProperty(userNameKey);
            if (crypto != null && StringUtils.isEmpty(user)) {
                try {
                    user = crypto.getDefaultX509Identifier();
                }
                catch (WSSecurityException e1) {
                    throw new Fault(e1);
                }
            }
            if (StringUtils.isEmpty(user)) {
                return null;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty(password)) {
                password = this.getPassword(user, token, 3, message);
            }
            if (password == null) {
                password = "";
            }
            assertion.signAssertion(user, password, crypto, false);
        }
        return assertion;
    }

    private Crypto getCrypto(SamlToken samlToken, String cryptoKey, String propKey, SoapMessage message) throws WSSecurityException {
        Properties properties;
        Crypto crypto;
        block19: {
            crypto = (Crypto)message.getContextualProperty(cryptoKey);
            if (crypto != null) {
                return crypto;
            }
            Object o = message.getContextualProperty(propKey);
            if (o == null) {
                return null;
            }
            properties = null;
            if (o instanceof Properties) {
                properties = (Properties)o;
            } else {
                if (o instanceof String) {
                    ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
                    URL url = rm.resolveResource((String)o, URL.class);
                    try {
                        if (url == null) {
                            url = ClassLoaderUtils.getResource((String)o, this.getClass());
                        }
                        if (url == null) {
                            try {
                                url = new URL((String)o);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (url != null) {
                            InputStream ins = url.openStream();
                            properties = new Properties();
                            properties.load(ins);
                            ins.close();
                        } else if (samlToken != null) {
                            this.policyNotAsserted(samlToken, "Could not find properties file " + o, message);
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        if (samlToken != null) {
                            this.policyNotAsserted(samlToken, e.getMessage(), message);
                        }
                        break block19;
                    }
                }
                if (o instanceof URL) {
                    properties = new Properties();
                    try {
                        InputStream ins = ((URL)o).openStream();
                        properties.load(ins);
                        ins.close();
                    }
                    catch (IOException e) {
                        if (samlToken == null) break block19;
                        this.policyNotAsserted(samlToken, e.getMessage(), message);
                    }
                }
            }
        }
        if (properties != null) {
            crypto = CryptoFactory.getInstance((Properties)properties);
        }
        return crypto;
    }

    private Header findSecurityHeader(SoapMessage message, boolean create) {
        for (Header h : message.getHeaders()) {
            QName n = h.getName();
            if (!n.getLocalPart().equals("Security") || !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
            return h;
        }
        if (!create) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SoapHeader sh = new SoapHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), el);
        sh.setMustUnderstand(true);
        message.getHeaders().add(sh);
        return sh;
    }

    private CallbackHandler getCallback(SoapMessage message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    public String getPassword(String userName, SamlToken info, int type, SoapMessage message) {
        CallbackHandler handler = this.getCallback(message);
        if (handler == null) {
            this.policyNotAsserted(info, "No callback handler and no password available", message);
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            this.policyNotAsserted(info, e, message);
        }
        return cb[0].getPassword();
    }

    protected void policyNotAsserted(SamlToken assertion, String reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason);
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new Message(reason, LOG, new Object[0]));
        }
    }

    protected void policyNotAsserted(SamlToken assertion, Exception reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason.getMessage());
            }
        }
        throw new PolicyException(reason);
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
    }
}

