/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Element;

final class SAMLUtils {
    private SAMLUtils() {
    }

    public static List<String> parseRolesInAssertion(Object assertion, String roleAttributeName) {
        if (((AssertionWrapper)assertion).getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            return SAMLUtils.parseRolesInAssertion(((AssertionWrapper)assertion).getSaml2(), roleAttributeName);
        }
        return SAMLUtils.parseRolesInAssertion(((AssertionWrapper)assertion).getSaml1(), roleAttributeName);
    }

    public static String getIssuer(Object assertion) {
        return ((AssertionWrapper)assertion).getIssuerString();
    }

    public static Element getAssertionElement(Object assertion) {
        return ((AssertionWrapper)assertion).getElement();
    }

    private static List<String> parseRolesInAssertion(Assertion assertion, String roleAttributeName) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        block0: for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (org.opensaml.saml1.core.Attribute attribute : attributes) {
                if (!attribute.getAttributeName().equals(roleAttributeName)) continue;
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    roles.add(value);
                }
                if (attribute.getAttributeValues().size() <= 1) continue;
                continue block0;
            }
        }
        return Collections.unmodifiableList(roles);
    }

    private static List<String> parseRolesInAssertion(org.opensaml.saml2.core.Assertion assertion, String roleAttributeName) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        block0: for (AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals(roleAttributeName)) continue;
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    roles.add(value);
                }
                if (attribute.getAttributeValues().size() <= 1) continue;
                continue block0;
            }
        }
        return Collections.unmodifiableList(roles);
    }
}

