/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class CryptoCoverageChecker
extends AbstractSoapInterceptor {
    protected List<XPathExpression> xPaths = new ArrayList<XPathExpression>();
    protected Map<String, String> prefixMap = new HashMap<String, String>();

    public CryptoCoverageChecker() {
        this((Map<String, String>)null, (List<XPathExpression>)null);
    }

    public CryptoCoverageChecker(Map<String, String> prefixes, List<XPathExpression> xPaths) {
        super("pre-protocol");
        this.addAfter(WSS4JInInterceptor.class.getName());
        this.setPrefixes(prefixes);
        this.setXPaths(xPaths);
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        List<WSHandlerResult> results = CastUtils.cast((List)message.get("RECV_RESULTS"));
        for (WSHandlerResult wshr : results) {
            Vector wsSecurityEngineSignResults = new Vector();
            Vector wsSecurityEngineEncResults = new Vector();
            WSSecurityUtil.fetchAllActionResults((List)wshr.getResults(), (int)2, wsSecurityEngineSignResults);
            WSSecurityUtil.fetchAllActionResults((List)wshr.getResults(), (int)4, wsSecurityEngineEncResults);
            for (WSSecurityEngineResult wser : wsSecurityEngineSignResults) {
                List<WSDataRef> sl = CastUtils.cast((List)wser.get((Object)"data-ref-uris"));
                if (sl == null) continue;
                if (sl.size() == 1 && sl.get(0).getName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"))) break;
                for (WSDataRef r : sl) {
                    signed.add(r);
                }
            }
            for (WSSecurityEngineResult wser : wsSecurityEngineEncResults) {
                List<WSDataRef> el = CastUtils.cast((List)wser.get((Object)"data-ref-uris"));
                if (el == null) continue;
                for (WSDataRef r : el) {
                    encrypted.add(r);
                }
            }
        }
        CryptoCoverageUtil.reconcileEncryptedSignedRefs(signed, encrypted);
        for (XPathExpression xPathExpression : this.xPaths) {
            HashSet<WSDataRef> refsToCheck = null;
            switch (xPathExpression.getType()) {
                case SIGNED: {
                    refsToCheck = signed;
                    break;
                }
                case ENCRYPTED: {
                    refsToCheck = encrypted;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected crypto type: " + (Object)((Object)xPathExpression.getType()));
                }
            }
            try {
                SOAPMessage saajDoc = message.getContent(SOAPMessage.class);
                SOAPEnvelope documentElement = null;
                if (saajDoc != null && saajDoc.getSOAPPart() != null) {
                    documentElement = saajDoc.getSOAPPart().getEnvelope();
                }
                CryptoCoverageUtil.checkCoverage((Element)documentElement, refsToCheck, this.prefixMap, xPathExpression.getXPath(), xPathExpression.getType(), xPathExpression.getScope());
            }
            catch (WSSecurityException e) {
                throw new SoapFault("No " + (Object)((Object)xPathExpression.getType()) + " element found matching XPath " + xPathExpression.getXPath(), Fault.FAULT_CODE_CLIENT);
            }
            catch (SOAPException e) {
                throw new SoapFault("No " + (Object)((Object)xPathExpression.getType()) + " element found matching XPath " + xPathExpression.getXPath(), Fault.FAULT_CODE_CLIENT);
            }
        }
    }

    public final void setXPaths(List<XPathExpression> xpaths) {
        this.xPaths.clear();
        if (xpaths != null) {
            this.xPaths.addAll(xpaths);
        }
    }

    public final void addXPaths(List<XPathExpression> xpaths) {
        if (xpaths != null) {
            this.xPaths.addAll(xpaths);
        }
    }

    public final void setPrefixes(Map<String, String> prefixes) {
        this.prefixMap.clear();
        if (prefixes != null) {
            this.prefixMap.putAll(prefixes);
        }
    }

    public final void addPrefixes(Map<String, String> prefixes) {
        if (prefixes != null) {
            this.prefixMap.putAll(prefixes);
        }
    }

    public static class XPathExpression {
        private final String xPath;
        private final CryptoCoverageUtil.CoverageType type;
        private final CryptoCoverageUtil.CoverageScope scope;

        public XPathExpression(String xPath, CryptoCoverageUtil.CoverageType type) {
            this(xPath, type, CryptoCoverageUtil.CoverageScope.ELEMENT);
        }

        public XPathExpression(String xPath, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope) {
            if (xPath == null) {
                throw new NullPointerException("xPath cannot be null.");
            }
            if (type == null) {
                throw new NullPointerException("type cannot be null.");
            }
            this.xPath = xPath;
            this.type = type;
            this.scope = scope;
        }

        public String getXPath() {
            return this.xPath;
        }

        public CryptoCoverageUtil.CoverageType getType() {
            return this.type;
        }

        public CryptoCoverageUtil.CoverageScope getScope() {
            return this.scope;
        }

        public boolean equals(Object xpathObject) {
            if (!(xpathObject instanceof XPathExpression)) {
                return false;
            }
            if (xpathObject == this) {
                return true;
            }
            XPathExpression xpath = (XPathExpression)xpathObject;
            if (xpath.getScope() != this.getScope()) {
                return false;
            }
            if (xpath.getType() != this.getType()) {
                return false;
            }
            if (this.getXPath() == null && xpath.getXPath() != null) {
                return false;
            }
            return this.getXPath() == null || this.getXPath().equals(xpath.getXPath());
        }

        public int hashCode() {
            int result = 17;
            if (this.getXPath() != null) {
                result = 31 * result + this.getXPath().hashCode();
            }
            if (this.getType() != null) {
                result = 31 * result + this.getType().hashCode();
            }
            if (this.getScope() != null) {
                result = 31 * result + this.getScope().hashCode();
            }
            return result;
        }
    }
}

