/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.reader.internalizer.AbstractReferenceFinderImpl;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.internalizer.InternalizationLogic;
import com.sun.tools.xjc.reader.xmlschema.parser.LSInputSAXWrapper;
import com.sun.tools.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.JAXBUtils;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.DefaultValueProvider;
import org.apache.cxf.tools.wsdlto.core.RandomValueProvider;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.ClassNameAllocatorImpl;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.JAXBBindErrorListener;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.TypesCodeWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXBDataBinding
implements DataBindingProfile {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBDataBinding.class);
    private static final Set<String> DEFAULT_TYPE_MAP = new HashSet<String>();
    private static final Map<String, String> JLDEFAULT_TYPE_MAP = new HashMap<String, String>();
    private S2JJAXBModel rawJaxbModelGenCode;
    private ToolContext context;
    private DefaultValueProvider defaultValues;
    private boolean initialized;
    private JAXBBindErrorListener listener;

    private void checkEncoding(ToolContext c) {
        block3: {
            String encoding = (String)c.get("encoding");
            if (encoding != null) {
                try {
                    CodeWriter.class.getDeclaredField("encoding");
                }
                catch (Throwable t) {
                    c.remove("encoding");
                    String fenc = System.getProperty("file.encoding");
                    if (encoding.equals(fenc)) break block3;
                    LOG.log(Level.WARNING, "JAXB_NO_ENCODING_SUPPORT", new String[]{Driver.getBuildID(), fenc});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ToolContext c) throws ToolException {
        this.context = c;
        this.checkEncoding(c);
        SchemaCompiler schemaCompiler = XJC.createSchemaCompiler();
        Bus bus = this.context.get(Bus.class);
        OASISCatalogManager catalog = bus.getExtension(OASISCatalogManager.class);
        this.hackInNewInternalizationLogic(schemaCompiler, catalog);
        ClassCollector classCollector = this.context.get(ClassCollector.class);
        ClassNameAllocatorImpl allocator = new ClassNameAllocatorImpl(classCollector, c.optionSet("autoNameResolution"));
        schemaCompiler.setClassNameAllocator((ClassNameAllocator)allocator);
        this.listener = new JAXBBindErrorListener(this.context.isVerbose(), this.context.getErrorListener());
        schemaCompiler.setErrorListener((ErrorListener)this.listener);
        List<InputSource> jaxbBindings = this.context.getJaxbBindingFile();
        SchemaCollection schemas = (SchemaCollection)this.context.get("xmlSchemaCollection");
        Options opts = null;
        opts = this.getOptions(schemaCompiler);
        ArrayList<String> args = new ArrayList<String>();
        if (this.context.get("noAddressBinding") == null) {
            args.add("-extension");
            String name = "/org/apache/cxf/tools/common/jaxb/W3CEPRJaxbBinding.xml";
            if (this.isJAXB22()) {
                name = "/org/apache/cxf/tools/common/jaxb/W3CEPRJaxbBinding_jaxb22.xml";
            }
            URL bindingFileUrl = this.getClass().getResource(name);
            InputSource ins = new InputSource(bindingFileUrl.toString());
            opts.addBindFile(ins);
        }
        if (this.context.get("xjc") != null) {
            String[] xjcArgss;
            String[] o = this.context.get("xjc");
            if (o instanceof String) {
                o = new String[]{(String)o};
            }
            for (String xjcArgs : xjcArgss = (String[])o) {
                StringTokenizer tokenizer = new StringTokenizer(xjcArgs, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    String arg = tokenizer.nextToken();
                    args.add(arg);
                    LOG.log(Level.FINE, "xjc arg:" + arg);
                }
            }
        }
        if (this.context.get("noAddressBinding") == null || this.context.get("xjc") != null) {
            try {
                opts.addGrammar(new InputSource("null"));
                opts.parseArguments(args.toArray(new String[args.size()]));
            }
            catch (BadCommandLineException e) {
                String msg = "XJC reported 'BadCommandLineException' for -xjc argument:";
                for (String arg : args) {
                    msg = msg + arg + " ";
                }
                LOG.log(Level.FINE, msg, e);
                if (opts != null) {
                    String pluginUsage = this.getPluginUsageString(opts);
                    msg = msg + System.getProperty("line.separator");
                    msg = args.contains("-X") ? pluginUsage : msg + pluginUsage;
                }
                throw new ToolException(msg, (Throwable)e);
            }
        }
        if (this.context.optionSet("mark-generated")) {
            try {
                opts.parseArgument(new String[]{"-mark-generated"}, 0);
            }
            catch (BadCommandLineException e) {
                LOG.log(Level.SEVERE, e.getMessage());
                throw new ToolException(e);
            }
        }
        this.addSchemas(opts, schemaCompiler, schemas);
        this.addBindingFiles(opts, jaxbBindings, schemas);
        for (String ns : this.context.getNamespacePackageMap().keySet()) {
            File file = JAXBUtils.getPackageMappingSchemaBindingFile(ns, this.context.mapPackageName(ns));
            try {
                InputSource ins = new InputSource(file.toURI().toString());
                schemaCompiler.parseSchema(ins);
            }
            finally {
                FileUtils.delete(file);
            }
        }
        if (this.context.getPackageName() != null) {
            schemaCompiler.setDefaultPackageName(this.context.getPackageName());
        }
        this.rawJaxbModelGenCode = schemaCompiler.bind();
        this.addedEnumClassToCollector(schemas, allocator);
        if (this.context.get("defaultValues") != null) {
            String cname = (String)this.context.get("defaultValues");
            if (StringUtils.isEmpty(cname)) {
                this.defaultValues = new RandomValueProvider();
            } else {
                if (cname.charAt(0) == '=') {
                    cname = cname.substring(1);
                }
                try {
                    this.defaultValues = (DefaultValueProvider)Class.forName(cname).newInstance();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage());
                    throw new ToolException(e);
                }
            }
        }
        this.initialized = true;
    }

    private boolean isJAXB22() {
        return org.apache.cxf.common.jaxb.JAXBUtils.isJAXB22();
    }

    private void hackInNewInternalizationLogic(SchemaCompiler schemaCompiler, final OASISCatalogManager catalog) {
        try {
            Field f = schemaCompiler.getClass().getDeclaredField("forest");
            f.setAccessible(true);
            DOMForest forest = new DOMForest((InternalizationLogic)new XMLSchemaInternalizationLogic(){

                public XMLFilterImpl createExternalReferenceFinder(DOMForest parent) {
                    return new ReferenceFinder(parent, catalog);
                }
            });
            forest.setErrorHandler((ErrorReceiver)schemaCompiler);
            f.set(schemaCompiler, forest);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBindingFiles(Options opts, List<InputSource> jaxbBindings, SchemaCollection schemas) {
        for (InputSource binding : jaxbBindings) {
            XMLStreamReader r = StaxUtils.createXMLStreamReader(binding);
            try {
                StaxUtils.toNextTag(r);
                String s = r.getAttributeValue(null, "schemaLocation");
                if (StringUtils.isEmpty(s)) {
                    Document d = StaxUtils.read(r);
                    XPath p = XPathFactory.newInstance().newXPath();
                    p.setNamespaceContext(new W3CNamespaceContext(d.getDocumentElement()));
                    XPathExpression xpe = p.compile(d.getDocumentElement().getAttribute("node"));
                    for (XmlSchema schema : schemas.getXmlSchemas()) {
                        Object src;
                        NodeList nodes;
                        if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace()) || (nodes = (NodeList)xpe.evaluate(src = this.getSchemaNode(schema, schemas), XPathConstants.NODESET)).getLength() <= 0) continue;
                        String key = schema.getSourceURI();
                        binding = this.convertToTmpInputSource(d.getDocumentElement(), key);
                        opts.addBindFile(binding);
                        binding = null;
                    }
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception ex) {}
            }
            if (binding == null) continue;
            opts.addBindFile(binding);
        }
    }

    private Object getSchemaNode(XmlSchema schema, SchemaCollection schemaCollection) {
        Document[] docs;
        XmlSchemaSerializer xser = new XmlSchemaSerializer();
        xser.setExtReg(schemaCollection.getExtReg());
        try {
            docs = xser.serializeSchema(schema, false);
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            throw new RuntimeException(e);
        }
        return docs[0].getDocumentElement();
    }

    private InputSource convertToTmpInputSource(Element ele, String schemaLoc) throws Exception {
        InputSource result = null;
        ele.setAttributeNS(null, "schemaLocation", schemaLoc);
        File tmpFile = FileUtils.createTempFile("jaxbbinding", ".xml");
        XMLUtils.writeTo((Node)ele, (OutputStream)new FileOutputStream(tmpFile));
        result = new InputSource(URIParserUtil.getAbsoluteURI(tmpFile.getAbsolutePath()));
        tmpFile.deleteOnExit();
        return result;
    }

    private void addSchemas(Options opts, SchemaCompiler schemaCompiler, SchemaCollection schemaCollection) {
        InputSource is;
        String key;
        HashSet<String> ids = new HashSet<String>();
        List serviceList = (List)this.context.get("serviceList");
        for (ServiceInfo si : serviceList) {
            for (SchemaInfo sci : si.getSchemas()) {
                String key2 = sci.getSystemId();
                if (ids.contains(key2)) continue;
                ids.add(key2);
            }
        }
        Bus bus = this.context.get(Bus.class);
        OASISCatalogManager catalog = bus.getExtension(OASISCatalogManager.class);
        for (XmlSchema schema : schemaCollection.getXmlSchemas()) {
            Document[] docs;
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace()) || ids.contains(key = schema.getSourceURI()) || key.startsWith("file:") || key.startsWith("jar:")) continue;
            XmlSchemaSerializer xser = new XmlSchemaSerializer();
            xser.setExtReg(schemaCollection.getExtReg());
            try {
                docs = xser.serializeSchema(schema, false);
            }
            catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
                throw new RuntimeException(e);
            }
            Element ele = docs[0].getDocumentElement();
            ele = this.removeImportElement(ele, key, catalog);
            if (this.context.fullValidateWSDL()) {
                String uri = null;
                try {
                    uri = docs[0].getDocumentURI();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                this.validateSchema(ele, uri, catalog);
            }
            try {
                docs[0].setDocumentURI(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
            is = new InputSource((InputStream)null);
            is.setSystemId(key);
            is.setPublicId(key);
            opts.addGrammar(is);
            try {
                schemaCompiler.parseSchema(key, StaxUtils.createXMLStreamReader(ele, key));
            }
            catch (XMLStreamException e) {
                throw new ToolException(e);
            }
        }
        for (XmlSchema schema : schemaCollection.getXmlSchemas()) {
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            key = schema.getSourceURI();
            String tns = schema.getTargetNamespace();
            if (ids.contains(key) || tns == null || !key.startsWith("file:") && !key.startsWith("jar:")) continue;
            InputStream in = null;
            try {
                in = key.startsWith("file:") ? new FileInputStream(new File(new URI(key))) : new URL(key).openStream();
                XMLStreamReader reader = StaxUtils.createXMLStreamReader(key, in);
                reader = new LocationFilterReader(reader, catalog);
                is = new InputSource(key);
                opts.addGrammar(is);
                schemaCompiler.parseSchema(key, reader);
                reader.close();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        ids.clear();
        for (ServiceInfo si : serviceList) {
            for (SchemaInfo sci : si.getSchemas()) {
                key = sci.getSystemId();
                if (ids.contains(key)) continue;
                ids.add(key);
                Element ele = sci.getElement();
                ele = this.removeImportElement(ele, key, catalog);
                if (this.context.fullValidateWSDL()) {
                    this.validateSchema(ele, sci.getSystemId(), catalog);
                }
                InputSource is2 = new InputSource((InputStream)null);
                is2.setSystemId(key);
                is2.setPublicId(key);
                opts.addGrammar(is2);
                try {
                    schemaCompiler.parseSchema(key, StaxUtils.createXMLStreamReader(ele, key));
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String getPluginUsageString(Options opts) {
        StringBuilder buf = new StringBuilder();
        buf.append("\nAvailable plugin options:\n");
        for (Plugin pl : opts.getAllPlugins()) {
            buf.append(pl.getUsage());
            buf.append('\n');
        }
        return buf.toString();
    }

    private Options getOptions(SchemaCompiler schemaCompiler) throws ToolException {
        return schemaCompiler.getOptions();
    }

    private void addedEnumClassToCollector(SchemaCollection schemaCollection, ClassNameAllocatorImpl allocator) {
        for (XmlSchema schema : schemaCollection.getXmlSchemas()) {
            String packageName;
            String targetNamespace = schema.getTargetNamespace();
            if (StringUtils.isEmpty(targetNamespace) || this.addedToClassCollector(packageName = this.context.mapPackageName(targetNamespace))) continue;
            allocator.assignClassName(packageName, "*");
        }
    }

    private boolean addedToClassCollector(String packageName) {
        ClassCollector classCollector = this.context.get(ClassCollector.class);
        Collection<String> files = classCollector.getGeneratedFileInfo();
        for (String file : files) {
            int dotIndex = file.lastIndexOf(".");
            String sub = dotIndex <= 0 ? "" : file.substring(0, dotIndex - 1);
            if (!sub.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuppressCodeGen() {
        return this.context.optionSet("suppress");
    }

    @Override
    public void generate(ToolContext c) throws ToolException {
        if (!this.initialized) {
            this.initialize(c);
        }
        if (this.rawJaxbModelGenCode == null) {
            return;
        }
        if (c.getErrorListener().getErrorCount() > 0) {
            return;
        }
        try {
            String dir = (String)this.context.get("outputdir");
            TypesCodeWriter fileCodeWriter = new TypesCodeWriter(new File(dir), this.context.getExcludePkgList(), (String)this.context.get("encoding"), this.context.get(OutputStreamCreator.class));
            if (this.rawJaxbModelGenCode instanceof S2JJAXBModel) {
                S2JJAXBModel schem2JavaJaxbModel = this.rawJaxbModelGenCode;
                ClassCollector classCollector = this.context.get(ClassCollector.class);
                for (JClass cls : schem2JavaJaxbModel.getAllObjectFactories()) {
                    classCollector.getTypesPackages().add(cls._package().name());
                }
                JCodeModel jcodeModel = schem2JavaJaxbModel.generateCode(null, null);
                if (!this.isSuppressCodeGen()) {
                    jcodeModel.build((CodeWriter)fileCodeWriter);
                }
                this.context.put(JCodeModel.class, jcodeModel);
                for (String str : fileCodeWriter.getExcludeFileList()) {
                    this.context.getExcludeFileList().add(str);
                }
            }
            return;
        }
        catch (IOException e) {
            Message msg = new Message("FAIL_TO_GENERATE_TYPES", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    @Override
    public String getType(QName qname, boolean element) {
        Mapping mapping;
        TypeAndAnnotation typeAnno = this.rawJaxbModelGenCode.getJavaType(qname);
        if (element && (mapping = this.rawJaxbModelGenCode.get(qname)) != null) {
            typeAnno = mapping.getType();
        }
        if (typeAnno != null && typeAnno.getTypeClass() != null) {
            return typeAnno.getTypeClass().fullName();
        }
        return null;
    }

    @Override
    public String getWrappedElementType(QName wrapperElement, QName item) {
        List propList;
        Mapping mapping = this.rawJaxbModelGenCode.get(wrapperElement);
        if (mapping != null && (propList = mapping.getWrapperStyleDrilldown()) != null) {
            for (Property pro : propList) {
                if (!pro.elementName().getNamespaceURI().equals(item.getNamespaceURI()) || !pro.elementName().getLocalPart().equals(item.getLocalPart())) continue;
                return pro.type().fullName();
            }
        }
        return null;
    }

    private Element removeImportElement(Element element, String sysId, OASISCatalogManager catalog) {
        List<Element> impElemList = DOMUtils.findAllElementsByTagNameNS(element, "http://www.w3.org/2001/XMLSchema", "import");
        List<Element> incElemList = DOMUtils.findAllElementsByTagNameNS(element, "http://www.w3.org/2001/XMLSchema", "include");
        boolean hasJAXB = DOMUtils.hasElementInNS(element, "http://java.sun.com/xml/ns/jaxb");
        if (impElemList.size() == 0 && incElemList.size() == 0 && !hasJAXB) {
            return element;
        }
        element = (Element)this.cloneNode(element.getOwnerDocument(), element, true);
        impElemList = DOMUtils.findAllElementsByTagNameNS(element, "http://www.w3.org/2001/XMLSchema", "import");
        for (Element item : impElemList) {
            item.removeAttribute("schemaLocation");
        }
        incElemList = DOMUtils.findAllElementsByTagNameNS(element, "http://www.w3.org/2001/XMLSchema", "include");
        for (Element elem : incElemList) {
            Attr val = elem.getAttributeNode("schemaLocation");
            val.setNodeValue(JAXBDataBinding.mapSchemaLocation(val.getNodeValue(), sysId, catalog));
        }
        if (hasJAXB) {
            String pfx = DOMUtils.getPrefix(element, "http://java.sun.com/xml/ns/jaxb");
            if (StringUtils.isEmpty(pfx)) {
                pfx = DOMUtils.createNamespace(element, "http://java.sun.com/xml/ns/jaxb");
            }
            element.setAttributeNS("http://java.sun.com/xml/ns/jaxb", pfx + ":version", "2.0");
        }
        return element;
    }

    public Node cloneNode(Document document, Node node, boolean deep) throws DOMException {
        Node clone;
        if (document == null || node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(deep);
        }
        switch (type) {
            case 4: {
                clone = document.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                clone = document.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                clone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 1: {
                clone = document.createElement(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    ((Element)clone).setAttributeNS(attributes.item(i).getNamespaceURI(), attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
                }
                try {
                    clone.setUserData("location", node.getUserData("location"), null);
                }
                catch (Throwable t) {}
                break;
            }
            case 3: {
                clone = document.createTextNode(node.getNodeValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (deep && type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                clone.appendChild(this.cloneNode(document, child, true));
            }
        }
        return clone;
    }

    public void validateSchema(Element ele, String uri, final OASISCatalogManager catalog) throws ToolException {
        block2: {
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFact.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    String s = JAXBDataBinding.mapSchemaLocation(systemId, baseURI, catalog);
                    return new LSInputSAXWrapper(new InputSource(s));
                }
            });
            DOMSource domSrc = new DOMSource(ele, uri);
            try {
                schemaFact.newSchema(domSrc);
            }
            catch (SAXException e) {
                if (e.getLocalizedMessage().indexOf("src-resolve.4.2") > -1) break block2;
                throw new ToolException("Schema Error : " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public DefaultValueWriter createDefaultValueWriter(QName qname, boolean element) {
        JDefinedClass dc;
        Mapping mapping;
        if (this.defaultValues == null) {
            return null;
        }
        TypeAndAnnotation typeAnno = this.rawJaxbModelGenCode.getJavaType(qname);
        if (element && (mapping = this.rawJaxbModelGenCode.get(qname)) != null) {
            typeAnno = mapping.getType();
        }
        if (typeAnno != null && typeAnno.getTypeClass() instanceof JDefinedClass && (dc = (JDefinedClass)typeAnno.getTypeClass()).isAbstract()) {
            typeAnno = null;
        }
        if (typeAnno != null) {
            JType type = typeAnno.getTypeClass();
            return new JAXBDefaultValueWriter(type);
        }
        return null;
    }

    @Override
    public DefaultValueWriter createDefaultValueWriterForWrappedElement(QName wrapperElement, QName item) {
        Mapping mapping;
        if (this.defaultValues != null && (mapping = this.rawJaxbModelGenCode.get(wrapperElement)) != null) {
            List propList = mapping.getWrapperStyleDrilldown();
            for (Property pro : propList) {
                if (!pro.elementName().getNamespaceURI().equals(item.getNamespaceURI()) || !pro.elementName().getLocalPart().equals(item.getLocalPart())) continue;
                JType type = pro.type();
                if (type instanceof JDefinedClass && ((JDefinedClass)type).isAbstract()) {
                    return null;
                }
                return new JAXBDefaultValueWriter(pro.type());
            }
        }
        return null;
    }

    private static String mapSchemaLocation(String target, String base, OASISCatalogManager catalog) {
        try {
            String resolvedLocation = new OASISCatalogManagerHelper().resolve(catalog, target, base);
            if (resolvedLocation != null) {
                return resolvedLocation;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            URIResolver resolver = new URIResolver(base, target);
            if (resolver.isResolved()) {
                target = resolver.getURI().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target;
    }

    static {
        DEFAULT_TYPE_MAP.add("boolean");
        DEFAULT_TYPE_MAP.add("int");
        DEFAULT_TYPE_MAP.add("long");
        DEFAULT_TYPE_MAP.add("short");
        DEFAULT_TYPE_MAP.add("byte");
        DEFAULT_TYPE_MAP.add("float");
        DEFAULT_TYPE_MAP.add("double");
        DEFAULT_TYPE_MAP.add("char");
        DEFAULT_TYPE_MAP.add("java.lang.String");
        DEFAULT_TYPE_MAP.add("javax.xml.namespace.QName");
        DEFAULT_TYPE_MAP.add("java.net.URI");
        DEFAULT_TYPE_MAP.add("java.math.BigInteger");
        DEFAULT_TYPE_MAP.add("java.math.BigDecimal");
        DEFAULT_TYPE_MAP.add("javax.xml.datatype.XMLGregorianCalendar");
        DEFAULT_TYPE_MAP.add("javax.xml.datatype.Duration");
        JLDEFAULT_TYPE_MAP.put("java.lang.Character", "char");
        JLDEFAULT_TYPE_MAP.put("java.lang.Boolean", "boolean");
        JLDEFAULT_TYPE_MAP.put("java.lang.Integer", "int");
        JLDEFAULT_TYPE_MAP.put("java.lang.Long", "long");
        JLDEFAULT_TYPE_MAP.put("java.lang.Short", "short");
        JLDEFAULT_TYPE_MAP.put("java.lang.Byte", "byte");
        JLDEFAULT_TYPE_MAP.put("java.lang.Float", "float");
        JLDEFAULT_TYPE_MAP.put("java.lang.Double", "double");
        DEFAULT_TYPE_MAP.addAll(JLDEFAULT_TYPE_MAP.keySet());
    }

    private class JAXBDefaultValueWriter
    implements DefaultValueWriter {
        final JType type;

        JAXBDefaultValueWriter(JType tp) {
            this.type = tp;
        }

        @Override
        public void writeDefaultValue(Writer writer, String indent, String path, String varName) throws IOException {
            path = path + "/" + varName;
            this.writeDefaultValue(writer, indent, path, varName, this.type);
        }

        public void writeDefaultValue(Writer writer, String indent, String path, String varName, JType tp) throws IOException {
            writer.write(tp.fullName());
            writer.write(" ");
            writer.write(varName);
            writer.write(" = ");
            if (tp.isArray()) {
                writer.write("new ");
                writer.write(tp.fullName());
                writer.write(" {};");
            } else if (DEFAULT_TYPE_MAP.contains(tp.fullName())) {
                this.writeDefaultType(writer, tp, path);
                writer.write(";");
            } else if (tp instanceof JDefinedClass) {
                JDefinedClass jdc = (JDefinedClass)tp;
                if (jdc.getClassType() == ClassType.ENUM) {
                    try {
                        Field f = jdc.getClass().getDeclaredField("enumConstantsByName");
                        f.setAccessible(true);
                        Map map = (Map)f.get(jdc);
                        Set<String> values = CastUtils.cast(map.keySet());
                        String first = JAXBDataBinding.this.defaultValues.chooseEnumValue(path, values);
                        writer.write(tp.fullName());
                        writer.write(".");
                        writer.write(first);
                        writer.write(";");
                    }
                    catch (Exception e) {
                        IOException ex = new IOException(e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                } else if (jdc.isAbstract()) {
                    writer.write("null;");
                } else {
                    writer.write("new ");
                    writer.write(tp.fullName());
                    writer.write("();");
                    this.fillInFields(writer, indent, path, varName, jdc);
                }
            } else {
                boolean found = false;
                JType tp2 = tp.erasure();
                try {
                    Field f = tp2.getClass().getDeclaredField("_class");
                    f.setAccessible(true);
                    Class cls = (Class)f.get(tp2);
                    if (List.class.isAssignableFrom(cls)) {
                        found = true;
                        writer.write("new ");
                        writer.write(tp.fullName().replace("java.util.List", "java.util.ArrayList"));
                        writer.write("();");
                        f = tp.getClass().getDeclaredField("args");
                        f.setAccessible(true);
                        List lcl = CastUtils.cast((List)f.get(tp));
                        JClass cl = (JClass)lcl.get(0);
                        int cnt = JAXBDataBinding.this.defaultValues.getListLength(path + "/" + varName);
                        for (int x = 0; x < cnt; ++x) {
                            writer.write("\n");
                            writer.write(indent);
                            this.writeDefaultValue(writer, indent, path + "/" + varName + "Val", varName + "Val" + cnt, (JType)cl);
                            writer.write("\n");
                            writer.write(indent);
                            writer.write(varName);
                            writer.write(".add(");
                            writer.write(varName + "Val" + cnt);
                            writer.write(");");
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!found) {
                    writer.write("null;");
                }
            }
        }

        public void fillInFields(Writer writer, String indent, String path, String varName, JDefinedClass tp) throws IOException {
            JClass sp = tp._extends();
            if (sp instanceof JDefinedClass) {
                this.fillInFields(writer, indent, path, varName, (JDefinedClass)sp);
            }
            Collection methods = tp.methods();
            for (JMethod m : methods) {
                if (m.name().startsWith("set")) {
                    boolean hasTwo;
                    writer.write("\n");
                    writer.write(indent);
                    if (DEFAULT_TYPE_MAP.contains(m.listParamTypes()[0].fullName())) {
                        writer.write(varName);
                        writer.write(".");
                        writer.write(m.name());
                        writer.write("(");
                        this.writeDefaultType(writer, m.listParamTypes()[0], path + "/" + m.name().substring(3));
                        writer.write(");");
                        continue;
                    }
                    int idx = path.indexOf("/" + m.name().substring(3) + "/");
                    if (idx > 0) {
                        idx = path.indexOf("/" + m.name().substring(3) + "/", idx + 1);
                    }
                    boolean bl = hasTwo = idx > 0;
                    if (!hasTwo) {
                        this.writeDefaultValue(writer, indent, path + "/" + m.name().substring(3), varName + m.name().substring(3), m.listParamTypes()[0]);
                        writer.write("\n");
                    }
                    writer.write(indent);
                    writer.write(varName);
                    writer.write(".");
                    writer.write(m.name());
                    writer.write("(");
                    if (!hasTwo) {
                        writer.write(varName + m.name().substring(3));
                    } else {
                        writer.write("null");
                    }
                    writer.write(");");
                    continue;
                }
                if (!m.type().fullName().startsWith("java.util.List")) continue;
                writer.write("\n");
                writer.write(indent);
                this.writeDefaultValue(writer, indent, path + "/" + m.name().substring(3), varName + m.name().substring(3), m.type());
                writer.write("\n");
                writer.write(indent);
                writer.write(varName);
                writer.write(".");
                writer.write(m.name());
                writer.write("().addAll(");
                writer.write(varName + m.name().substring(3));
                writer.write(");");
            }
        }

        private void writeDefaultType(Writer writer, JType t, String path) throws IOException {
            String name = t.fullName();
            this.writeDefaultType(writer, name, path);
        }

        private void writeDefaultType(Writer writer, String name, String path) throws IOException {
            if (JLDEFAULT_TYPE_MAP.containsKey(name)) {
                writer.append(name.substring("java.lang.".length())).append(".valueOf(");
                this.writeDefaultType(writer, (String)JLDEFAULT_TYPE_MAP.get(name), path);
                writer.append(")");
            } else if ("boolean".equals(name)) {
                writer.append(JAXBDataBinding.this.defaultValues.getBooleanValue(path) ? "true" : "false");
            } else if ("int".equals(name)) {
                writer.append(Integer.toString(JAXBDataBinding.this.defaultValues.getIntValue(path)));
            } else if ("long".equals(name)) {
                writer.append(Long.toString(JAXBDataBinding.this.defaultValues.getLongValue(path))).append("l");
            } else if ("short".equals(name)) {
                writer.append("(short)").append(Short.toString(JAXBDataBinding.this.defaultValues.getShortValue(path)));
            } else if ("byte".equals(name)) {
                writer.append("(byte)").append(Byte.toString(JAXBDataBinding.this.defaultValues.getByteValue(path)));
            } else if ("float".equals(name)) {
                writer.append(Float.toString(JAXBDataBinding.this.defaultValues.getFloatValue(path))).append("f");
            } else if ("double".equals(name)) {
                writer.append(Double.toString(JAXBDataBinding.this.defaultValues.getDoubleValue(path)));
            } else if ("char".equals(name)) {
                writer.append("(char)").append(Character.toString(JAXBDataBinding.this.defaultValues.getCharValue(path)));
            } else if ("java.lang.String".equals(name)) {
                writer.append("\"").append(JAXBDataBinding.this.defaultValues.getStringValue(path)).append("\"");
            } else if ("javax.xml.namespace.QName".equals(name)) {
                QName qn = JAXBDataBinding.this.defaultValues.getQNameValue(path);
                writer.append("new javax.xml.namespace.QName(\"").append(qn.getNamespaceURI()).append("\", \"").append(qn.getLocalPart()).append("\")");
            } else if ("java.net.URI".equals(name)) {
                writer.append("new java.net.URI(\"").append(JAXBDataBinding.this.defaultValues.getURIValue(path).toASCIIString()).append("\")");
            } else if ("java.math.BigInteger".equals(name)) {
                writer.append("new java.math.BigInteger(\"").append(JAXBDataBinding.this.defaultValues.getBigIntegerValue(path).toString()).append("\")");
            } else if ("java.math.BigDecimal".equals(name)) {
                writer.append("new java.math.BigDecimal(\"").append(JAXBDataBinding.this.defaultValues.getBigDecimalValue(path).toString()).append("\")");
            } else if ("javax.xml.datatype.XMLGregorianCalendar".equals(name)) {
                writer.append("javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendar(\"").append(JAXBDataBinding.this.defaultValues.getXMLGregorianCalendarValueString(path)).append("\")");
            } else if ("javax.xml.datatype.Duration".equals(name)) {
                writer.append("javax.xml.datatype.DatatypeFactory.newInstance().newDuration(\"").append(JAXBDataBinding.this.defaultValues.getDurationValueString(path)).append("\")");
            }
        }
    }

    private static final class ReferenceFinder
    extends AbstractReferenceFinderImpl {
        private Locator locator;
        private OASISCatalogManager catalog;

        ReferenceFinder(DOMForest parent, OASISCatalogManager cat) {
            super(parent);
            this.catalog = cat;
        }

        public void setDocumentLocator(Locator loc) {
            super.setDocumentLocator(loc);
            this.locator = loc;
        }

        protected String findExternalResource(String nsURI, String localName, Attributes atts) {
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI) && ("import".equals(localName) || "include".equals(localName))) {
                String s = atts.getValue("schemaLocation");
                if (!StringUtils.isEmpty(s)) {
                    s = JAXBDataBinding.mapSchemaLocation(s, this.locator.getSystemId(), this.catalog);
                }
                return s;
            }
            return null;
        }
    }

    public class LocationFilterReader
    extends StreamReaderDelegate
    implements XMLStreamReader {
        boolean isImport;
        boolean isInclude;
        int locIdx;
        OASISCatalogManager catalog;

        LocationFilterReader(XMLStreamReader read, OASISCatalogManager catalog) {
            super(read);
            this.locIdx = -1;
            this.catalog = catalog;
        }

        @Override
        public int next() throws XMLStreamException {
            int i = super.next();
            if (i == 1) {
                QName qn = super.getName();
                this.isInclude = qn.equals(WSDLConstants.QNAME_SCHEMA_INCLUDE);
                this.isImport = qn.equals(WSDLConstants.QNAME_SCHEMA_IMPORT);
                if (this.isImport) {
                    this.findLocation();
                } else {
                    this.locIdx = -1;
                }
            } else {
                this.isImport = false;
                this.locIdx = -1;
            }
            return i;
        }

        @Override
        public int nextTag() throws XMLStreamException {
            int i = super.nextTag();
            if (i == 1) {
                QName qn = super.getName();
                this.isInclude = qn.equals(WSDLConstants.QNAME_SCHEMA_INCLUDE);
                this.isImport = qn.equals(WSDLConstants.QNAME_SCHEMA_IMPORT);
                if (this.isImport) {
                    this.findLocation();
                } else {
                    this.locIdx = -1;
                }
            } else {
                this.isImport = false;
                this.locIdx = -1;
            }
            return i;
        }

        private void findLocation() {
            this.locIdx = -1;
            for (int x = super.getAttributeCount(); x > 0; --x) {
                String nm = super.getAttributeLocalName(x - 1);
                if (!"schemaLocation".equals(nm)) continue;
                this.locIdx = x - 1;
            }
        }

        @Override
        public int getAttributeCount() {
            int i = super.getAttributeCount();
            if (this.locIdx != -1) {
                --i;
            }
            return i;
        }

        private int mapIdx(int index) {
            if (this.locIdx != -1 && index >= this.locIdx) {
                ++index;
            }
            return index;
        }

        private String mapSchemaLocation(String target) {
            return JAXBDataBinding.mapSchemaLocation(target, this.getLocation().getSystemId(), this.catalog);
        }

        @Override
        public String getAttributeValue(String namespaceURI, String localName) {
            if (this.isInclude && "schemaLocation".equals(localName)) {
                return this.mapSchemaLocation(super.getAttributeValue(namespaceURI, localName));
            }
            return super.getAttributeValue(namespaceURI, localName);
        }

        @Override
        public String getAttributeValue(int index) {
            String n;
            if (this.isInclude && "schemaLocation".equals(n = this.getAttributeLocalName(index))) {
                return this.mapSchemaLocation(super.getAttributeValue(index));
            }
            return super.getAttributeValue(this.mapIdx(index));
        }

        @Override
        public QName getAttributeName(int index) {
            return super.getAttributeName(this.mapIdx(index));
        }

        @Override
        public String getAttributePrefix(int index) {
            return super.getAttributePrefix(this.mapIdx(index));
        }

        @Override
        public String getAttributeNamespace(int index) {
            return super.getAttributeNamespace(this.mapIdx(index));
        }

        @Override
        public String getAttributeLocalName(int index) {
            return super.getAttributeLocalName(this.mapIdx(index));
        }

        @Override
        public String getAttributeType(int index) {
            return super.getAttributeType(this.mapIdx(index));
        }

        @Override
        public boolean isAttributeSpecified(int index) {
            return super.isAttributeSpecified(this.mapIdx(index));
        }
    }
}

