/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.authorization;

import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.saml.assertion.Claims;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.authorization.JAXRSSAMLSecurityContext;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SubjectPrincipal;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.saml.ext.AssertionWrapper;

public class SecurityContextProviderImpl
implements SecurityContextProvider {
    private static final String ROLE_QUALIFIER_PROPERTY = "org.apache.cxf.saml.claims.role.qualifier";
    private static final String ROLE_NAMEFORMAT_PROPERTY = "org.apache.cxf.saml.claims.role.nameformat";

    @Override
    public SecurityContext getSecurityContext(Message message, AssertionWrapper wrapper) {
        Claims claims = this.getClaims(wrapper);
        Subject subject = this.getSubject(message, wrapper, claims);
        return this.doGetSecurityContext(message, subject, claims);
    }

    protected Claims getClaims(AssertionWrapper wrapper) {
        return SAMLUtils.getClaims(wrapper);
    }

    protected Subject getSubject(Message message, AssertionWrapper wrapper, Claims claims) {
        return SAMLUtils.getSubject(message, wrapper);
    }

    protected SecurityContext doGetSecurityContext(Message message, Subject subject, Claims claims) {
        String defaultRoleName = (String)message.getContextualProperty(ROLE_QUALIFIER_PROPERTY);
        String defaultNameFormat = (String)message.getContextualProperty(ROLE_NAMEFORMAT_PROPERTY);
        String subjectPrincipalName = this.getSubjectPrincipalName(subject, claims);
        SubjectPrincipal subjectPrincipal = new SubjectPrincipal(subjectPrincipalName, subject);
        JAXRSSAMLSecurityContext sc = new JAXRSSAMLSecurityContext(subjectPrincipal, claims, defaultRoleName == null ? "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role" : defaultRoleName, defaultNameFormat == null ? "http://schemas.xmlsoap.org/ws/2005/05/identity/claims" : defaultNameFormat);
        return sc;
    }

    protected String getSubjectPrincipalName(Subject subject, Claims claims) {
        return subject.getName();
    }
}

