/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.authorization;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.rs.security.saml.assertion.Claim;
import org.apache.cxf.rs.security.saml.assertion.Claims;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.authorization.SubjectPrincipal;

public class JAXRSSAMLSecurityContext
extends SAMLSecurityContext {
    private Claims claims;

    public JAXRSSAMLSecurityContext(Subject subject, List<Claim> claims) {
        this(new SubjectPrincipal(subject.getName(), subject), new Claims(claims));
    }

    public JAXRSSAMLSecurityContext(SubjectPrincipal p, Claims claims) {
        this(p, claims, "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims");
    }

    public JAXRSSAMLSecurityContext(SubjectPrincipal p, Claims cs, String roleClaimNameQualifier, String roleClaimNameFormat) {
        super(p);
        HashSet<Principal> userRoles;
        Claim rolesClaim = null;
        for (Claim c : cs.getClaims()) {
            if (!c.getName().equals(roleClaimNameQualifier) || !c.getNameFormat().equals(roleClaimNameFormat)) continue;
            rolesClaim = c;
            break;
        }
        this.claims = cs;
        if (rolesClaim != null) {
            userRoles = new HashSet<Principal>();
            for (String role : rolesClaim.getValues()) {
                userRoles.add(new SimplePrincipal(role));
            }
        } else {
            userRoles = null;
        }
        this.setUserRoles(userRoles);
    }

    public Claims getClaims() {
        return this.claims;
    }
}

