/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.refresh;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class RefreshTokenGrantHandler
implements AccessTokenGrantHandler {
    private OAuthDataProvider dataProvider;

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public List<String> getSupportedGrantTypes() {
        return Collections.singletonList("refresh_token");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        List<String> tokenScopes;
        if (!OAuthUtils.isGrantSupportedForClient(client, true, "refresh_token")) {
            throw new OAuthServiceException("unauthorized_client");
        }
        String refreshToken = (String)params.getFirst((Object)"refresh_token");
        ServerAccessToken token = this.dataProvider.refreshAccessToken(client.getClientId(), refreshToken);
        if (token == null) {
            return null;
        }
        String scope = (String)params.getFirst((Object)"scope");
        if (scope != null && !(tokenScopes = OAuthUtils.convertPermissionsToScopeList(token.getScopes())).containsAll(OAuthUtils.parseScope(scope))) {
            throw new OAuthServiceException("invalid_scope");
        }
        return token;
    }
}

