/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.message.Message;

public abstract class AbstractResponseContextImpl {
    protected Message m;
    protected Response r;

    public AbstractResponseContextImpl(Response r, Message m) {
        this.m = m;
        this.r = r;
    }

    public Set<String> getAllowedMethods() {
        return this.r.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.r.getCookies();
    }

    public Date getDate() {
        return this.r.getDate();
    }

    public Object getEntity() {
        return this.r.getEntity();
    }

    public EntityTag getEntityTag() {
        return this.r.getEntityTag();
    }

    public String getHeaderString(String name) {
        return this.r.getHeaderString(name);
    }

    public Locale getLanguage() {
        return this.r.getLanguage();
    }

    public Date getLastModified() {
        return this.r.getLastModified();
    }

    public int getLength() {
        return this.r.getLength();
    }

    public Link getLink(String rel) {
        return this.r.getLink(rel);
    }

    public Link.Builder getLinkBuilder(String rel) {
        return this.r.getLinkBuilder(rel);
    }

    public Set<Link> getLinks() {
        return this.r.getLinks();
    }

    public URI getLocation() {
        return this.r.getLocation();
    }

    public MediaType getMediaType() {
        return this.r.getMediaType();
    }

    public int getStatus() {
        return this.r.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.r.getStatusInfo();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.r.getStringHeaders();
    }

    public boolean hasEntity() {
        return this.r.hasEntity();
    }

    public boolean hasLink(String rel) {
        return this.r.hasLink(rel);
    }

    public void setEntity(Object entity, Annotation[] anns, MediaType mt) {
        ((ResponseImpl)this.r).setEntity(entity, anns);
        if (mt != null) {
            this.r.getMetadata().putSingle((Object)"Content-Type", (Object)mt);
            this.m.put("Content-Type", mt.toString());
        }
        this.updateMessageResponse();
    }

    protected Annotation[] getResponseEntityAnnotations() {
        return ((ResponseImpl)this.r).getEntityAnnotations();
    }

    protected Class<?> getResponseEntityClass() {
        return this.r.getEntity().getClass();
    }

    public void setStatus(int status) {
        this.m.put(Message.RESPONSE_CODE, status);
        ((ResponseImpl)this.r).setStatus(status);
        this.updateMessageResponse();
    }

    public void setStatusInfo(Response.StatusType status) {
        this.setStatus(status.getStatusCode());
    }

    private void updateMessageResponse() {
        this.m.put(Response.class, this.r);
    }
}

