/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.apache.cxf.common.classloader.JAXBClassLoaderUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;

class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;
    private Collection<Object> typeReferences;
    private Set<Class<?>> globalAdapters = new HashSet();

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes, Collection<Object> typeReferences) {
        super(serviceInfo);
        this.classes = classes;
        this.typeReferences = typeReferences;
    }

    @Override
    public void begin(MessagePartInfo part) {
        boolean isFromWrapper;
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        if (Exception.class.isAssignableFrom(clazz)) {
            part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", Boolean.TRUE);
        }
        if ((isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped()) && !Boolean.TRUE.equals(part.getProperty("messagepart.isheader"))) {
            UnwrappedOperationInfo uop = (UnwrappedOperationInfo)part.getMessageInfo().getOperation();
            OperationInfo op = uop.getWrappedOperation();
            MessageInfo inf = null;
            if (uop.getInput() == part.getMessageInfo()) {
                inf = op.getInput();
            } else if (uop.getOutput() == part.getMessageInfo()) {
                inf = op.getOutput();
            }
            if (inf != null && inf.getMessagePart(0).getTypeClass() != null) {
                return;
            }
        }
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        Annotation[] a = (Annotation[])part.getProperty("parameter.annotations");
        this.checkForAdapter(clazz, a);
        Class<?> genericType = (Class<?>)part.getProperty("generic.type");
        if (genericType != null) {
            boolean isList = Collection.class.isAssignableFrom(clazz);
            if (isFromWrapper) {
                if (genericType instanceof Class && ((Class)genericType).isArray()) {
                    Class cl2 = genericType;
                    if (cl2.isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                        genericType = cl2.getComponentType();
                    }
                    this.addType(genericType);
                } else if (!isList) {
                    this.addType(genericType);
                }
            } else {
                this.addType(genericType, true);
            }
            if (isList && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)((Object)genericType);
                if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                    Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                    clazz = arrayCls;
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType(), true);
                    }
                } else if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)pt.getActualTypeArguments()[0];
                    gat.getGenericComponentType();
                    Class<?> arrayCls = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
                    clazz = Array.newInstance(arrayCls, 0).getClass();
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType(), true);
                    }
                }
            }
            if (isFromWrapper && isList) {
                clazz = null;
            }
        }
        if (clazz != null) {
            Object ref;
            if (!isFromWrapper && clazz.getAnnotation(XmlRootElement.class) == null && clazz.getAnnotation(XmlType.class) != null && StringUtils.isEmpty(clazz.getAnnotation(XmlType.class).name()) && (ref = JAXBClassLoaderUtils.createTypeReference(part.getName(), clazz)) != null) {
                this.typeReferences.add(ref);
            }
            this.addClass(clazz);
        }
    }

    private void checkForAdapter(Class<?> clazz, Annotation[] anns) {
        XmlJavaTypeAdapters adapt;
        Class<?> t;
        XmlJavaTypeAdapter xjta;
        if (anns != null) {
            for (Annotation a : anns) {
                Class<?> t2;
                if (!XmlJavaTypeAdapter.class.isAssignableFrom(a.annotationType()) || (t2 = JAXBContextInitializer.getTypeFromXmlAdapter((XmlJavaTypeAdapter)a)) == null) continue;
                this.addType(t2);
            }
        }
        if ((xjta = clazz.getAnnotation(XmlJavaTypeAdapter.class)) != null && (t = JAXBContextInitializer.getTypeFromXmlAdapter(xjta)) != null) {
            this.addType(t);
        }
        if (clazz.getPackage() != null && (adapt = clazz.getPackage().getAnnotation(XmlJavaTypeAdapters.class)) != null) {
            for (XmlJavaTypeAdapter a : adapt.value()) {
                this.globalAdapters.add(a.type());
            }
            for (XmlJavaTypeAdapter a : adapt.value()) {
                Class<?> t3 = JAXBContextInitializer.getTypeFromXmlAdapter(a);
                if (t3 == null) continue;
                this.addType(t3);
            }
        }
    }

    private void addType(Type cls) {
        this.addType(cls, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addType(Type cls, boolean allowArray) {
        if (cls instanceof Class) {
            if (this.globalAdapters.contains(cls)) {
                return;
            }
            if (((Class)cls).isArray() && !allowArray) {
                this.addClass(((Class)cls).getComponentType());
                return;
            } else {
                this.addClass((Class)cls);
            }
            return;
        } else if (cls instanceof ParameterizedType) {
            this.addType(((ParameterizedType)cls).getRawType());
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
            return;
        } else if (cls instanceof GenericArrayType) {
            Class ct;
            GenericArrayType gt = (GenericArrayType)cls;
            Type componentType = gt.getGenericComponentType();
            if (componentType instanceof Class) {
                ct = (Class)componentType;
            } else {
                TypeVariable tv = (TypeVariable)componentType;
                Type[] bounds = tv.getBounds();
                if (bounds == null || bounds.length != 1) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                if (!(bounds[0] instanceof Class)) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                ct = (Class)bounds[0];
            }
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
            return;
        } else if (cls instanceof WildcardType) {
            for (Type t : ((WildcardType)cls).getUpperBounds()) {
                this.addType(t);
            }
            for (Type t : ((WildcardType)cls).getLowerBounds()) {
                this.addType(t);
            }
            return;
        } else {
            if (!(cls instanceof TypeVariable)) return;
            for (Type t : ((TypeVariable)cls).getBounds()) {
                this.addType(t);
            }
        }
    }

    private void addClass(Class<?> cls) {
        if (Throwable.class.isAssignableFrom(cls)) {
            if (!Throwable.class.equals(cls) && !Exception.class.equals(cls)) {
                this.walkReferences(cls);
            }
            this.addClass(String.class);
        } else if (null != (cls = JAXBUtils.getValidClass(cls))) {
            XmlJavaTypeAdapter xjta;
            XmlSeeAlso xsa;
            if (this.classes.contains(cls)) {
                return;
            }
            if (!cls.isInterface()) {
                this.classes.add(cls);
            }
            if ((xsa = cls.getAnnotation(XmlSeeAlso.class)) != null) {
                for (Class c : xsa.value()) {
                    this.addClass(c);
                }
            }
            if ((xjta = cls.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
                Class<?> t = JAXBContextInitializer.getTypeFromXmlAdapter(xjta);
                if (t != null) {
                    this.addType(t);
                }
                return;
            }
            if (cls.getSuperclass() != null) {
                this.addClass(cls.getSuperclass());
            }
            if (!cls.isInterface()) {
                this.walkReferences(cls);
            }
        }
    }

    static XmlJavaTypeAdapter getFieldXJTA(Field f) {
        XmlJavaTypeAdapters adapters;
        XmlJavaTypeAdapter adapter = f.getAnnotation(XmlJavaTypeAdapter.class);
        if (adapter == null) {
            adapter = f.getType().getAnnotation(XmlJavaTypeAdapter.class);
        }
        if (adapter == null && (adapters = f.getDeclaringClass().getPackage().getAnnotation(XmlJavaTypeAdapters.class)) != null) {
            for (XmlJavaTypeAdapter candidate : adapters.value()) {
                if (candidate == null || !candidate.type().equals(f.getType())) continue;
                adapter = candidate;
                break;
            }
        }
        return adapter;
    }

    static XmlJavaTypeAdapter getMethodXJTA(Method m) {
        XmlJavaTypeAdapters adapters;
        XmlJavaTypeAdapter adapter = m.getAnnotation(XmlJavaTypeAdapter.class);
        if (adapter == null) {
            adapter = m.getReturnType().getAnnotation(XmlJavaTypeAdapter.class);
        }
        if (adapter == null && (adapters = m.getDeclaringClass().getPackage().getAnnotation(XmlJavaTypeAdapters.class)) != null) {
            for (XmlJavaTypeAdapter candidate : adapters.value()) {
                if (candidate == null || !candidate.type().equals(m.getGenericReturnType())) continue;
                adapter = candidate;
                break;
            }
        }
        return adapter;
    }

    static Class<?> getTypeFromXmlAdapter(XmlJavaTypeAdapter xjta) {
        if (xjta != null) {
            Class c2;
            Type sp = c2.getGenericSuperclass();
            for (c2 = xjta.value(); !XmlAdapter.class.equals((Object)c2) && c2 != null; c2 = c2.getSuperclass()) {
                sp = c2.getGenericSuperclass();
            }
            if (sp instanceof ParameterizedType) {
                return (Class)((ParameterizedType)sp).getActualTypeArguments()[0];
            }
        }
        return null;
    }

    static XmlAdapter getXmlAdapter(XmlJavaTypeAdapter adapterAnnotation) throws InstantiationException, IllegalAccessException {
        return adapterAnnotation != null ? (XmlAdapter)adapterAnnotation.value().newInstance() : null;
    }

    private void walkReferences(Class<?> cls) {
        XmlAccessType accessType;
        if (cls == null) {
            return;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.")) {
            return;
        }
        XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
        if (accessorType == null && cls.getPackage() != null) {
            accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
        }
        XmlAccessType xmlAccessType = accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType != XmlAccessType.PROPERTY) {
            Field[] fields = ReflectionUtil.getDeclaredFields(cls);
            for (AccessibleObject accessibleObject : fields) {
                if (!JAXBContextInitializer.isFieldAccepted((Field)accessibleObject, accessType)) continue;
                this.addType(((Field)accessibleObject).getGenericType());
            }
            this.walkReferences(cls.getSuperclass());
        }
        if (accessType != XmlAccessType.FIELD) {
            Method[] methods = ReflectionUtil.getDeclaredMethods(cls);
            for (AccessibleObject accessibleObject : methods) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                this.addType(((Method)accessibleObject).getGenericReturnType());
                for (Type t : ((Method)accessibleObject).getGenericParameterTypes()) {
                    this.addType(t);
                }
            }
        }
    }

    static boolean isFieldAccepted(Field field, XmlAccessType accessType) {
        if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(XmlTransient.class)) {
            return false;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER && !Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.PROPERTY) {
            return JAXBContextInitializer.checkJaxbAnnotation(field.getAnnotations());
        }
        return true;
    }

    static boolean isMethodAccepted(Method method, XmlAccessType accessType) {
        if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || method.getDeclaringClass().equals(Throwable.class)) {
            return false;
        }
        int beginIndex = 3;
        if (method.getName().startsWith("is")) {
            beginIndex = 2;
        }
        AccessibleObject setter = null;
        try {
            setter = method.getDeclaringClass().getMethod("set" + method.getName().substring(beginIndex), method.getReturnType());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (setter == null || setter.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(((Method)setter).getModifiers())) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.FIELD) {
            return JAXBContextInitializer.checkJaxbAnnotation(method.getAnnotations());
        }
        return true;
    }

    private static boolean checkJaxbAnnotation(Annotation[] annotations) {
        Package jaxbAnnotationsPackage = XmlElement.class.getPackage();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getPackage() != jaxbAnnotationsPackage) continue;
            return true;
        }
        return false;
    }
}

