/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SoapHeaderInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapHeaderInterceptor.class);

    public SoapHeaderInterceptor() {
        super("unmarshal");
        this.addAfter(BareInInterceptor.class.getName());
        this.addAfter(RPCInInterceptor.class.getName());
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message m) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        BindingOperationInfo bop;
        SoapMessage message = (SoapMessage)m;
        SoapVersion soapVersion = message.getVersion();
        Exchange exchange = message.getExchange();
        MessageContentsList parameters = MessageContentsList.getContentsList(message);
        if (null == parameters) {
            parameters = new MessageContentsList();
        }
        if (null == (bop = exchange.getBindingOperationInfo())) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor(message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return;
        }
        List<SoapHeaderInfo> headers = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers == null || headers.size() == 0) {
            return;
        }
        boolean supportsNode = this.supportsDataReader(message, Node.class);
        Service service = ServiceModelUtil.getService(message.getExchange());
        Schema schema = EndpointReferenceUtils.getSchema(service.getServiceInfos().get(0), message.getExchange().getBus());
        for (SoapHeaderInfo header : headers) {
            MessagePartInfo mpi = header.getPart();
            try {
                if (MessageUtils.getContextualBoolean(message, "schema-validation-enabled", Boolean.FALSE)) {
                    this.validateHeader(message, mpi, schema);
                }
            }
            catch (Fault f) {
                if (!this.isRequestor(message)) {
                    f.setFaultCode(Fault.FAULT_CODE_CLIENT);
                }
                throw f;
            }
            if (mpi.getTypeClass() == null) continue;
            Header param = this.findHeader(message, mpi);
            Object object = null;
            if (param != null) {
                message.getHeaders().remove(param);
                if (param.getDataBinding() == null) {
                    Node source = (Node)param.getObject();
                    if (source instanceof Element) {
                        Element el = (Element)source;
                        el.removeAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                        el.removeAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                    }
                    if (supportsNode) {
                        object = this.getNodeDataReader(message).read(mpi, source);
                    } else {
                        W3CDOMStreamReader reader = new W3CDOMStreamReader((Element)source);
                        try {
                            reader.nextTag();
                        }
                        catch (XMLStreamException e) {
                            // empty catch block
                        }
                        object = this.getDataReader(message, XMLStreamReader.class).read(mpi, reader);
                    }
                } else {
                    object = param.getObject();
                }
            }
            parameters.put(mpi, object);
        }
        if (parameters.size() > 0) {
            message.setContent(List.class, parameters);
        }
    }

    private void validateHeader(SoapMessage message, MessagePartInfo mpi, Schema schema) {
        Header param = this.findHeader(message, mpi);
        Element el = null;
        if (param != null && param.getDataBinding() == null) {
            Node source = (Node)param.getObject();
            if (!(source instanceof Element)) {
                return;
            }
            el = (Element)source;
            if (schema != null) {
                DOMSource ds = new DOMSource(el);
                try {
                    schema.newValidator().validate(ds);
                }
                catch (SAXException e) {
                    throw new Fault("COULD_NOT_VALIDATE_SOAP_HEADER_CAUSED_BY", LOG, (Throwable)e, e.getClass().getCanonicalName(), e.getMessage());
                }
                catch (IOException e) {
                    throw new Fault("COULD_NOT_VALIDATE_SOAP_HEADER_CAUSED_BY", LOG, (Throwable)e, e.getClass().getCanonicalName(), e.getMessage());
                }
            }
        }
    }

    private Header findHeader(SoapMessage message, MessagePartInfo mpi) {
        return message.getHeader(mpi.getConcreteName());
    }
}

