/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.mac.Nonce;
import org.apache.cxf.rs.security.oauth2.tokens.mac.NonceHistory;
import org.apache.cxf.rs.security.oauth2.tokens.mac.NonceStore;
import org.apache.cxf.rs.security.oauth2.tokens.mac.NonceVerifier;

public class NonceVerifierImpl
implements NonceVerifier {
    private NonceStore nonceStore;
    private long allowedWindow;

    public void verifyNonce(String tokenKey, String clientNonceString, String clientTimestampString) throws OAuthServiceException {
        if (StringUtils.isEmpty(clientNonceString) || StringUtils.isEmpty(clientTimestampString)) {
            throw new OAuthServiceException("Nonce or timestamp is not available");
        }
        long serverClock = System.currentTimeMillis();
        NonceHistory nonceHistory = this.nonceStore.getNonceHistory(tokenKey);
        boolean firstTimeRequest = false;
        if (nonceHistory == null) {
            firstTimeRequest = true;
        }
        long clientTimestamp = Long.valueOf(clientTimestampString);
        if (firstTimeRequest) {
            long requestTimeDelta = serverClock - clientTimestamp;
            Nonce nonce = new Nonce(clientNonceString, clientTimestamp);
            this.nonceStore.storeNonce(tokenKey, nonce, requestTimeDelta);
        } else {
            this.checkAdjustedRequestTime(serverClock, clientTimestamp, nonceHistory);
            NonceVerifierImpl.checkNonceHistory(nonceHistory, clientNonceString, clientTimestamp);
        }
    }

    private static void checkNonceHistory(NonceHistory nonceHistory, String clientNonceString, long ts) throws OAuthServiceException {
        if (!nonceHistory.findMatchingNonces(clientNonceString, ts).isEmpty()) {
            throw new OAuthServiceException("Duplicate nonce");
        }
    }

    private void checkAdjustedRequestTime(long serverClock, long clientTimestamp, NonceHistory nonceHistory) {
        long adjustedRequestTime = clientTimestamp + nonceHistory.getRequestTimeDelta();
        long requestDelta = Math.abs(serverClock - adjustedRequestTime);
        if (requestDelta > this.allowedWindow) {
            throw new OAuthServiceException("Timestamp is invalid");
        }
    }

    public void setAllowedWindow(long allowedWindow) {
        this.allowedWindow = allowedWindow;
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.nonceStore = nonceStore;
    }
}

