/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptoLoader {
    private static final String CRYPTO_CACHE = "rs-security-xml-crypto.cache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Crypto getCrypto(Message message, String cryptoKey, String propKey) throws IOException, WSSecurityException {
        Crypto crypto = (Crypto)message.getContextualProperty(cryptoKey);
        if (crypto != null) {
            return crypto;
        }
        Object o = message.getContextualProperty(propKey);
        if (o == null) {
            return null;
        }
        crypto = this.getCryptoCache(message).get(o);
        if (crypto != null) {
            return crypto;
        }
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource((String)o, this.getClass());
            if (url == null) {
                ResourceManager manager = message.getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader(loader);
                }
                url = manager.resolveResource((String)o, URL.class);
            }
            if (url != null) {
                Properties props = new Properties();
                InputStream in = url.openStream();
                props.load(in);
                in.close();
                crypto = CryptoFactory.getInstance((Properties)props);
            } else {
                crypto = CryptoFactory.getInstance((String)((String)o));
            }
            this.getCryptoCache(message).put(o, crypto);
            Crypto crypto2 = crypto;
            return crypto2;
        }
        finally {
            if (orig != null) {
                orig.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Object, Crypto> getCryptoCache(Message message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            Map<Object, Crypto> o = CastUtils.cast((Map)info.getProperty(CRYPTO_CACHE));
            if (o == null) {
                o = new ConcurrentHashMap();
                info.setProperty(CRYPTO_CACHE, o);
            }
            return o;
        }
    }
}

