/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsTokenBuilder
implements AssertionBuilder<Element> {
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsTokenBuilder.class);
    PolicyBuilder builder;

    public HttpsTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        HttpsToken httpsToken = new HttpsToken(consts);
        httpsToken.setOptional(PolicyConstants.isOptional(element));
        httpsToken.setIgnorable(PolicyConstants.isIgnorable(element));
        if (consts.getVersion() == SPConstants.Version.SP_V11) {
            String attr = DOMUtils.getAttribute(element, SPConstants.REQUIRE_CLIENT_CERTIFICATE);
            if (attr != null) {
                httpsToken.setRequireClientCertificate("true".equals(attr));
            }
        } else {
            Element polEl = PolicyConstants.findPolicyElement(element);
            if (polEl == null) {
                LOG.warning("sp:HttpsToken/wsp:Policy should have a value!");
            } else {
                Element child = DOMUtils.getFirstElement(polEl);
                if (child != null) {
                    if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(DOMUtils.getElementQName(child))) {
                        httpsToken.setHttpBasicAuthentication(true);
                    } else if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(DOMUtils.getElementQName(child))) {
                        httpsToken.setHttpDigestAuthentication(true);
                    } else if (SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(DOMUtils.getElementQName(child))) {
                        httpsToken.setRequireClientCertificate(true);
                    }
                }
            }
        }
        return httpsToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.HTTPS_TOKEN, SP12Constants.HTTPS_TOKEN};
    }
}

