/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
@Provider
public class XMLBeansElementProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<XmlObject>,
MessageBodyWriter<XmlObject> {
    public XmlObject readFrom(Class<XmlObject> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        return this.parseXmlBean(type, is);
    }

    public void writeTo(XmlObject t, Class<?> cls, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        t.save(entityStream);
    }

    public long getSize(XmlObject t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isXmlBean(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isXmlBean(type);
    }

    protected XmlObject parseXmlBean(Class<?> type, XMLStreamReader reader) {
        XmlObject result = null;
        Class<?> factory = this.getFactory(type);
        try {
            Method m = factory.getMethod("parse", reader.getClass());
            Object[] args = new Object[]{reader};
            Object obj = m.invoke(type, args);
            if (obj instanceof XmlObject) {
                result = (XmlObject)obj;
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new WebApplicationException(500);
        }
        catch (InvocationTargetException ite) {
            throw new WebApplicationException(500);
        }
        catch (IllegalAccessException iae) {
            throw new WebApplicationException(500);
        }
        return result;
    }

    protected XmlObject parseXmlBean(Class<?> type, InputStream inStream) {
        XmlObject result = null;
        InputStreamReader r = new InputStreamReader(inStream);
        result = this.parseXmlBean(type, r);
        return result;
    }

    protected XmlObject parseXmlBean(Class<?> type, Reader reader) {
        XmlObject result = null;
        Class<?> factory = this.getFactory(type);
        try {
            Method m = factory.getMethod("parse", Reader.class);
            Object[] args = new Object[]{reader};
            Object obj = m.invoke(type, args);
            if (obj instanceof XmlObject) {
                result = (XmlObject)obj;
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return result;
    }

    private Class<?> getFactory(Class<?> type) {
        Class<?>[] interfaces;
        Class<?> result = null;
        for (Class<?> inter : interfaces = type.getInterfaces()) {
            Class<?>[] declared;
            for (Class<?> c : declared = inter.getDeclaredClasses()) {
                if (!c.getSimpleName().equals("Factory")) continue;
                result = c;
            }
        }
        return result;
    }

    protected boolean isXmlBean(Class<?> type) {
        boolean result = false;
        Class[] interfaces = new Class[]{type};
        if (!type.isInterface()) {
            interfaces = type.getInterfaces();
        }
        for (Class i : interfaces) {
            Class<?>[] superInterfaces;
            for (Class<?> superI : superInterfaces = i.getInterfaces()) {
                if (!superI.getName().equals("org.apache.xmlbeans.XmlObject")) continue;
                result = true;
            }
        }
        return result;
    }
}

