/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAASLoginInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ROLE_CLASSIFIER_PREFIX = "prefix";
    public static final String ROLE_CLASSIFIER_CLASS_NAME = "classname";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAASLoginInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(JAASLoginInterceptor.class);
    private String contextName = "";
    private Configuration loginConfig;
    private String roleClassifier;
    private String roleClassifierType = "prefix";
    private boolean reportFault;

    public JAASLoginInterceptor() {
        super("unmarshal");
    }

    public JAASLoginInterceptor(String phase) {
        super(phase);
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    public String getContextName() {
        return this.contextName;
    }

    @Deprecated
    public void setRolePrefix(String name) {
        this.setRoleClassifier(name);
    }

    public void setRoleClassifier(String value) {
        this.roleClassifier = value;
    }

    public String getRoleClassifier() {
        return this.roleClassifier;
    }

    public void setRoleClassifierType(String value) {
        if (!ROLE_CLASSIFIER_PREFIX.equals(value) && !ROLE_CLASSIFIER_CLASS_NAME.equals(value)) {
            throw new IllegalArgumentException("Unsupported role classifier");
        }
        this.roleClassifierType = value;
    }

    public String getRoleClassifierType() {
        return this.roleClassifierType;
    }

    public void setReportFault(boolean reportFault) {
        this.reportFault = reportFault;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        String name = null;
        String password = null;
        AuthorizationPolicy policy = message.get(AuthorizationPolicy.class);
        if (policy != null) {
            name = policy.getUserName();
            password = policy.getPassword();
        } else {
            SecurityToken token = message.get(SecurityToken.class);
            if (token != null && token.getTokenType() == TokenType.UsernameToken) {
                UsernameToken ut = (UsernameToken)token;
                name = ut.getName();
                password = ut.getPassword();
            }
        }
        if (name == null || password == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_USER_PASSWORD", BUNDLE, name, password);
            LOG.warning(errorMsg.toString());
            if (this.reportFault) {
                throw new SecurityException(errorMsg.toString());
            }
            throw new SecurityException();
        }
        try {
            CallbackHandler handler = this.getCallbackHandler(name, password);
            LoginContext ctx = new LoginContext(this.getContextName(), null, handler, this.loginConfig);
            ctx.login();
            Subject subject = ctx.getSubject();
            message.put(SecurityContext.class, this.createSecurityContext(subject));
        }
        catch (LoginException ex) {
            String errorMessage = "Unauthorized : " + ex.getMessage();
            LOG.fine(errorMessage.toString());
            if (this.reportFault) {
                throw new AuthenticationException(errorMessage);
            }
            throw new AuthenticationException();
        }
    }

    protected CallbackHandler getCallbackHandler(String name, String password) {
        return new NamePasswordCallbackHandler(name, password);
    }

    protected SecurityContext createSecurityContext(Subject subject) {
        if (this.getRoleClassifier() != null) {
            return new RolePrefixSecurityContextImpl(subject, this.getRoleClassifier(), this.getRoleClassifierType());
        }
        return new DefaultSecurityContext(subject);
    }

    public Configuration getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(Configuration loginConfig) {
        this.loginConfig = loginConfig;
    }
}

