/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.List;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryStrategy
extends SequentialStrategy {
    private int maxNumberOfRetries;
    private int counter;

    @Override
    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        return this.getEndpoints(exchange, this.stillTheSameAddress());
    }

    @Override
    protected <T> T getNextAlternate(List<T> alternates) {
        return this.stillTheSameAddress() ? alternates.get(0) : alternates.remove(0);
    }

    protected boolean stillTheSameAddress() {
        if (this.maxNumberOfRetries == 0) {
            return true;
        }
        if (++this.counter <= this.maxNumberOfRetries) {
            return true;
        }
        this.counter = 0;
        return false;
    }

    public void setMaxNumberOfRetries(int maxNumberOfRetries) {
        if (maxNumberOfRetries < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public int getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }
}

