/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class OAuthRequestFilter
extends AbstractAccessTokenValidator
implements RequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(OAuthRequestFilter.class);
    private boolean useUserSubject;

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        AccessTokenValidation accessTokenV = this.getAccessTokenValidation();
        List<OAuthPermission> permissions = accessTokenV.getTokenScopes();
        ArrayList<OAuthPermission> matchingPermissions = new ArrayList<OAuthPermission>();
        HttpServletRequest req = this.getMessageContext().getHttpServletRequest();
        for (OAuthPermission perm : permissions) {
            boolean uriOK = this.checkRequestURI(req, perm.getUris());
            boolean verbOK = this.checkHttpVerb(req, perm.getHttpVerbs());
            if (!uriOK || !verbOK) continue;
            matchingPermissions.add(perm);
        }
        if (permissions.size() > 0 && matchingPermissions.isEmpty()) {
            String message = "Client has no valid permissions";
            LOG.warning(message);
            throw new WebApplicationException(403);
        }
        SecurityContext sc = this.createSecurityContext(req, accessTokenV);
        m.put(SecurityContext.class, sc);
        m.setContent(OAuthContext.class, new OAuthContext(accessTokenV.getTokenSubject(), matchingPermissions, accessTokenV.getTokenGrantType()));
        return null;
    }

    protected boolean checkHttpVerb(HttpServletRequest req, List<String> verbs) {
        if (!verbs.isEmpty() && !verbs.contains(req.getMethod())) {
            String message = "Invalid http verb";
            LOG.fine(message);
            return false;
        }
        return true;
    }

    protected boolean checkRequestURI(HttpServletRequest request, List<String> uris) {
        if (uris.isEmpty()) {
            return true;
        }
        String servletPath = request.getPathInfo();
        boolean foundValidScope = false;
        for (String uri : uris) {
            if (!OAuthUtils.checkRequestURI(servletPath, uri)) continue;
            foundValidScope = true;
            break;
        }
        if (!foundValidScope) {
            String message = "Invalid request URI";
            LOG.fine(message);
        }
        return foundValidScope;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.useUserSubject = useUserSubject;
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, AccessTokenValidation accessTokenV) {
        UserSubject endUserSubject = accessTokenV.getTokenSubject();
        UserSubject clientSubject = accessTokenV.getClientSubject();
        final UserSubject theSubject = this.useUserSubject ? endUserSubject : clientSubject;
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return theSubject != null ? new SimplePrincipal(theSubject.getLogin()) : null;
            }

            public boolean isUserInRole(String role) {
                if (theSubject == null) {
                    return false;
                }
                return theSubject.getRoles().contains(role);
            }
        };
    }
}

