/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
implements Dispatch<T>,
BindingProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private static final String DISPATCH_NS = "http://cxf.apache.org/jaxws/dispatch";
    private static final String INVOKE_NAME = "Invoke";
    private static final String INVOKE_ONEWAY_NAME = "InvokeOneWay";
    private static final QName INVOKE_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "Invoke");
    private static final QName INVOKE_ONEWAY_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "InvokeOneWay");
    private final Binding binding;
    private final EndpointReferenceBuilder builder;
    private final Client client;
    private final Class<T> cl;
    private final JAXBContext context;
    private Message error;
    private Service.Mode mode;

    DispatchImpl(Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz) {
        this.binding = ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding();
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)client.getEndpoint());
        this.client = client;
        this.mode = m;
        this.context = ctx;
        this.cl = clazz;
        this.setupEndpointAddressContext(client.getEndpoint());
        this.addInvokeOperation(false);
        this.addInvokeOperation(true);
        if (m == Service.Mode.MESSAGE && this.binding instanceof SOAPBinding) {
            if (DataSource.class.isAssignableFrom(clazz)) {
                this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "DataSource", m, "SOAP/HTTP");
            } else if (m == Service.Mode.MESSAGE) {
                SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
                client.getOutInterceptors().add(saajOut);
                client.getOutInterceptors().add(new MessageModeOutInterceptor(saajOut, client.getEndpoint().getBinding().getBindingInfo().getName()));
                client.getInInterceptors().add(new SAAJInInterceptor());
                client.getInInterceptors().add(new MessageModeInInterceptor(clazz, client.getEndpoint().getBinding().getBindingInfo().getName()));
            }
        } else if (m == Service.Mode.PAYLOAD && this.binding instanceof SOAPBinding && SOAPMessage.class.isAssignableFrom(clazz)) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "SOAPMessage", m, "SOAP/HTTP");
        } else if (DataSource.class.isAssignableFrom(clazz) && this.binding instanceof HTTPBinding) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "DataSource", m, "XML/HTTP");
        }
    }

    DispatchImpl(Client cl, Service.Mode m, Class<T> clazz) {
        this(cl, m, null, clazz);
    }

    private void addInvokeOperation(boolean oneWay) {
        String name = oneWay ? INVOKE_ONEWAY_NAME : INVOKE_NAME;
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo opInfo = info.getInterface().addOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        MessageInfo mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Request"), MessageInfo.Type.INPUT);
        opInfo.setInput(name + "Request", mInfo);
        MessagePartInfo mpi = mInfo.addMessagePart("parameters");
        if (this.context == null) {
            mpi.setTypeClass(this.cl);
        }
        mpi.setElement(true);
        if (!oneWay) {
            mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Response"), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(name + "Response", mInfo);
            mpi = mInfo.addMessagePart("parameters");
            mpi.setElement(true);
            if (this.context == null) {
                mpi.setTypeClass(this.cl);
            }
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    private void addInvokeOperation(QName operationName, boolean oneWay) {
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo invokeOpInfo = info.getInterface().getOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        OperationInfo opInfo = info.getInterface().addOperation(operationName);
        opInfo.setInput(invokeOpInfo.getInputName(), invokeOpInfo.getInput());
        if (!oneWay) {
            opInfo.setOutput(invokeOpInfo.getOutputName(), invokeOpInfo.getOutput());
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.client.getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <X extends EndpointReference> X getEndpointReference(Class<X> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            WrappedMessageContext requestContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    private void checkError() {
        if (this.error != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = null;
                try {
                    soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), new Exception(this.error.toString()));
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                if (soapFault != null) {
                    throw new SOAPFaultException(soapFault);
                }
            } else if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)new Exception(this.error.toString()));
                throw exception;
            }
            throw new WebServiceException(this.error.toString());
        }
    }

    private RuntimeException mapException(Exception ex) {
        if (ex instanceof Fault && ex.getCause() instanceof IOException) {
            throw new WebServiceException(ex.getMessage(), ex.getCause());
        }
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            return exception;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFault soapFault = null;
            try {
                soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
            }
            catch (SOAPException e) {
                // empty catch block
            }
            if (soapFault == null) {
                return new WebServiceException((Throwable)ex);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            exception.initCause((Throwable)ex);
            return exception;
        }
        return new WebServiceException((Throwable)ex);
    }

    public T invoke(T obj, boolean isOneWay) {
        StaxSource createdSource = null;
        this.checkError();
        try {
            if (obj instanceof SOAPMessage) {
                SOAPMessage msg = (SOAPMessage)obj;
                if (msg.countAttachments() > 0) {
                    this.client.getRequestContext().put("write.attachments", Boolean.TRUE);
                }
            } else if (this.context != null) {
                Boolean unwrapProperty = obj instanceof JAXBElement ? Boolean.FALSE : Boolean.TRUE;
                this.getRequestContext().put("unwrap.jaxb.element", unwrapProperty);
            }
            QName opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation");
            boolean findDispatchOp = Boolean.TRUE.equals(this.getRequestContext().get("find.dispatch.operation"));
            if (opName == null) {
                opName = isOneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME;
            } else {
                BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                if (bop == null) {
                    this.addInvokeOperation(opName, isOneWay);
                }
            }
            if (!findDispatchOp) {
                List<AbstractFeature> allFeatures;
                List<AbstractFeature> endpointFeatures = ((JaxWsClientEndpointImpl)this.client.getEndpoint()).getFeatures();
                if (this.client.getBus().getFeatures() != null) {
                    allFeatures = new ArrayList<AbstractFeature>(endpointFeatures.size() + this.client.getBus().getFeatures().size());
                    allFeatures.addAll(endpointFeatures);
                    allFeatures.addAll(this.client.getBus().getFeatures());
                } else {
                    allFeatures = endpointFeatures;
                }
                for (AbstractFeature feature : allFeatures) {
                    if (!(feature instanceof WSAddressingFeature)) continue;
                    findDispatchOp = true;
                }
            }
            Map<String, QName> payloadOPMap = this.createPayloadEleOpNameMap(this.client.getEndpoint().getBinding().getBindingInfo());
            if (findDispatchOp && !payloadOPMap.isEmpty()) {
                QName dispatchedOpName;
                String payloadElementName = null;
                if (obj instanceof Source) {
                    try {
                        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)obj);
                        Document document = StaxUtils.read(reader);
                        createdSource = new StaxSource(StaxUtils.createXMLStreamReader(document));
                        payloadElementName = this.getPayloadElementName(document.getDocumentElement());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (obj instanceof SOAPMessage) {
                    payloadElementName = this.getPayloadElementName((SOAPMessage)obj);
                }
                if (this.context != null) {
                    payloadElementName = this.getPayloadElementName(obj);
                }
                if (payloadElementName != null && null != (dispatchedOpName = payloadOPMap.get(payloadElementName))) {
                    BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                    BindingOperationInfo dbop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(dispatchedOpName);
                    if (bop != null) {
                        bop.setProperty("dispatchToOperation", dbop);
                    }
                }
            }
            Object[] ret = this.client.invokeWrapped(opName, createdSource == null ? obj : createdSource);
            if (isOneWay || ret == null || ret.length == 0) {
                return null;
            }
            return (T)ret[0];
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        this.checkError();
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        JaxwsClientCallback<T> callback = new JaxwsClientCallback<T>(asyncHandler, this);
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        try {
            QName opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation");
            if (opName == null) {
                opName = INVOKE_QNAME;
            } else {
                BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                if (bop == null) {
                    this.addInvokeOperation(opName, false);
                }
            }
            this.client.invokeWrapped(callback, opName, obj);
            return ret;
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Response<T> invokeAsync(T obj) {
        return (Response)this.invokeAsync(obj, null);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public Client getClient() {
        return this.client;
    }

    private String getPayloadElementName(Element ele) {
        XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader(ele);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xmlreader);
        try {
            if (this.mode == Service.Mode.PAYLOAD) {
                StaxUtils.skipToStartOfElement(reader);
                return reader.getName().toString();
            }
            if (this.mode == Service.Mode.MESSAGE) {
                StaxUtils.skipToStartOfElement(reader);
                StaxUtils.toNextTag(reader, new QName(ele.getNamespaceURI(), "Body"));
                reader.nextTag();
                return reader.getName().toString();
            }
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        return null;
    }

    private String getPayloadElementName(SOAPMessage soapMessage) {
        try {
            Element element = DOMUtils.getFirstElement((Node)SAAJUtils.getBody(soapMessage));
            if (element != null) {
                return DOMUtils.getElementQName(element).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getPayloadElementName(Object object) {
        JAXBDataBinding dataBinding = new JAXBDataBinding();
        dataBinding.setContext(this.context);
        DataWriter<XMLStreamWriter> dbwriter = dataBinding.createWriter(XMLStreamWriter.class);
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter resultWriter = StaxUtils.createXMLStreamWriter(stringWriter);
        try {
            dbwriter.write(object, resultWriter);
            resultWriter.flush();
            if (!StringUtils.isEmpty(stringWriter.toString())) {
                ByteArrayInputStream binput = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes());
                XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader(binput);
                DepthXMLStreamReader reader = new DepthXMLStreamReader(xmlreader);
                StaxUtils.skipToStartOfElement(reader);
                return reader.getName().toString();
            }
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        return null;
    }

    private Map<String, QName> createPayloadEleOpNameMap(BindingInfo bindingInfo) {
        String tempStyle;
        HashMap<String, QName> payloadElementMap = new HashMap<String, QName>();
        String bindingStyle = "document";
        if (bindingInfo instanceof SoapBindingInfo && (tempStyle = ((SoapBindingInfo)bindingInfo).getStyle()) != null) {
            bindingStyle = tempStyle;
        }
        for (BindingOperationInfo bop : bindingInfo.getOperations()) {
            String operationStyle;
            SoapOperationInfo soi = bop.getExtensor(SoapOperationInfo.class);
            if (soi == null) continue;
            String string = operationStyle = soi.getStyle() != null ? soi.getStyle() : bindingStyle;
            if ("document".equals(operationStyle)) {
                if (bop.getOperationInfo().getInput() == null || bop.getOperationInfo().getInput().getMessageParts().isEmpty()) continue;
                QName qn = bop.getOperationInfo().getInput().getMessagePartByIndex(0).getElementQName();
                payloadElementMap.put(qn.toString(), bop.getOperationInfo().getName());
                continue;
            }
            if (!"rpc".equals(operationStyle)) continue;
            payloadElementMap.put(bop.getOperationInfo().getName().toString(), bop.getOperationInfo().getName());
        }
        return payloadElementMap;
    }
}

