/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.w3c.dom.Element;

public class IssuedToken
extends Token {
    private EndpointReferenceType issuerEpr;
    private Element rstTemplate;
    private boolean requireExternalReference;
    private boolean requireInternalReference;

    public IssuedToken(SPConstants version) {
        super(version);
    }

    public EndpointReferenceType getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(EndpointReferenceType issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public void setRequireExternalReference(boolean requireExternalReference) {
        this.requireExternalReference = requireExternalReference;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public void setRequireInternalReference(boolean requireInternalReference) {
        this.requireInternalReference = requireInternalReference;
    }

    public Element getRstTemplate() {
        return this.rstTemplate;
    }

    public void setRstTemplate(Element rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public QName getRealName() {
        return this.constants.getIssuedToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getIssuedToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String inclusion;
        String prefix;
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            JAXBElement elem = new JAXBElement(new QName(namespaceURI, "Issuer"), EndpointReferenceType.class, (Object)this.issuerEpr);
            try {
                ContextUtils.getJAXBContext().createMarshaller().marshal((Object)elem, writer);
            }
            catch (JAXBException jAXBException) {
                // empty catch block
            }
        }
        if (this.rstTemplate != null) {
            StaxUtils.copy(this.rstTemplate, writer);
        }
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        if (this.isRequireExternalReference() || this.isRequireInternalReference() || this.isDerivedKeys()) {
            writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, policyNamespaceURI);
            }
            if (this.isRequireExternalReference()) {
                writer.writeEmptyElement(prefix, "RequireExternalReference", namespaceURI);
            }
            if (this.isRequireInternalReference()) {
                writer.writeEmptyElement(prefix, "RequireInternalReference", namespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

