/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.PersistenceUtils;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class RMTxStore
implements RMStore {
    public static final String DEFAULT_DATABASE_NAME = "rmdb";
    private static final String[][] DEST_SEQUENCES_TABLE_COLS = new String[][]{{"SEQ_ID", "VARCHAR(256) NOT NULL"}, {"ACKS_TO", "VARCHAR(1024) NOT NULL"}, {"LAST_MSG_NO", "DECIMAL(19, 0)"}, {"ENDPOINT_ID", "VARCHAR(1024)"}, {"ACKNOWLEDGED", "BLOB"}, {"PROTOCOL_VERSION", "VARCHAR(256)"}};
    private static final String[] DEST_SEQUENCES_TABLE_KEYS = new String[]{"SEQ_ID"};
    private static final String[][] SRC_SEQUENCES_TABLE_COLS = new String[][]{{"SEQ_ID", "VARCHAR(256) NOT NULL"}, {"CUR_MSG_NO", "DECIMAL(19, 0) DEFAULT 1 NOT NULL"}, {"LAST_MSG", "CHAR(1)"}, {"EXPIRY", "DECIMAL(19, 0)"}, {"OFFERING_SEQ_ID", "VARCHAR(256)"}, {"ENDPOINT_ID", "VARCHAR(1024)"}, {"PROTOCOL_VERSION", "VARCHAR(256)"}};
    private static final String[] SRC_SEQUENCES_TABLE_KEYS = new String[]{"SEQ_ID"};
    private static final String[][] MESSAGES_TABLE_COLS = new String[][]{{"SEQ_ID", "VARCHAR(256) NOT NULL"}, {"MSG_NO", "DECIMAL(19, 0) NOT NULL"}, {"SEND_TO", "VARCHAR(256)"}, {"CONTENT", "BLOB"}};
    private static final String[] MESSAGES_TABLE_KEYS = new String[]{"SEQ_ID", "MSG_NO"};
    private static final String DEST_SEQUENCES_TABLE_NAME = "CXF_RM_DEST_SEQUENCES";
    private static final String SRC_SEQUENCES_TABLE_NAME = "CXF_RM_SRC_SEQUENCES";
    private static final String INBOUND_MSGS_TABLE_NAME = "CXF_RM_INBOUND_MESSAGES";
    private static final String OUTBOUND_MSGS_TABLE_NAME = "CXF_RM_OUTBOUND_MESSAGES";
    private static final String CREATE_DEST_SEQUENCES_TABLE_STMT = RMTxStore.buildCreateTableStatement("CXF_RM_DEST_SEQUENCES", DEST_SEQUENCES_TABLE_COLS, DEST_SEQUENCES_TABLE_KEYS);
    private static final String CREATE_SRC_SEQUENCES_TABLE_STMT = RMTxStore.buildCreateTableStatement("CXF_RM_SRC_SEQUENCES", SRC_SEQUENCES_TABLE_COLS, SRC_SEQUENCES_TABLE_KEYS);
    private static final String CREATE_MESSAGES_TABLE_STMT = RMTxStore.buildCreateTableStatement("{0}", MESSAGES_TABLE_COLS, MESSAGES_TABLE_KEYS);
    private static final String CREATE_DEST_SEQUENCE_STMT_STR = "INSERT INTO CXF_RM_DEST_SEQUENCES (SEQ_ID, ACKS_TO, ENDPOINT_ID, PROTOCOL_VERSION) VALUES(?, ?, ?, ?)";
    private static final String CREATE_SRC_SEQUENCE_STMT_STR = "INSERT INTO CXF_RM_SRC_SEQUENCES (SEQ_ID, CUR_MSG_NO, LAST_MSG, EXPIRY, OFFERING_SEQ_ID, ENDPOINT_ID, PROTOCOL_VERSION) VALUES(?, 1, '0', ?, ?, ?, ?)";
    private static final String DELETE_DEST_SEQUENCE_STMT_STR = "DELETE FROM CXF_RM_DEST_SEQUENCES WHERE SEQ_ID = ?";
    private static final String DELETE_SRC_SEQUENCE_STMT_STR = "DELETE FROM CXF_RM_SRC_SEQUENCES WHERE SEQ_ID = ?";
    private static final String UPDATE_DEST_SEQUENCE_STMT_STR = "UPDATE CXF_RM_DEST_SEQUENCES SET LAST_MSG_NO = ?, ACKNOWLEDGED = ? WHERE SEQ_ID = ?";
    private static final String UPDATE_SRC_SEQUENCE_STMT_STR = "UPDATE CXF_RM_SRC_SEQUENCES SET CUR_MSG_NO = ?, LAST_MSG = ? WHERE SEQ_ID = ?";
    private static final String CREATE_MESSAGE_STMT_STR = "INSERT INTO {0} (SEQ_ID, MSG_NO, SEND_TO, CONTENT) VALUES(?, ?, ?, ?)";
    private static final String DELETE_MESSAGE_STMT_STR = "DELETE FROM {0} WHERE SEQ_ID = ? AND MSG_NO = ?";
    private static final String SELECT_DEST_SEQUENCE_STMT_STR = "SELECT ACKS_TO, LAST_MSG_NO, PROTOCOL_VERSION, ACKNOWLEDGED FROM CXF_RM_DEST_SEQUENCES WHERE SEQ_ID = ?";
    private static final String SELECT_SRC_SEQUENCE_STMT_STR = "SELECT CUR_MSG_NO, LAST_MSG, EXPIRY, OFFERING_SEQ_ID, PROTOCOL_VERSION FROM CXF_RM_SRC_SEQUENCES WHERE SEQ_ID = ?";
    private static final String SELECT_DEST_SEQUENCES_STMT_STR = "SELECT SEQ_ID, ACKS_TO, LAST_MSG_NO, PROTOCOL_VERSION, ACKNOWLEDGED FROM CXF_RM_DEST_SEQUENCES WHERE ENDPOINT_ID = ?";
    private static final String SELECT_SRC_SEQUENCES_STMT_STR = "SELECT SEQ_ID, CUR_MSG_NO, LAST_MSG, EXPIRY, OFFERING_SEQ_ID, PROTOCOL_VERSION FROM CXF_RM_SRC_SEQUENCES WHERE ENDPOINT_ID = ?";
    private static final String SELECT_MESSAGES_STMT_STR = "SELECT MSG_NO, SEND_TO, CONTENT FROM {0} WHERE SEQ_ID = ?";
    private static final String ALTER_TABLE_STMT_STR = "ALTER TABLE {0} ADD {1} {2}";
    private static final String CREATE_INBOUND_MESSAGE_STMT_STR = MessageFormat.format("INSERT INTO {0} (SEQ_ID, MSG_NO, SEND_TO, CONTENT) VALUES(?, ?, ?, ?)", "CXF_RM_INBOUND_MESSAGES");
    private static final String CREATE_OUTBOUND_MESSAGE_STMT_STR = MessageFormat.format("INSERT INTO {0} (SEQ_ID, MSG_NO, SEND_TO, CONTENT) VALUES(?, ?, ?, ?)", "CXF_RM_OUTBOUND_MESSAGES");
    private static final String DELETE_INBOUND_MESSAGE_STMT_STR = MessageFormat.format("DELETE FROM {0} WHERE SEQ_ID = ? AND MSG_NO = ?", "CXF_RM_INBOUND_MESSAGES");
    private static final String DELETE_OUTBOUND_MESSAGE_STMT_STR = MessageFormat.format("DELETE FROM {0} WHERE SEQ_ID = ? AND MSG_NO = ?", "CXF_RM_OUTBOUND_MESSAGES");
    private static final String SELECT_INBOUND_MESSAGES_STMT_STR = MessageFormat.format("SELECT MSG_NO, SEND_TO, CONTENT FROM {0} WHERE SEQ_ID = ?", "CXF_RM_INBOUND_MESSAGES");
    private static final String SELECT_OUTBOUND_MESSAGES_STMT_STR = MessageFormat.format("SELECT MSG_NO, SEND_TO, CONTENT FROM {0} WHERE SEQ_ID = ?", "CXF_RM_OUTBOUND_MESSAGES");
    private static final String CREATE_SCHEMA_STMT_STR = "CREATE SCHEMA {0}";
    private static final String[] SET_SCHEMA_STMT_STRS = new String[]{"SET SCHEMA {0}", "SET CURRENT_SCHEMA = {0}", "ALTER SESSION SET CURRENT_SCHEMA = {0}"};
    private static final String DERBY_TABLE_EXISTS_STATE = "X0Y32";
    private static final int ORACLE_TABLE_EXISTS_CODE = 955;
    private static final Logger LOG = LogUtils.getL7dLogger(RMTxStore.class);
    private boolean keepConnection = true;
    private Connection connection;
    private boolean createdConnection = true;
    private Map<Statement, Lock> statementLocks;
    private Map<String, PreparedStatement> cachedStatements;
    private DataSource dataSource;
    private String driverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
    private String url = MessageFormat.format("jdbc:derby:{0};create=true", "rmdb");
    private String userName;
    private String password;
    private String schemaName;
    private long initialReconnectDelay = 60000L;
    private int useExponentialBackOff = 2;
    private int maxReconnectAttempts = 10;
    private long reconnectDelay;
    private int reconnectAttempts;
    private long nextReconnectAttempt;
    private String tableExistsState = "X0Y32";
    private int tableExistsCode = 955;

    public void destroy() {
        if (this.connection != null && this.createdConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void setDriverClassName(String dcn) {
        this.driverClassName = dcn;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUserName(String un) {
        this.userName = un;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String sn) {
        if (sn != null && !Pattern.matches("[a-zA-Z\\d]{1,32}", sn)) {
            throw new IllegalArgumentException("Invalid schema name: " + sn);
        }
        this.schemaName = sn;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public String getTableExistsState() {
        return this.tableExistsState;
    }

    public void setTableExistsState(String tableExistsState) {
        this.tableExistsState = tableExistsState;
    }

    public int getTableExistsCode() {
        return this.tableExistsCode;
    }

    public void setTableExistsCode(int tableExistsCode) {
        this.tableExistsCode = tableExistsCode;
    }

    public boolean isKeepConnection() {
        return this.keepConnection;
    }

    public void setKeepConnection(boolean keepConnection) {
        this.keepConnection = keepConnection;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public void setConnection(Connection c) {
        this.connection = c;
        this.createdConnection = false;
    }

    @Override
    public void createDestinationSequence(DestinationSequence seq) {
        String sequenceIdentifier = seq.getIdentifier().getValue();
        String endpointIdentifier = seq.getEndpointIdentifier();
        String protocolVersion = RMTxStore.encodeProtocolVersion(seq.getProtocol());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Creating destination sequence: " + sequenceIdentifier + ", (endpoint: " + endpointIdentifier + ")");
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        try {
            this.beginTransaction();
            stmt = this.getStatement(con, CREATE_DEST_SEQUENCE_STMT_STR);
            stmt.setString(1, sequenceIdentifier);
            String addr = seq.getAcksTo().getAddress().getValue();
            stmt.setString(2, addr);
            stmt.setString(3, endpointIdentifier);
            stmt.setString(4, protocolVersion);
            stmt.execute();
            this.commit(con);
            this.releaseResources(stmt, null);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                this.abort(con);
                conex = ex;
                throw new RMStoreException(ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
    }

    @Override
    public void createSourceSequence(SourceSequence seq) {
        String sequenceIdentifier = seq.getIdentifier().getValue();
        String endpointIdentifier = seq.getEndpointIdentifier();
        String protocolVersion = RMTxStore.encodeProtocolVersion(seq.getProtocol());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating source sequence: " + sequenceIdentifier + ", (endpoint: " + endpointIdentifier + ")");
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        try {
            this.beginTransaction();
            stmt = this.getStatement(con, CREATE_SRC_SEQUENCE_STMT_STR);
            stmt.setString(1, sequenceIdentifier);
            Date expiry = seq.getExpires();
            stmt.setLong(2, expiry == null ? 0L : expiry.getTime());
            Identifier osid = seq.getOfferingSequenceIdentifier();
            stmt.setString(3, osid == null ? null : osid.getValue());
            stmt.setString(4, endpointIdentifier);
            stmt.setString(5, protocolVersion);
            stmt.execute();
            this.commit(con);
            this.releaseResources(stmt, null);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                this.abort(con);
                throw new RMStoreException(ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DestinationSequence getDestinationSequence(Identifier sid) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting destination sequence for id: " + sid);
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        ResultSet res = null;
        try {
            stmt = this.getStatement(con, SELECT_DEST_SEQUENCE_STMT_STR);
            stmt.setString(1, sid.getValue());
            res = stmt.executeQuery();
            if (res.next()) {
                EndpointReferenceType acksTo = RMUtils.createReference(res.getString(1));
                long lm = res.getLong(2);
                ProtocolVariation pv = RMTxStore.decodeProtocolVersion(res.getString(3));
                InputStream is = res.getBinaryStream(4);
                SequenceAcknowledgement ack = null;
                if (null != is) {
                    ack = PersistenceUtils.getInstance().deserialiseAcknowledgment(is);
                }
                DestinationSequence destinationSequence = new DestinationSequence(sid, acksTo, lm, ack, pv);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                return destinationSequence;
            }
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                LOG.log(Level.WARNING, new Message("SELECT_DEST_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceSequence getSourceSequence(Identifier sid) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting source sequences for id: " + sid);
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        ResultSet res = null;
        try {
            stmt = this.getStatement(con, SELECT_SRC_SEQUENCE_STMT_STR);
            stmt.setString(1, sid.getValue());
            res = stmt.executeQuery();
            if (res.next()) {
                long cmn = res.getLong(1);
                boolean lm = res.getBoolean(2);
                long lval = res.getLong(3);
                Date expiry = 0L == lval ? null : new Date(lval);
                String oidValue = res.getString(4);
                Identifier oi = null;
                if (null != oidValue) {
                    oi = RMUtils.getWSRMFactory().createIdentifier();
                    oi.setValue(oidValue);
                }
                ProtocolVariation pv = RMTxStore.decodeProtocolVersion(res.getString(5));
                SourceSequence sourceSequence = new SourceSequence(sid, expiry, oi, cmn, lm, pv);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                return sourceSequence;
            }
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                LOG.log(Level.WARNING, new Message("SELECT_SRC_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public void removeDestinationSequence(Identifier sid) {
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        try {
            this.beginTransaction();
            stmt = this.getStatement(con, DELETE_DEST_SEQUENCE_STMT_STR);
            stmt.setString(1, sid.getValue());
            stmt.execute();
            this.commit(con);
            this.releaseResources(stmt, null);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                this.abort(con);
                throw new RMStoreException(ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
    }

    @Override
    public void removeSourceSequence(Identifier sid) {
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        try {
            this.beginTransaction();
            stmt = this.getStatement(con, DELETE_SRC_SEQUENCE_STMT_STR);
            stmt.setString(1, sid.getValue());
            stmt.execute();
            this.commit(con);
            this.releaseResources(stmt, null);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                this.abort(con);
                throw new RMStoreException(ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DestinationSequence> getDestinationSequences(String endpointIdentifier) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting destination sequences for endpoint: " + endpointIdentifier);
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        ArrayList<DestinationSequence> seqs = new ArrayList<DestinationSequence>();
        ResultSet res = null;
        try {
            stmt = this.getStatement(con, SELECT_DEST_SEQUENCES_STMT_STR);
            stmt.setString(1, endpointIdentifier);
            res = stmt.executeQuery();
            while (res.next()) {
                Identifier sid = new Identifier();
                sid.setValue(res.getString(1));
                EndpointReferenceType acksTo = RMUtils.createReference(res.getString(2));
                long lm = res.getLong(3);
                ProtocolVariation pv = RMTxStore.decodeProtocolVersion(res.getString(4));
                InputStream is = res.getBinaryStream(5);
                SequenceAcknowledgement ack = null;
                if (null != is) {
                    ack = PersistenceUtils.getInstance().deserialiseAcknowledgment(is);
                }
                DestinationSequence seq = new DestinationSequence(sid, acksTo, lm, ack, pv);
                seqs.add(seq);
            }
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                LOG.log(Level.WARNING, new Message("SELECT_DEST_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
        return seqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SourceSequence> getSourceSequences(String endpointIdentifier) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Getting source sequences for endpoint: " + endpointIdentifier);
        }
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        ArrayList<SourceSequence> seqs = new ArrayList<SourceSequence>();
        ResultSet res = null;
        try {
            stmt = this.getStatement(con, SELECT_SRC_SEQUENCES_STMT_STR);
            stmt.setString(1, endpointIdentifier);
            res = stmt.executeQuery();
            while (res.next()) {
                Identifier sid = new Identifier();
                sid.setValue(res.getString(1));
                long cmn = res.getLong(2);
                boolean lm = res.getBoolean(3);
                long lval = res.getLong(4);
                Date expiry = 0L == lval ? null : new Date(lval);
                String oidValue = res.getString(5);
                Identifier oi = null;
                if (null != oidValue) {
                    oi = new Identifier();
                    oi.setValue(oidValue);
                }
                ProtocolVariation pv = RMTxStore.decodeProtocolVersion(res.getString(6));
                SourceSequence seq = new SourceSequence(sid, expiry, oi, cmn, lm, pv);
                seqs.add(seq);
            }
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                LOG.log(Level.WARNING, new Message("SELECT_SRC_SEQ_FAILED_MSG", LOG, new Object[0]).toString(), ex);
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, res);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
        return seqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<RMMessage> getMessages(Identifier sid, boolean outbound) {
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        ArrayList<RMMessage> msgs = new ArrayList<RMMessage>();
        ResultSet res = null;
        try {
            stmt = this.getStatement(con, outbound ? SELECT_OUTBOUND_MESSAGES_STMT_STR : SELECT_INBOUND_MESSAGES_STMT_STR);
            stmt.setString(1, sid.getValue());
            res = stmt.executeQuery();
            while (res.next()) {
                long mn = res.getLong(1);
                String to = res.getString(2);
                Blob blob = res.getBlob(3);
                RMMessage msg = new RMMessage();
                msg.setMessageNumber(mn);
                msg.setTo(to);
                msg.setContent(blob.getBinaryStream());
                msgs.add(msg);
            }
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            conex = ex;
            LOG.log(Level.WARNING, new Message(outbound ? "SELECT_OUTBOUND_MSGS_FAILED_MSG" : "SELECT_INBOUND_MSGS_FAILED_MSG", LOG, new Object[0]).toString(), ex);
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
        }
        catch (IOException ex2) {
            LOG.log(Level.WARNING, new Message(outbound ? "SELECT_OUTBOUND_MSGS_FAILED_MSG" : "SELECT_INBOUND_MSGS_FAILED_MSG", LOG, new Object[0]).toString(), ex2);
            this.releaseResources(stmt, res);
            this.updateConnectionState(con, conex);
            {
                catch (Throwable throwable) {
                    this.releaseResources(stmt, res);
                    this.updateConnectionState(con, conex);
                    throw throwable;
                }
            }
        }
        return msgs;
    }

    @Override
    public void persistIncoming(DestinationSequence seq, RMMessage msg) {
        Connection con = this.verifyConnection();
        SQLException conex = null;
        try {
            this.beginTransaction();
            this.updateDestinationSequence(con, seq);
            if (msg != null && msg.getCachedOutputStream() != null) {
                this.storeMessage(con, seq.getIdentifier(), msg, false);
            }
            this.commit(con);
        }
        catch (SQLException ex) {
            conex = ex;
            this.abort(con);
            throw new RMStoreException(ex);
        }
        catch (IOException ex) {
            this.abort(con);
            throw new RMStoreException(ex);
        }
        finally {
            this.updateConnectionState(con, conex);
        }
    }

    @Override
    public void persistOutgoing(SourceSequence seq, RMMessage msg) {
        Connection con = this.verifyConnection();
        SQLException conex = null;
        try {
            this.beginTransaction();
            this.updateSourceSequence(con, seq);
            if (msg != null && msg.getCachedOutputStream() != null) {
                this.storeMessage(con, seq.getIdentifier(), msg, true);
            }
            this.commit(con);
        }
        catch (SQLException ex) {
            conex = ex;
            this.abort(con);
            throw new RMStoreException(ex);
        }
        catch (IOException ex) {
            this.abort(con);
            throw new RMStoreException(ex);
        }
        finally {
            this.updateConnectionState(con, conex);
        }
    }

    @Override
    public void removeMessages(Identifier sid, Collection<Long> messageNrs, boolean outbound) {
        Connection con = this.verifyConnection();
        PreparedStatement stmt = null;
        SQLException conex = null;
        try {
            stmt = this.getStatement(con, outbound ? DELETE_OUTBOUND_MESSAGE_STMT_STR : DELETE_INBOUND_MESSAGE_STMT_STR);
            this.beginTransaction();
            stmt.setString(1, sid.getValue());
            for (Long messageNr : messageNrs) {
                stmt.setLong(2, messageNr);
                stmt.execute();
            }
            this.commit(con);
            this.releaseResources(stmt, null);
            this.updateConnectionState(con, conex);
        }
        catch (SQLException ex) {
            try {
                conex = ex;
                this.abort(con);
                throw new RMStoreException(ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                this.updateConnectionState(con, conex);
                throw throwable;
            }
        }
    }

    protected void beginTransaction() {
    }

    protected void commit(Connection con) throws SQLException {
        con.commit();
    }

    protected void commit() throws SQLException {
        this.commit(this.connection);
    }

    protected void abort(Connection con) {
        try {
            con.rollback();
        }
        catch (SQLException ex) {
            LogUtils.log(LOG, Level.SEVERE, "ABORT_FAILED_MSG", ex);
        }
    }

    protected void abort() {
        this.abort(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeMessage(Connection con, Identifier sid, RMMessage msg, boolean outbound) throws IOException, SQLException {
        PreparedStatement stmt;
        block9: {
            String id = sid.getValue();
            long nr = msg.getMessageNumber();
            String to = msg.getTo();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Storing {0} message number {1} for sequence {2}, to = {3}", new Object[]{outbound ? "outbound" : "inbound", nr, id, to});
            }
            InputStream msgin = null;
            stmt = null;
            try {
                msgin = msg.getInputStream();
                stmt = this.getStatement(con, outbound ? CREATE_OUTBOUND_MESSAGE_STMT_STR : CREATE_INBOUND_MESSAGE_STMT_STR);
                int i = 1;
                stmt.setString(i++, id);
                stmt.setLong(i++, nr);
                stmt.setString(i++, to);
                stmt.setBinaryStream(i++, msgin, (int)msg.getSize());
                stmt.execute();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Successfully stored {0} message number {1} for sequence {2}", new Object[]{outbound ? "outbound" : "inbound", nr, id});
                }
                if (msgin == null) break block9;
            }
            catch (Throwable throwable) {
                if (msgin != null) {
                    try {
                        msgin.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.releaseResources(stmt, null);
                throw throwable;
            }
            try {
                msgin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.releaseResources(stmt, null);
    }

    protected void storeMessage(Identifier sid, RMMessage msg, boolean outbound) throws IOException, SQLException {
        this.storeMessage(this.connection, sid, msg, outbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSourceSequence(Connection con, SourceSequence seq) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.getStatement(con, UPDATE_SRC_SEQUENCE_STMT_STR);
            stmt.setLong(1, seq.getCurrentMessageNr());
            stmt.setString(2, seq.isLastMessage() ? "1" : "0");
            stmt.setString(3, seq.getIdentifier().getValue());
            stmt.execute();
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    protected void updateSourceSequence(SourceSequence seq) throws SQLException {
        this.updateSourceSequence(this.connection, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestinationSequence(Connection con, DestinationSequence seq) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = this.getStatement(con, UPDATE_DEST_SEQUENCE_STMT_STR);
            long lastMessageNr = seq.getLastMessageNumber();
            stmt.setLong(1, lastMessageNr);
            InputStream is = PersistenceUtils.getInstance().serialiseAcknowledgment(seq.getAcknowledgment());
            stmt.setBinaryStream(2, is, is.available());
            stmt.setString(3, seq.getIdentifier().getValue());
            stmt.execute();
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    protected void updateDestinationSequence(DestinationSequence seq) throws SQLException, IOException {
        this.updateDestinationSequence(this.connection, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws SQLException {
        Connection con = this.verifyConnection();
        Statement stmt = null;
        try {
            con.setAutoCommit(true);
            stmt = con.createStatement();
            try {
                stmt.executeUpdate(CREATE_SRC_SEQUENCES_TABLE_STMT);
            }
            catch (SQLException ex) {
                if (!this.isTableExistsError(ex)) {
                    throw ex;
                }
                LOG.fine("Table CXF_RM_SRC_SEQUENCES already exists.");
                this.verifyTable(con, SRC_SEQUENCES_TABLE_NAME, SRC_SEQUENCES_TABLE_COLS);
            }
            finally {
                stmt.close();
            }
            stmt = con.createStatement();
            try {
                stmt.executeUpdate(CREATE_DEST_SEQUENCES_TABLE_STMT);
            }
            catch (SQLException ex) {
                if (!this.isTableExistsError(ex)) {
                    throw ex;
                }
                LOG.fine("Table CXF_RM_DEST_SEQUENCES already exists.");
                this.verifyTable(con, DEST_SEQUENCES_TABLE_NAME, DEST_SEQUENCES_TABLE_COLS);
            }
            finally {
                stmt.close();
            }
            for (String tableName : new String[]{OUTBOUND_MSGS_TABLE_NAME, INBOUND_MSGS_TABLE_NAME}) {
                stmt = con.createStatement();
                try {
                    stmt.executeUpdate(MessageFormat.format(CREATE_MESSAGES_TABLE_STMT, tableName));
                }
                catch (SQLException ex) {
                    if (!this.isTableExistsError(ex)) {
                        throw ex;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Table " + tableName + " already exists.");
                    }
                    this.verifyTable(con, tableName, MESSAGES_TABLE_COLS);
                }
                finally {
                    stmt.close();
                }
            }
        }
        finally {
            if (this.connection == null && con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTable(Connection con, String tableName, String[][] tableCols) {
        ArrayList<String[]> newCols = new ArrayList<String[]>();
        ResultSet rs = null;
        try {
            DatabaseMetaData metadata = con.getMetaData();
            rs = metadata.getColumns(null, null, tableName, "%");
            HashSet<String> dbCols = new HashSet<String>();
            while (rs.next()) {
                dbCols.add(rs.getString(4));
            }
            for (String[] col : tableCols) {
                if (dbCols.contains(col[0])) continue;
                newCols.add(col);
            }
        }
        catch (SQLException ex) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Table " + tableName + " cannot be verified.");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
        }
        if (newCols.size() > 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Table " + tableName + " needs additional columns");
            }
            try {
                for (String[] newCol : newCols) {
                    Statement st = con.createStatement();
                    try {
                        st.executeUpdate(MessageFormat.format(ALTER_TABLE_STMT_STR, tableName, newCol[0], newCol[1]));
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "Successfully added column {0} to table {1}", new Object[]{tableName, newCol[0]});
                    }
                    finally {
                        st.close();
                    }
                }
            }
            catch (SQLException ex) {
                LOG.log(Level.WARNING, "Table " + tableName + " cannot be altered.", ex);
            }
        }
    }

    protected void verifyTable(String tableName, String[][] tableCols) {
        this.verifyTable(this.connection, tableName, tableCols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentSchema() throws SQLException {
        if (this.schemaName == null || this.connection == null) {
            return;
        }
        Statement stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(MessageFormat.format(CREATE_SCHEMA_STMT_STR, this.schemaName));
        }
        catch (SQLException sQLException) {
        }
        finally {
            stmt.close();
        }
        stmt = this.connection.createStatement();
        SQLException ex0 = null;
        for (int i = 0; i < SET_SCHEMA_STMT_STRS.length; ++i) {
            try {
                stmt.executeUpdate(MessageFormat.format(SET_SCHEMA_STMT_STRS[i], this.schemaName));
                ex0 = null;
                break;
            }
            catch (SQLException ex) {
                ex.setNextException(ex0);
                ex0 = ex;
                if (i != SET_SCHEMA_STMT_STRS.length - 1) continue;
                throw ex0;
            }
            finally {
                if (ex0 == null || i == SET_SCHEMA_STMT_STRS.length - 1) {
                    stmt.close();
                }
            }
        }
    }

    protected PreparedStatement getStatement(Connection con, String sql) throws SQLException {
        if (this.connection != null) {
            PreparedStatement stmt = this.cachedStatements.get(sql);
            this.statementLocks.get(stmt).lock();
            return stmt;
        }
        return con.prepareStatement(sql);
    }

    protected void releaseResources(PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            if (this.connection != null) {
                this.statementLocks.get(stmt).unlock();
            } else {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    protected void cacheStatement(Connection con, String sql) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(sql);
        this.cachedStatements.put(sql, stmt);
        this.statementLocks.put(stmt, new ReentrantLock());
    }

    protected void cacheStatements() throws SQLException {
        if (this.connection == null) {
            return;
        }
        this.statementLocks = new HashMap<Statement, Lock>();
        this.cachedStatements = new HashMap<String, PreparedStatement>();
        this.cacheStatement(this.connection, CREATE_DEST_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, CREATE_SRC_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, DELETE_DEST_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, DELETE_SRC_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, UPDATE_DEST_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, UPDATE_SRC_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, SELECT_DEST_SEQUENCES_STMT_STR);
        this.cacheStatement(this.connection, SELECT_SRC_SEQUENCES_STMT_STR);
        this.cacheStatement(this.connection, SELECT_DEST_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, SELECT_SRC_SEQUENCE_STMT_STR);
        this.cacheStatement(this.connection, CREATE_INBOUND_MESSAGE_STMT_STR);
        this.cacheStatement(this.connection, CREATE_OUTBOUND_MESSAGE_STMT_STR);
        this.cacheStatement(this.connection, DELETE_INBOUND_MESSAGE_STMT_STR);
        this.cacheStatement(this.connection, DELETE_OUTBOUND_MESSAGE_STMT_STR);
        this.cacheStatement(this.connection, SELECT_INBOUND_MESSAGES_STMT_STR);
        this.cacheStatement(this.connection, SELECT_OUTBOUND_MESSAGES_STMT_STR);
    }

    public synchronized void init() {
        if (this.keepConnection && this.connection == null) {
            this.connection = this.createConnection();
        }
        try {
            if (this.connection != null && this.schemaName != null) {
                this.setCurrentSchema();
            }
            this.createTables();
            if (this.connection != null) {
                this.cacheStatements();
            }
        }
        catch (SQLException ex) {
            LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
            SQLException se = ex;
            while (se.getNextException() != null) {
                se = se.getNextException();
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", se);
            }
            throw new RMStoreException(ex);
        }
        catch (Throwable ex) {
            LogUtils.log(LOG, Level.SEVERE, "INITIALIZATION_FAILED_MSG", ex);
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    protected Connection createConnection() {
        LOG.log(Level.FINE, "Using derby.system.home: {0}", SystemPropertyAction.getProperty("derby.system.home"));
        Connection con = null;
        if (null != this.dataSource) {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Using dataSource: " + this.dataSource);
                }
                con = this.dataSource.getConnection();
            }
            catch (SQLException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
            }
        } else {
            assert (null != this.url);
            assert (null != this.driverClassName);
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Using url: " + this.url);
                }
                Class.forName(this.driverClassName);
                con = DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (ClassNotFoundException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
            }
            catch (SQLException ex) {
                LogUtils.log(LOG, Level.SEVERE, "CONNECT_EXC", ex);
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection verifyConnection() {
        Connection con;
        if (this.connection == null) {
            con = this.createConnection();
        } else {
            RMTxStore rMTxStore = this;
            synchronized (rMTxStore) {
                if (this.createdConnection && this.nextReconnectAttempt > 0L && (this.maxReconnectAttempts < 0 || this.maxReconnectAttempts > this.reconnectAttempts)) {
                    if (System.currentTimeMillis() > this.nextReconnectAttempt) {
                        this.destroy();
                        ++this.reconnectAttempts;
                        this.init();
                        this.nextReconnectAttempt = 0L;
                    } else {
                        LogUtils.log(LOG, Level.INFO, "WAIT_RECONNECT_MSG");
                    }
                }
            }
            con = this.connection;
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConnectionState(Connection con, SQLException e) {
        if (this.connection == null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        } else {
            RMTxStore rMTxStore = this;
            synchronized (rMTxStore) {
                if (e == null) {
                    this.reconnectDelay = 0L;
                    this.reconnectAttempts = 0;
                    this.nextReconnectAttempt = 0L;
                } else if (this.createdConnection && this.isRecoverableError(e)) {
                    if (this.reconnectDelay == 0L) {
                        this.reconnectDelay = this.initialReconnectDelay;
                    }
                    if (this.nextReconnectAttempt < System.currentTimeMillis()) {
                        this.nextReconnectAttempt = System.currentTimeMillis() + this.reconnectDelay;
                        this.reconnectDelay *= (long)this.useExponentialBackOff;
                    }
                }
            }
        }
    }

    public static void deleteDatabaseFiles() {
        RMTxStore.deleteDatabaseFiles(DEFAULT_DATABASE_NAME, true);
    }

    public static void deleteDatabaseFiles(String dbName, boolean now) {
        String dsh = SystemPropertyAction.getPropertyOrNull("derby.system.home");
        File root = null;
        File log = null;
        if (null == dsh) {
            log = new File("derby.log");
            root = new File(dbName);
        } else {
            log = new File(dsh, "derby.log");
            root = new File(dsh, dbName);
        }
        if (log.exists()) {
            if (now) {
                boolean deleted = log.delete();
                LOG.log(Level.FINE, "Deleted log file {0}: {1}", new Object[]{log, deleted});
            } else {
                log.deleteOnExit();
            }
        }
        if (root.exists()) {
            LOG.log(Level.FINE, "Trying to delete directory {0}", root);
            RMTxStore.recursiveDelete(root, now);
        }
    }

    protected static String encodeProtocolVersion(ProtocolVariation pv) {
        return pv.getCodec().getWSRMNamespace() + ' ' + pv.getCodec().getWSANamespace();
    }

    protected static ProtocolVariation decodeProtocolVersion(String pv) {
        int d;
        if (null != pv && (d = pv.indexOf(32)) > 0) {
            return ProtocolVariation.findVariant(pv.substring(0, d), pv.substring(d + 1));
        }
        return ProtocolVariation.RM10WSA200408;
    }

    private static void recursiveDelete(File dir, boolean now) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                RMTxStore.recursiveDelete(f, now);
                continue;
            }
            if (now) {
                f.delete();
                continue;
            }
            f.deleteOnExit();
        }
        if (now) {
            dir.delete();
        } else {
            dir.deleteOnExit();
        }
    }

    private static String buildCreateTableStatement(String name, String[][] cols, String[] keys) {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(name).append(" (");
        for (String[] col : cols) {
            buf.append(col[0]).append(" ").append(col[1]).append(", ");
        }
        buf.append("PRIMARY KEY (");
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(keys[i]);
        }
        buf.append("))");
        return buf.toString();
    }

    protected boolean isTableExistsError(SQLException ex) {
        return null != this.tableExistsState && this.tableExistsState.equals(ex.getSQLState()) || this.tableExistsCode == ex.getErrorCode();
    }

    protected boolean isRecoverableError(SQLException ex) {
        return ex.getSQLState() != null && ex.getSQLState().startsWith("08");
    }
}

