/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.bus.blueprint.BlueprintBeanLocator;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class ConfigurerImpl
implements Configurer {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    BlueprintContainer container;
    private final Map<String, List<MatcherHolder>> wildCardBeanDefinitions = new HashMap<String, List<MatcherHolder>>();

    public ConfigurerImpl(BlueprintContainer con) {
        this.container = con;
        this.initializeWildcardMap();
    }

    private boolean isWildcardBeanName(String bn) {
        return bn.indexOf(42) != -1 || bn.indexOf(63) != -1 || bn.indexOf(40) != -1 && bn.indexOf(41) != -1;
    }

    private void initializeWildcardMap() {
        for (String s : this.container.getComponentIds()) {
            ComponentMetadata cmd;
            Class<?> cls;
            if (!this.isWildcardBeanName(s) || (cls = BlueprintBeanLocator.getClassForMetaData(this.container, cmd = this.container.getComponentMetadata(s))) == null) continue;
            String orig = s;
            if (s.charAt(0) == '*') {
                s = "." + s.replaceAll("\\.", "\\.");
            }
            Matcher matcher = Pattern.compile(s).matcher("");
            List<MatcherHolder> m = this.wildCardBeanDefinitions.get(cls.getName());
            if (m == null) {
                m = new ArrayList<MatcherHolder>();
                this.wildCardBeanDefinitions.put(cls.getName(), m);
            }
            MatcherHolder holder = new MatcherHolder(orig, matcher);
            m.add(holder);
        }
    }

    public void configureBean(Object beanInstance) {
        this.configureBean(null, beanInstance, true);
    }

    public void configureBean(String bn, Object beanInstance) {
        this.configureBean(bn, beanInstance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configureBean(String bn, Object beanInstance, boolean checkWildcards) {
        block13: {
            if (null == bn) {
                bn = this.getBeanName(beanInstance);
            }
            if (null == bn) {
                return;
            }
            if (checkWildcards) {
                this.configureWithWildCard(bn, beanInstance);
            }
            Method m = ReflectionUtil.findMethod(this.container.getClass(), "injectBeanInstance", BeanMetadata.class, Object.class);
            try {
                Method xcm;
                if (m != null) {
                    ComponentMetadata cm = null;
                    try {
                        cm = this.container.getComponentMetadata(bn);
                    }
                    catch (NoSuchComponentException nsce) {
                        cm = null;
                    }
                    if (cm instanceof BeanMetadata) {
                        ReflectionUtil.setAccessible(m);
                        m.invoke((Object)this.container, cm, beanInstance);
                    }
                    break block13;
                }
                m = ReflectionUtil.findMethod(this.container.getClass(), "getRepository", new Class[0]);
                Object o = ReflectionUtil.setAccessible(m).invoke((Object)this.container, new Object[0]);
                m = ReflectionUtil.findMethod(o.getClass(), "getRecipe", String.class);
                Object xc = o;
                o = ReflectionUtil.setAccessible(m).invoke(o, bn);
                if (o == null || (m = ReflectionUtil.findMethod(o.getClass(), "setProperties", Object.class)) == null || (xcm = this.findSetExecutionContextMethod(o.getClass().getClassLoader())) == null) break block13;
                Object oxc = xcm.invoke(null, xc);
                try {
                    ReflectionUtil.setAccessible(m).invoke(o, beanInstance);
                }
                catch (Throwable throwable) {
                    xcm.invoke(null, oxc);
                    throw throwable;
                }
                xcm.invoke(null, oxc);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Could not configure object " + bn, ex);
            }
        }
    }

    private Method findSetExecutionContextMethod(ClassLoader cl) {
        Method m = null;
        try {
            m = Class.forName("org.apache.aries.blueprint.di.ExecutionContext$Holder", false, cl).getDeclaredMethod("setContext", Class.forName("org.apache.aries.blueprint.di.ExecutionContext", false, cl));
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Could not find the ExecutionContext$Holder.setContext method", e);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWithWildCard(String bn, Object beanInstance) {
        if (!this.wildCardBeanDefinitions.isEmpty()) {
            Class<?> clazz = beanInstance.getClass();
            while (!Object.class.equals(clazz)) {
                String className = clazz.getName();
                List<MatcherHolder> matchers = this.wildCardBeanDefinitions.get(className);
                if (matchers != null) {
                    for (MatcherHolder m : matchers) {
                        Matcher matcher = m.matcher;
                        synchronized (matcher) {
                            m.matcher.reset(bn);
                            if (m.matcher.matches()) {
                                this.configureBean(m.wildCardId, beanInstance, false);
                                return;
                            }
                        }
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        Method m = null;
        try {
            m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanInstance.getClass().getMethod("getBeanName", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                beanName = (String)m.invoke(beanInstance, new Object[0]);
            }
            catch (Exception ex) {
                LogUtils.log(LOG, Level.WARNING, "ERROR_DETERMINING_BEAN_NAME_EXC", ex);
            }
        }
        if (null == beanName) {
            LogUtils.log(LOG, Level.FINE, "COULD_NOT_DETERMINE_BEAN_NAME_MSG", beanInstance.getClass().getName());
        }
        return beanName;
    }

    static class MatcherHolder {
        Matcher matcher;
        String wildCardId;

        public MatcherHolder(String orig, Matcher matcher) {
            this.wildCardId = orig;
            this.matcher = matcher;
        }
    }
}

