/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SAMLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLUtils.class);

    private SAMLUtils() {
    }

    public static List<String> parseRolesInAssertion(Object assertion, String roleAttributeName) {
        if (((AssertionWrapper)assertion).getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            return SAMLUtils.parseRolesInAssertion(((AssertionWrapper)assertion).getSaml2(), roleAttributeName);
        }
        return SAMLUtils.parseRolesInAssertion(((AssertionWrapper)assertion).getSaml1(), roleAttributeName);
    }

    private static List<String> parseRolesInAssertion(Assertion assertion, String roleAttributeName) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        block0: for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (org.opensaml.saml1.core.Attribute attribute : attributes) {
                if (!attribute.getAttributeName().equals(roleAttributeName)) continue;
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    roles.add(value);
                }
                if (attribute.getAttributeValues().size() <= 1) continue;
                continue block0;
            }
        }
        return Collections.unmodifiableList(roles);
    }

    private static List<String> parseRolesInAssertion(org.opensaml.saml2.core.Assertion assertion, String roleAttributeName) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        block0: for (AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals(roleAttributeName)) continue;
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    roles.add(value);
                }
                if (attribute.getAttributeValues().size() <= 1) continue;
                continue block0;
            }
        }
        return Collections.unmodifiableList(roles);
    }

    public static void validateSAMLResults(List<WSSecurityEngineResult> results, Message message, Element body) throws WSSecurityException {
        ArrayList samlResults = new ArrayList();
        WSSecurityUtil.fetchAllActionResults(results, (int)16, samlResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)8, samlResults);
        if (samlResults.isEmpty()) {
            return;
        }
        ArrayList<WSSecurityEngineResult> signedResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)2, signedResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)64, signedResults);
        for (WSSecurityEngineResult samlResult : samlResults) {
            AssertionWrapper assertionWrapper = (AssertionWrapper)samlResult.get((Object)"saml-assertion");
            TLSSessionInfo tlsInfo = message.get(TLSSessionInfo.class);
            Certificate[] tlsCerts = null;
            if (tlsInfo != null) {
                tlsCerts = tlsInfo.getPeerCertificates();
            }
            if (!SAMLUtils.checkHolderOfKey(assertionWrapper, signedResults, tlsCerts)) {
                LOG.warning("Assertion fails holder-of-key requirements");
                throw new WSSecurityException(3);
            }
            if (SAMLUtils.checkSenderVouches(assertionWrapper, tlsCerts, body, signedResults)) continue;
            LOG.warning("Assertion fails sender-vouches requirements");
            throw new WSSecurityException(3);
        }
    }

    public static boolean checkHolderOfKey(AssertionWrapper assertionWrapper, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            if (tlsCerts == null && (signedResults == null || signedResults.isEmpty())) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (SAMLUtils.compareCredentials(subjectKeyInfo, signedResults, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        byte[] subjectSecretKey = subjectKeyInfo.getSecret();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        for (WSSecurityEngineResult signedResult : signedResults) {
            X509Certificate[] certs = (X509Certificate[])signedResult.get((Object)"x509-certificates");
            PublicKey publicKey = (PublicKey)signedResult.get((Object)"public-key");
            byte[] secretKey = (byte[])signedResult.get((Object)"secret");
            if (certs != null && certs.length > 0 && subjectCerts != null && subjectCerts.length > 0 && certs[0].equals(subjectCerts[0])) {
                return true;
            }
            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                return true;
            }
            if (!SAMLUtils.checkSecretKey(secretKey, subjectSecretKey, signedResult)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSecretKey(byte[] secretKey, byte[] subjectSecretKey, WSSecurityEngineResult signedResult) {
        if (secretKey != null && subjectSecretKey != null) {
            if (Arrays.equals(secretKey, subjectSecretKey)) {
                return true;
            }
            Principal principal = (Principal)signedResult.get((Object)"principal");
            if (principal instanceof WSDerivedKeyTokenPrincipal && Arrays.equals(secretKey = ((WSDerivedKeyTokenPrincipal)principal).getSecret(), subjectSecretKey)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSenderVouches(AssertionWrapper assertionWrapper, Certificate[] tlsCerts, Element body, List<WSSecurityEngineResult> signed) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            if (signed == null || signed.isEmpty()) {
                return false;
            }
            if (SAMLUtils.checkAssertionAndBodyAreSigned(assertionWrapper, body, signed)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkAssertionAndBodyAreSigned(AssertionWrapper assertionWrapper, Element body, List<WSSecurityEngineResult> signed) {
        for (WSSecurityEngineResult signedResult : signed) {
            List<WSDataRef> sl = CastUtils.cast((List)signedResult.get((Object)"data-ref-uris"));
            boolean assertionIsSigned = false;
            boolean bodyIsSigned = false;
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                Element se = dataRef.getProtectedElement();
                if (se == assertionWrapper.getElement()) {
                    assertionIsSigned = true;
                }
                if (se == body) {
                    bodyIsSigned = true;
                }
                if (!assertionIsSigned || !bodyIsSigned) continue;
                return true;
            }
        }
        return false;
    }
}

