/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheManager;

public final class EHCacheManagerHolder {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap(8, 0.75f, 2);

    private EHCacheManagerHolder() {
    }

    public static CacheManager getCacheManager(URL configFileURL) {
        CacheManager cacheManager = configFileURL == null ? CacheManager.create() : CacheManager.create((URL)configFileURL);
        AtomicInteger a = COUNTS.get(cacheManager.getName());
        if (a == null) {
            COUNTS.putIfAbsent(cacheManager.getName(), new AtomicInteger());
            a = COUNTS.get(cacheManager.getName());
        }
        if (a != null) {
            a.incrementAndGet();
        }
        return cacheManager;
    }

    public static void releaseCacheManger(CacheManager cacheManager) {
        AtomicInteger a = COUNTS.get(cacheManager.getName());
        if (a != null && a.decrementAndGet() == 0) {
            cacheManager.shutdown();
        }
    }
}

