/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMOutInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMOutInterceptor.class);

    public RMOutInterceptor() {
        this.addAfter(MAPAggregator.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Message msg) throws SequenceFault, RMException {
        RMProperties rmpsOut;
        if (this.isRuntimeFault(msg)) {
            LogUtils.log(LOG, Level.WARNING, "RUNTIME_FAULT_MSG");
            return;
        }
        AddressingProperties maps = RMContextUtils.retrieveMAPs(msg, false, true);
        if (null == maps) {
            LogUtils.log(LOG, Level.WARNING, "MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        Source source = this.getManager().getSource(msg);
        String rmUri = this.getManager().getRMNamespace(msg);
        String addrUri = this.getManager().getAddressingNamespace(msg);
        ProtocolVariation protocol = ProtocolVariation.findVariant(rmUri, addrUri);
        RMContextUtils.setProtocolVariation(msg, protocol);
        maps.exposeAs(protocol.getWSANamespace());
        Destination destination = this.getManager().getDestination(msg);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse(msg);
        RMConstants constants = protocol.getConstants();
        boolean isLastMessage = constants.getCloseSequenceAction().equals(action);
        if (isApplicationMessage && !isPartialResponse) {
            RetransmissionInterceptor ri = new RetransmissionInterceptor();
            ri.setManager(this.getManager());
            msg.getInterceptorChain().add(ri);
            LOG.fine("Added RetransmissionInterceptor to chain.");
            this.getManager().getRetransmissionQueue().start();
        }
        if (null == (rmpsOut = RMContextUtils.retrieveRMProperties(msg, true))) {
            rmpsOut = new RMProperties();
            rmpsOut.exposeAs(protocol.getWSRMNamespace());
            RMContextUtils.storeRMProperties(msg, rmpsOut, true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        long inMessageNumber = 0L;
        if (isApplicationMessage) {
            rmpsIn = RMContextUtils.retrieveRMProperties(msg, false);
            if (null != rmpsIn && null != rmpsIn.getSequence()) {
                inSeqId = rmpsIn.getSequence().getIdentifier();
                inMessageNumber = rmpsIn.getSequence().getMessageNumber();
            }
            ContextUtils.storeDeferUncorrelatedMessageAbort(msg);
        }
        if ((isApplicationMessage || isLastMessage) && !isPartialResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            Source source2 = source;
            synchronized (source2) {
                SourceSequence seq = null;
                if (isLastMessage) {
                    Map invocationContext = (Map)msg.get("org.apache.cxf.invocation.context");
                    seq = (SourceSequence)invocationContext.get(SourceSequence.class.getName());
                } else {
                    seq = this.getManager().getSequence(inSeqId, msg, maps);
                }
                assert (null != seq);
                seq.nextMessageNumber(inSeqId, inMessageNumber, isLastMessage);
                if (Boolean.TRUE.equals(msg.getContextualProperty("org.apache.cxf.ws.rm.last-message"))) {
                    seq.setLastMessage(true);
                }
                rmpsOut.setSequence(seq);
                if (seq.isLastMessage()) {
                    source.setCurrent(null);
                }
            }
        } else if (!MessageUtils.isRequestor(msg) && constants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(constants.getCreateSequenceResponseAction());
        }
        if (isApplicationMessage || constants.getSequenceAckAction().equals(action)) {
            AttributedURIType to = maps.getTo();
            assert (null != to);
            this.addAcknowledgements(destination, rmpsOut, inSeqId, to);
            if (isPartialResponse && rmpsOut.getAcks() != null && rmpsOut.getAcks().size() > 0) {
                AttributedURIType actionURI = new AttributedURIType();
                actionURI.setValue(constants.getSequenceAckAction());
                maps.setAction(actionURI);
                msg.remove("org.apache.cxf.partial.response.empty");
            }
        }
        if (constants.getSequenceAckAction().equals(action) || constants.getTerminateSequenceAction().equals(action)) {
            maps.setReplyTo(RMUtils.createNoneReference());
        }
        this.assertReliability(msg);
    }

    void addAcknowledgements(Destination destination, RMProperties rmpsOut, Identifier inSeqId, AttributedURIType to) {
        for (DestinationSequence seq : destination.getAllSequences()) {
            if (!seq.sendAcknowledgement()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("no need to add acknowledgements for sequence " + seq.getIdentifier().getValue());
                continue;
            }
            String address = seq.getAcksTo().getAddress().getValue();
            if (!to.getValue().equals(address)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequences acksTo address (" + address + ") does not match to address (" + to.getValue() + ")");
                continue;
            }
            if (RMUtils.getAddressingConstants().getAnonymousURI().equals(address) && !AbstractSequence.identifierEquals(seq.getIdentifier(), inSeqId)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequence identifier does not match inbound sequence identifier");
                continue;
            }
            rmpsOut.addAck(seq);
        }
        if (LOG.isLoggable(Level.FINE)) {
            Collection<SequenceAcknowledgement> acks = rmpsOut.getAcks();
            if (null == acks) {
                LOG.fine("No acknowledgements added.");
            } else {
                LOG.fine("Added " + acks.size() + " acknowledgements.");
            }
        }
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode(message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }
}

