/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.saml.ext.AssertionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSamlPolicyValidator
extends AbstractTokenPolicyValidator {
    @Override
    protected boolean isTokenRequired(Token token, Message message) {
        SPConstants.IncludeTokenType inclusion = token.getInclusion();
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            return false;
        }
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS) {
            return true;
        }
        boolean initiator = MessageUtils.isRequestor(message);
        if (initiator && inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR) {
            return true;
        }
        return !initiator && (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT);
    }

    public boolean checkHolderOfKey(AssertionWrapper assertionWrapper, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        return SAMLUtils.checkHolderOfKey(assertionWrapper, signedResults, tlsCerts);
    }
}

