/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import java.util.ArrayList;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;

public class WrapperAnnotator
implements Annotator {
    JavaParameter wrapperRequest;
    JavaParameter wrapperResponse;

    public WrapperAnnotator(JavaParameter request, JavaParameter response) {
        this.wrapperRequest = request;
        this.wrapperResponse = response;
    }

    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("RequestWrapper and ResponseWrapper can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        if (this.wrapperRequest != null) {
            JAnnotation requestAnnotation = new JAnnotation(RequestWrapper.class);
            requestAnnotation.addElement(new JAnnotationElement("localName", this.wrapperRequest.getType()));
            requestAnnotation.addElement(new JAnnotationElement("targetNamespace", this.wrapperRequest.getTargetNamespace()));
            requestAnnotation.addElement(new JAnnotationElement("className", this.wrapperRequest.getClassName()));
            method.addAnnotation("RequestWrapper", requestAnnotation);
            method.getInterface().addImports(requestAnnotation.getImports());
        }
        if (this.wrapperResponse != null) {
            ArrayList<JAnnotationElement> elements = new ArrayList<JAnnotationElement>();
            elements.add(new JAnnotationElement("localName", this.wrapperResponse.getType()));
            elements.add(new JAnnotationElement("targetNamespace", this.wrapperResponse.getTargetNamespace()));
            elements.add(new JAnnotationElement("className", this.wrapperResponse.getClassName()));
            JAnnotation responseAnnotation = new JAnnotation(ResponseWrapper.class);
            responseAnnotation.getElements().addAll(elements);
            method.addAnnotation("ResponseWrapper", responseAnnotation);
            method.getInterface().addImports(responseAnnotation.getImports());
        }
    }
}

