/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.uri.JMSEndpointParser;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

public final class JMSUtils {
    static final Logger LOG = LogUtils.getL7dLogger(JMSUtils.class);
    private static final char[] CORRELATTION_ID_PADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    private JMSUtils() {
    }

    public static long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    public static void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    public static javax.jms.Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }

    public static void retrieveAndSetPayload(Message inMessage, javax.jms.Message message, String encoding) throws UnsupportedEncodingException {
        Object converted;
        String messageType = null;
        try {
            converted = new SimpleMessageConverter102().fromMessage(message);
        }
        catch (MessageConversionException e) {
            throw new RuntimeException("Conversion failed", e);
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        if (converted instanceof String) {
            byte[] result = encoding != null ? ((String)converted).getBytes(encoding) : ((String)converted).getBytes("UTF-8");
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(result));
            messageType = "text";
        } else if (converted instanceof byte[]) {
            byte[] result = (byte[])converted;
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(result));
            messageType = "byte";
        } else {
            messageType = message instanceof MapMessage ? "map" : (message instanceof ObjectMessage ? "object" : (message instanceof StreamMessage ? "stream" : "unknow"));
        }
        Map headers = CastUtils.cast((Map)inMessage.get(Message.PROTOCOL_HEADERS));
        if (headers == null) {
            headers = new TreeMap();
            inMessage.put(Message.PROTOCOL_HEADERS, headers);
        }
        headers.put("JMSMessageType", Collections.singletonList(messageType));
    }

    public static void populateIncomingContext(javax.jms.Message message, Message inMessage, String messageType, JMSConfiguration jmsConfig) throws UnsupportedEncodingException {
        try {
            JMSMessageHeadersType messageProperties = null;
            messageProperties = (JMSMessageHeadersType)inMessage.get(messageType);
            if (messageProperties == null) {
                messageProperties = new JMSMessageHeadersType();
                inMessage.put(messageType, messageProperties);
            }
            messageProperties.setJMSCorrelationID(message.getJMSCorrelationID());
            messageProperties.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
            messageProperties.setJMSExpiration(new Long(message.getJMSExpiration()));
            messageProperties.setJMSMessageID(message.getJMSMessageID());
            messageProperties.setJMSPriority(new Integer(message.getJMSPriority()));
            messageProperties.setJMSRedelivered(message.getJMSRedelivered());
            messageProperties.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
            messageProperties.setJMSType(message.getJMSType());
            if (message.getJMSReplyTo() != null) {
                Destination replyTo = message.getJMSReplyTo();
                if (replyTo instanceof Queue) {
                    messageProperties.setJMSReplyTo(((Queue)replyTo).getQueueName());
                } else if (replyTo instanceof Topic) {
                    messageProperties.setJMSReplyTo(((Topic)replyTo).getTopicName());
                }
            }
            TreeMap<String, List<String>> protHeaders = new TreeMap<String, List<String>>();
            List<JMSPropertyType> props = messageProperties.getProperty();
            Enumeration enm = CastUtils.cast(message.getPropertyNames());
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                String val = message.getStringProperty(name);
                JMSPropertyType prop = new JMSPropertyType();
                prop.setName(name);
                prop.setValue(val);
                props.add(prop);
                protHeaders.put(name, Collections.singletonList(val));
                if (!name.equals("Content-Type") && (!name.equals("SOAPJMS_contentType") || val == null)) continue;
                inMessage.put("Content-Type", val);
                inMessage.put(Message.ENCODING, JMSUtils.getEncoding(val));
            }
            inMessage.put(Message.PROTOCOL_HEADERS, protHeaders);
            SecurityContext securityContext = JMSUtils.buildSecurityContext(message, jmsConfig);
            inMessage.put(SecurityContext.class, securityContext);
            JMSUtils.populateIncomingMessageProperties(message, inMessage, messageProperties);
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    private static void populateIncomingMessageProperties(javax.jms.Message jmsMessage, Message inMessage, JMSMessageHeadersType messageProperties) throws UnsupportedEncodingException {
        try {
            if (jmsMessage.propertyExists("SOAPJMS_targetService")) {
                messageProperties.setSOAPJMSTargetService(jmsMessage.getStringProperty("SOAPJMS_targetService"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_bindingVersion")) {
                messageProperties.setSOAPJMSBindingVersion(jmsMessage.getStringProperty("SOAPJMS_bindingVersion"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_contentType")) {
                messageProperties.setSOAPJMSContentType(jmsMessage.getStringProperty("SOAPJMS_contentType"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_contentEncoding")) {
                messageProperties.setSOAPJMSContentEncoding(jmsMessage.getStringProperty("SOAPJMS_contentEncoding"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_soapAction")) {
                messageProperties.setSOAPJMSSOAPAction(jmsMessage.getStringProperty("SOAPJMS_soapAction"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_isFault")) {
                messageProperties.setSOAPJMSIsFault(jmsMessage.getBooleanProperty("SOAPJMS_isFault"));
            }
            if (jmsMessage.propertyExists("SOAPJMS_requestURI")) {
                messageProperties.setSOAPJMSRequestURI(jmsMessage.getStringProperty("SOAPJMS_requestURI"));
                Map headers = CastUtils.cast((Map)inMessage.get(Message.PROTOCOL_HEADERS));
                if (headers == null) {
                    headers = new TreeMap();
                    inMessage.put(Message.PROTOCOL_HEADERS, headers);
                }
                try {
                    JMSEndpoint endpoint = JMSEndpointParser.createEndpoint(jmsMessage.getStringProperty("SOAPJMS_requestURI"));
                    if (endpoint.getParameter("targetService") != null) {
                        headers.put("target.service.inrequesturi", Collections.singletonList("true"));
                    }
                }
                catch (Exception e) {
                    headers.put("malformed.requesturi", Collections.singletonList("true"));
                }
            }
            if (messageProperties.isSetSOAPJMSContentType()) {
                String contentType = messageProperties.getSOAPJMSContentType();
                inMessage.put("Content-Type", contentType);
                inMessage.put(Message.ENCODING, JMSUtils.getEncoding(contentType));
            }
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    private static SecurityContext buildSecurityContext(javax.jms.Message message, JMSConfiguration config) throws JMSException {
        String tempUserName = message.getStringProperty("JMSXUserID");
        if (tempUserName == null && config.isJmsProviderTibcoEms()) {
            tempUserName = message.getStringProperty("JMS_TIBCO_SENDER");
        }
        if (tempUserName == null) {
            return null;
        }
        final String jmsUserName = tempUserName;
        final Principal principal = new Principal(){

            public String getName() {
                return jmsUserName;
            }
        };
        SecurityContext securityContext = new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
        return securityContext;
    }

    static String getEncoding(String ct) throws UnsupportedEncodingException {
        String normalizedEncoding;
        String[] tokens;
        String contentType = ct.toLowerCase();
        String enc = null;
        for (String token : tokens = contentType.split(";")) {
            int index = token.indexOf("charset=");
            if (index < 0) continue;
            enc = token.substring(index + 8);
            break;
        }
        if ((normalizedEncoding = HttpHeaderHelper.mapCharset(enc, "UTF-8")) == null) {
            String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, enc).toString();
            LOG.log(Level.WARNING, m);
            throw new UnsupportedEncodingException(m);
        }
        return normalizedEncoding;
    }

    public static void addContentTypeToProtocolHeader(Message message) {
        List<String> ct;
        Map headers;
        String contentType = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != contentType) {
            if (enc != null && contentType.indexOf("charset=") == -1) {
                contentType = contentType + "; charset=" + enc;
            }
        } else {
            contentType = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        if (null == (headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS)))) {
            headers = new TreeMap();
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        if (headers.get("SOAPJMS_contentType") != null) {
            ct = (ArrayList<String>)headers.get("SOAPJMS_contentType");
        } else if (headers.get("Content-Type") != null) {
            ct = (List)headers.get("Content-Type");
        } else {
            ct = new ArrayList<String>();
            headers.put("SOAPJMS_contentType", ct);
        }
        ct.add(contentType);
    }

    public static String getContentType(Message message) {
        Map headers;
        String contentType = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != contentType) {
            if (enc != null && contentType.indexOf("charset=") == -1) {
                contentType = contentType + "; charset=" + enc;
            }
        } else {
            contentType = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        if (null == (headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS)))) {
            headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        return contentType;
    }

    public static String getContentEncoding(Message message) {
        return (String)message.get(GZIPOutInterceptor.GZIP_ENCODING_KEY);
    }

    public static javax.jms.Message buildJMSMessageFromCXFMessage(JMSConfiguration jmsConfig, Message outMessage, Object payload, String messageType, Session session, Destination replyTo, String correlationId) throws JMSException {
        JMSMessageHeadersType messageProperties;
        javax.jms.Message jmsMessage = JMSUtils.createAndSetPayload(payload, session, messageType);
        if (replyTo != null) {
            jmsMessage.setJMSReplyTo(replyTo);
        }
        if ((messageProperties = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers")) == null) {
            messageProperties = new JMSMessageHeadersType();
            outMessage.put("org.apache.cxf.jms.client.request.headers", messageProperties);
        }
        JMSUtils.prepareJMSProperties(messageProperties, outMessage, jmsConfig);
        JMSUtils.setJMSProperties(jmsMessage, messageProperties);
        jmsMessage.setJMSCorrelationID(correlationId);
        return jmsMessage;
    }

    static void setJMSProperties(javax.jms.Message jmsMessage, JMSMessageHeadersType messageProperties) throws JMSException {
        JMSUtils.setJMSMessageHeaderProperties(jmsMessage, messageProperties);
        JMSUtils.setJMSMessageProperties(jmsMessage, messageProperties);
    }

    private static void setJMSMessageHeaderProperties(javax.jms.Message jmsMessage, JMSMessageHeadersType messageProperties) throws JMSException {
        if (messageProperties.isSetJMSDeliveryMode()) {
            jmsMessage.setJMSDeliveryMode(messageProperties.getJMSDeliveryMode());
        }
        if (messageProperties.isSetJMSPriority()) {
            jmsMessage.setJMSPriority(messageProperties.getJMSPriority());
        }
    }

    private static void setJMSMessageProperties(javax.jms.Message jmsMessage, JMSMessageHeadersType messageProperties) throws JMSException {
        if (messageProperties.isSetSOAPJMSTargetService()) {
            jmsMessage.setStringProperty("SOAPJMS_targetService", messageProperties.getSOAPJMSTargetService());
        }
        jmsMessage.setStringProperty("SOAPJMS_bindingVersion", messageProperties.getSOAPJMSBindingVersion());
        if (messageProperties.isSetSOAPJMSContentType()) {
            jmsMessage.setStringProperty("SOAPJMS_contentType", messageProperties.getSOAPJMSContentType());
        }
        if (messageProperties.isSetSOAPJMSContentEncoding()) {
            jmsMessage.setStringProperty("SOAPJMS_contentEncoding", messageProperties.getSOAPJMSContentEncoding());
        }
        if (messageProperties.isSetSOAPJMSSOAPAction()) {
            jmsMessage.setStringProperty("SOAPJMS_soapAction", messageProperties.getSOAPJMSSOAPAction());
        }
        if (messageProperties.isSetSOAPJMSIsFault()) {
            jmsMessage.setBooleanProperty("SOAPJMS_isFault", messageProperties.isSOAPJMSIsFault());
        }
        if (messageProperties.isSetSOAPJMSRequestURI()) {
            jmsMessage.setStringProperty("SOAPJMS_requestURI", messageProperties.getSOAPJMSRequestURI());
        }
        if (messageProperties != null && messageProperties.isSetProperty()) {
            List<JMSPropertyType> props = messageProperties.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                jmsMessage.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    static void prepareJMSProperties(JMSMessageHeadersType messageProperteis, Message outMessage, JMSConfiguration jmsConfig) {
        JMSUtils.prepareJMSMessageHeaderProperties(messageProperteis, outMessage, jmsConfig);
        JMSUtils.prepareJMSMessageProperties(messageProperteis, outMessage, jmsConfig);
    }

    private static void prepareJMSMessageHeaderProperties(JMSMessageHeadersType messageProperteis, Message outMessage, JMSConfiguration jmsConfig) {
        if (!messageProperteis.isSetJMSDeliveryMode()) {
            messageProperteis.setJMSDeliveryMode(jmsConfig.getDeliveryMode());
        }
        if (!messageProperteis.isSetTimeToLive()) {
            messageProperteis.setTimeToLive(jmsConfig.getTimeToLive());
        }
        if (!messageProperteis.isSetJMSPriority()) {
            messageProperteis.setJMSPriority(jmsConfig.getPriority());
        }
    }

    private static void prepareJMSMessageProperties(JMSMessageHeadersType messageProperties, Message outMessage, JMSConfiguration jmsConfig) {
        List action;
        if (!messageProperties.isSetSOAPJMSTargetService()) {
            messageProperties.setSOAPJMSTargetService(jmsConfig.getTargetService());
        }
        if (!messageProperties.isSetSOAPJMSBindingVersion()) {
            messageProperties.setSOAPJMSBindingVersion("1.0");
        }
        messageProperties.setSOAPJMSContentType(JMSUtils.getContentType(outMessage));
        if (JMSUtils.getContentEncoding(outMessage) != null) {
            messageProperties.setSOAPJMSContentEncoding(JMSUtils.getContentEncoding(outMessage));
        }
        String soapAction = null;
        Map headers = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS));
        if (headers != null && (action = (List)headers.remove("SOAPAction")) != null && action.size() > 0) {
            soapAction = (String)action.get(0);
        }
        if (soapAction == null) {
            soapAction = messageProperties.getSOAPJMSSOAPAction();
        }
        if (soapAction == null) {
            soapAction = JMSUtils.extractActionFromSoap12(outMessage);
        }
        if (soapAction != null) {
            messageProperties.setSOAPJMSSOAPAction(soapAction);
        }
        if (!messageProperties.isSetSOAPJMSIsFault()) {
            if (outMessage.getContent(Exception.class) != null) {
                messageProperties.setSOAPJMSIsFault(true);
            } else {
                messageProperties.setSOAPJMSIsFault(false);
            }
        }
        if (!messageProperties.isSetSOAPJMSRequestURI()) {
            messageProperties.setSOAPJMSRequestURI(jmsConfig.getRequestURI());
        }
        for (Map.Entry ent : headers.entrySet()) {
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName((String)ent.getKey());
            if (((List)ent.getValue()).size() > 1) {
                StringBuilder b = new StringBuilder();
                for (String s : (List)ent.getValue()) {
                    if (b.length() > 0) {
                        b.append(',');
                    }
                    b.append(s);
                }
                prop.setValue(b.toString());
            } else {
                prop.setValue((String)((List)ent.getValue()).get(0));
            }
            messageProperties.getProperty().add(prop);
        }
    }

    public static void initResponseMessageProperties(JMSMessageHeadersType messageProperties, JMSMessageHeadersType inMessageProperties) {
        messageProperties.setJMSDeliveryMode(inMessageProperties.getJMSDeliveryMode());
        messageProperties.setJMSPriority(inMessageProperties.getJMSPriority());
        messageProperties.setSOAPJMSRequestURI(inMessageProperties.getSOAPJMSRequestURI());
        messageProperties.setSOAPJMSBindingVersion("1.0");
    }

    public static String createCorrelationId(String prefix, long i) {
        String index = Long.toHexString(i);
        StringBuilder id = new StringBuilder(prefix);
        id.append(CORRELATTION_ID_PADDING, 0, 16 - index.length());
        id.append(index);
        return id.toString();
    }

    private static String extractActionFromSoap12(Message message) {
        String ct = (String)message.get("Content-Type");
        if (ct == null) {
            return null;
        }
        int start = ct.indexOf("action=");
        if (start != -1) {
            int end;
            if (ct.charAt(start + 7) == '\"') {
                end = ct.indexOf(34, start += 8);
            } else {
                end = ct.indexOf(59, start += 7);
                if (end == -1) {
                    end = ct.length();
                }
            }
            return ct.substring(start, end);
        }
        return null;
    }
}

