/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.cors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.cors.CrossOriginResourceSharing;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossOriginResourceSharingFilter
implements RequestHandler,
ResponseHandler {
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern FIELD_COMMA_PATTERN = Pattern.compile(",\\w*");
    private static final String PREFLIGHT_PASSED = "preflight_passed";
    private static final String PREFLIGHT_FAILED = "preflight_failed";
    private static final String SIMPLE_REQUEST = "simple_request";
    @Context
    private HttpHeaders headers;
    private List<String> allowOrigins = Collections.emptyList();
    private List<String> allowHeaders = Collections.emptyList();
    private boolean allowAllOrigins;
    private boolean allowCredentials;
    private List<String> exposeHeaders = Collections.emptyList();
    private Integer maxAge;
    private Integer preflightFailStatus = 200;
    private boolean defaultOptionsMethodsHandlePreflight;

    private CrossOriginResourceSharing getAnnotation(OperationResourceInfo ori) {
        if (ori == null) {
            return null;
        }
        return ReflectionUtil.getAnnotationForMethodOrContainingClass(ori.getAnnotatedMethod(), CrossOriginResourceSharing.class);
    }

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        OperationResourceInfo opResInfo = m.getExchange().get(OperationResourceInfo.class);
        CrossOriginResourceSharing annotation = this.getAnnotation(opResInfo);
        if ("OPTIONS".equals(m.get("org.apache.cxf.request.method"))) {
            return this.preflightRequest(m, annotation, opResInfo, resourceClass);
        }
        return this.simpleRequest(m, annotation);
    }

    private Response simpleRequest(Message m, CrossOriginResourceSharing ann) {
        List<String> values = this.getHeaderValues("Origin", true);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (!this.effectiveAllowAllOrigins(ann) && !this.effectiveAllowOrigins(ann).containsAll(values)) {
            return null;
        }
        String originResponse = this.effectiveAllowAllOrigins(ann) ? "*" : this.concatValues(values, true);
        this.commonRequestProcessing(m, ann, originResponse);
        List<String> effectiveExposeHeaders = this.effectiveExposeHeaders(ann);
        if (effectiveExposeHeaders != null && effectiveExposeHeaders.size() != 0) {
            m.getExchange().put("Access-Control-Expose-Headers", effectiveExposeHeaders);
        }
        m.getExchange().put(CrossOriginResourceSharingFilter.class.getName(), SIMPLE_REQUEST);
        return null;
    }

    private Response preflightRequest(Message m, CrossOriginResourceSharing optionAnn, OperationResourceInfo opResInfo, ClassResourceInfo resourceClass) {
        if (opResInfo != null && (optionAnn == null && this.defaultOptionsMethodsHandlePreflight || optionAnn != null && optionAnn.localPreflight())) {
            return null;
        }
        List<String> headerOriginValues = this.getHeaderValues("Origin", true);
        if (headerOriginValues == null || headerOriginValues.size() != 1) {
            return null;
        }
        String origin = headerOriginValues.get(0);
        List<String> requestMethodValues = this.getHeaderValues("Access-Control-Request-Method", false);
        if (requestMethodValues == null || requestMethodValues.size() != 1) {
            return this.createPreflightResponse(m, false);
        }
        String requestMethod = requestMethodValues.get(0);
        Method method = this.getPreflightMethod(m, requestMethod);
        if (method == null) {
            return null;
        }
        CrossOriginResourceSharing ann = method.getAnnotation(CrossOriginResourceSharing.class);
        CrossOriginResourceSharing crossOriginResourceSharing = ann = ann == null ? optionAnn : ann;
        if (ann == null) {
            return this.createPreflightResponse(m, false);
        }
        boolean effectiveAllowAllOrigins = this.effectiveAllowAllOrigins(ann);
        if (!effectiveAllowAllOrigins && !this.effectiveAllowOrigins(ann).contains(origin)) {
            return this.createPreflightResponse(m, false);
        }
        List<String> requestHeaders = this.getHeaderValues("Access-Control-Request-Headers", false);
        if (!this.effectiveAllowHeaders(ann).containsAll(requestHeaders)) {
            return this.createPreflightResponse(m, false);
        }
        String originResponse = this.effectiveAllowAllOrigins(ann) ? "*" : origin;
        m.getExchange().put("Access-Control-Allow-Methods", Arrays.asList(requestMethod));
        m.getExchange().put("Access-Control-Allow-Headers", requestHeaders);
        if (this.effectiveMaxAge(ann) != null) {
            m.getExchange().put("Access-Control-Max-Age", this.effectiveMaxAge(ann).toString());
        }
        this.commonRequestProcessing(m, ann, originResponse);
        return this.createPreflightResponse(m, true);
    }

    private Response createPreflightResponse(Message m, boolean passed) {
        m.getExchange().put(CrossOriginResourceSharingFilter.class.getName(), passed ? PREFLIGHT_PASSED : PREFLIGHT_FAILED);
        int status = passed ? 200 : this.preflightFailStatus;
        return Response.status((int)status).build();
    }

    private Method getPreflightMethod(Message m, String httpMethod) {
        MetadataMap<String, String> values;
        String requestUri = HttpUtils.getPathToMatch(m, true);
        Service service = m.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        ClassResourceInfo resource = JAXRSUtils.selectResourceClass(resources, requestUri, values = new MetadataMap<String, String>(), m);
        if (resource == null) {
            return null;
        }
        OperationResourceInfo ori = this.findPreflightMethod(resource, requestUri, httpMethod, values, m);
        return ori == null ? null : ori.getAnnotatedMethod();
    }

    private OperationResourceInfo findPreflightMethod(ClassResourceInfo resource, String requestUri, String httpMethod, MultivaluedMap<String, String> values, Message m) {
        String contentType = "*/*";
        MediaType acceptType = MediaType.WILDCARD_TYPE;
        OperationResourceInfo ori = JAXRSUtils.findTargetMethod(resource, m, httpMethod, values, "*/*", Collections.singletonList(acceptType), true);
        if (ori == null) {
            return null;
        }
        if (ori.isSubResourceLocator()) {
            Class<?> cls = ori.getMethodToInvoke().getReturnType();
            ClassResourceInfo subcri = resource.getSubResource(cls, cls);
            if (subcri == null) {
                return null;
            }
            MetadataMap<String, String> newValues = new MetadataMap<String, String>();
            newValues.putAll((Map)values);
            return this.findPreflightMethod(subcri, (String)values.getFirst((Object)"FINAL_MATCH_GROUP"), httpMethod, newValues, m);
        }
        return ori;
    }

    private void commonRequestProcessing(Message m, CrossOriginResourceSharing ann, String origin) {
        m.getExchange().put("Origin", origin);
        m.getExchange().put("Access-Control-Allow-Credentials", this.effectiveAllowCredentials(ann));
    }

    @Override
    public Response handleResponse(Message m, OperationResourceInfo ori, Response response) {
        String op = (String)m.getExchange().get(CrossOriginResourceSharingFilter.class.getName());
        if (op == null || op == PREFLIGHT_FAILED) {
            return response;
        }
        Response.ResponseBuilder rbuilder = Response.fromResponse((Response)response);
        rbuilder.header("Access-Control-Allow-Origin", (Object)((String)m.getExchange().get("Origin")));
        rbuilder.header("Access-Control-Allow-Credentials", (Object)Boolean.toString(this.allowCredentials));
        if (SIMPLE_REQUEST.equals(op)) {
            List<String> effectiveExposeHeaders = this.getHeadersFromInput(m, "Access-Control-Expose-Headers");
            if (effectiveExposeHeaders != null) {
                this.addHeaders(rbuilder, "Access-Control-Expose-Headers", effectiveExposeHeaders, false);
            }
            return rbuilder.build();
        }
        String maValue = (String)m.getExchange().get("Access-Control-Max-Age");
        if (maValue != null) {
            rbuilder.header("Access-Control-Max-Age", (Object)maValue);
        }
        this.addHeaders(rbuilder, "Access-Control-Allow-Methods", this.getHeadersFromInput(m, "Access-Control-Allow-Methods"), false);
        List<String> rqAllowedHeaders = this.getHeadersFromInput(m, "Access-Control-Allow-Headers");
        if (rqAllowedHeaders != null) {
            this.addHeaders(rbuilder, "Access-Control-Allow-Headers", rqAllowedHeaders, false);
        }
        return rbuilder.build();
    }

    private boolean effectiveAllowAllOrigins(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowAllOrigins();
        }
        return this.allowAllOrigins;
    }

    private boolean effectiveAllowCredentials(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowCredentials();
        }
        return this.allowCredentials;
    }

    private List<String> effectiveAllowOrigins(CrossOriginResourceSharing ann) {
        if (ann != null) {
            if (ann.allowOrigins() == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(ann.allowOrigins());
        }
        return this.allowOrigins;
    }

    private List<String> effectiveAllowHeaders(CrossOriginResourceSharing ann) {
        if (ann != null) {
            if (ann.allowHeaders() == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(ann.allowHeaders());
        }
        return this.allowHeaders;
    }

    private List<String> effectiveExposeHeaders(CrossOriginResourceSharing ann) {
        if (ann != null) {
            if (ann.exposeHeaders() == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(ann.exposeHeaders());
        }
        return this.exposeHeaders;
    }

    private Integer effectiveMaxAge(CrossOriginResourceSharing ann) {
        if (ann != null) {
            int ma = ann.maxAge();
            if (ma < 0) {
                return null;
            }
            return ma;
        }
        return this.maxAge;
    }

    private List<String> getHeadersFromInput(Message m, String key) {
        Object obj = m.getExchange().get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    private List<String> getHeaderValues(String key, boolean spaceSeparated) {
        List values = this.headers.getRequestHeader(key);
        Pattern splitPattern = spaceSeparated ? SPACE_PATTERN : FIELD_COMMA_PATTERN;
        ArrayList<String> results = new ArrayList<String>();
        for (String value : values) {
            String[] items;
            for (String item : items = splitPattern.split(value)) {
                results.add(item);
            }
        }
        return results;
    }

    private void addHeaders(Response.ResponseBuilder rb, String key, List<String> values, boolean spaceSeparated) {
        String sb = this.concatValues(values, spaceSeparated);
        rb.header(key, (Object)sb);
    }

    private String concatValues(List<String> values, boolean spaceSeparated) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < values.size(); ++x) {
            sb.append(values.get(x));
            if (x == values.size() - 1) continue;
            if (spaceSeparated) {
                sb.append(" ");
                continue;
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setAllowOrigins(List<String> allowedOrigins) {
        this.allowOrigins = allowedOrigins;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowAllOrigins(boolean allowAllOrigins) {
        this.allowAllOrigins = allowAllOrigins;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowedHeaders) {
        this.allowHeaders = allowedHeaders;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public void setPreflightErrorStatus(Integer status) {
        this.preflightFailStatus = status;
    }

    public boolean isDefaultOptionsMethodsHandlePreflight() {
        return this.defaultOptionsMethodsHandlePreflight;
    }

    public void setDefaultOptionsMethodsHandlePreflight(boolean defaultOptionsMethodsHandlePreflight) {
        this.defaultOptionsMethodsHandlePreflight = defaultOptionsMethodsHandlePreflight;
    }
}

