/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.KerberosToken;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.neethi.Assertion;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBindingHandler
extends AbstractBindingBuilder {
    TransportBinding tbinding;

    public TransportBindingHandler(WSSConfig config, TransportBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(config, binding, saaj, secHeader, aim, message);
        this.tbinding = binding;
    }

    private void addSignedSupportingTokens(SupportingToken sgndSuppTokens) throws Exception {
        for (Token token : sgndSuppTokens.getTokens()) {
            AssertionWrapper assertionWrapper;
            if (token instanceof UsernameToken) {
                WSSecUsernameToken utBuilder = this.addUsernameToken((UsernameToken)token);
                if (utBuilder == null) continue;
                utBuilder.prepare((Document)this.saaj.getSOAPPart());
                utBuilder.appendToHeader(this.secHeader);
                continue;
            }
            if (token instanceof IssuedToken || token instanceof KerberosToken) {
                SecurityToken secTok = this.getSecurityToken();
                if (!this.includeToken(token.getInclusion())) continue;
                this.addEncryptedKeyElement(this.cloneElement(secTok.getToken()));
                continue;
            }
            if (!(token instanceof SamlToken) || (assertionWrapper = this.addSamlToken((SamlToken)token)) == null) continue;
            this.addSupportingElement(assertionWrapper.toDOM((Document)this.saaj.getSOAPPart()));
        }
    }

    private static void addSig(List<byte[]> signatureValues, byte[] val) {
        if (val != null) {
            signatureValues.add(val);
        }
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        try {
            if (this.isRequestor()) {
                SupportingToken sgndSuppTokens;
                Token transportToken;
                TransportToken transportTokenWrapper = this.tbinding.getTransportToken();
                if (transportTokenWrapper != null && (transportToken = transportTokenWrapper.getToken()) instanceof IssuedToken) {
                    SecurityToken secToken = this.getSecurityToken();
                    if (secToken == null) {
                        this.policyNotAsserted((Assertion)transportToken, "No transport token id");
                        return;
                    }
                    this.policyAsserted(transportToken);
                    if (this.includeToken(transportToken.getInclusion())) {
                        Element el = secToken.getToken();
                        this.addEncryptedKeyElement(this.cloneElement(el));
                    }
                }
                ArrayList<byte[]> signatureValues = new ArrayList<byte[]>();
                Collection ais = (Collection)this.aim.get(SP12Constants.SIGNED_SUPPORTING_TOKENS);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens = (SupportingToken)ai.getAssertion();
                        if (sgndSuppTokens != null) {
                            this.addSignedSupportingTokens(sgndSuppTokens);
                        }
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)this.aim.get(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS)) != null) {
                    SupportingToken sgndSuppTokens2 = null;
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens2 = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (sgndSuppTokens2 != null) {
                        SignedEncryptedParts signdParts = sgndSuppTokens2.getSignedParts();
                        for (Token token : sgndSuppTokens2.getTokens()) {
                            if (token instanceof IssuedToken || token instanceof SecureConversationToken || token instanceof KeyValueToken) {
                                TransportBindingHandler.addSig(signatureValues, this.doIssuedTokenSignature(token, signdParts, sgndSuppTokens2, null));
                                continue;
                            }
                            if (!(token instanceof X509Token) && !(token instanceof KeyValueToken)) continue;
                            TransportBindingHandler.addSig(signatureValues, this.doX509TokenSignature(token, signdParts, sgndSuppTokens2));
                        }
                    }
                }
                if ((ais = (Collection)this.aim.get(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS)) != null) {
                    for (AssertionInfo ai : ais) {
                        sgndSuppTokens = (SupportingToken)ai.getAssertion();
                        if (sgndSuppTokens != null) {
                            this.addSignedSupportingTokens(sgndSuppTokens);
                        }
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)this.aim.get(SP12Constants.ENDORSING_SUPPORTING_TOKENS)) != null) {
                    SupportingToken endSuppTokens = null;
                    for (AssertionInfo ai : ais) {
                        endSuppTokens = (SupportingToken)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                    if (endSuppTokens != null) {
                        for (Token token : endSuppTokens.getTokens()) {
                            if (token instanceof IssuedToken || token instanceof SecureConversationToken) {
                                TransportBindingHandler.addSig(signatureValues, this.doIssuedTokenSignature(token, endSuppTokens.getSignedParts(), endSuppTokens, null));
                                continue;
                            }
                            if (!(token instanceof X509Token) && !(token instanceof KeyValueToken)) continue;
                            TransportBindingHandler.addSig(signatureValues, this.doX509TokenSignature(token, endSuppTokens.getSignedParts(), endSuppTokens));
                        }
                    }
                }
                if ((ais = (Collection)this.aim.get(SP12Constants.SUPPORTING_TOKENS)) != null) {
                    for (AssertionInfo ai : ais) {
                        SupportingToken suppTokens = (SupportingToken)ai.getAssertion();
                        if (suppTokens != null && suppTokens.getTokens() != null && suppTokens.getTokens().size() > 0) {
                            this.handleSupportingTokens(suppTokens, false);
                        }
                        ai.setAsserted(true);
                    }
                }
            } else {
                this.addSignatureConfirmation(null);
            }
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    private byte[] doX509TokenSignature(Token token, SignedEncryptedParts signedParts, TokenWrapper wrapper) throws Exception {
        SOAPPart doc = this.saaj.getSOAPPart();
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampEl != null) {
            WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
            sigParts.add(timestampPart);
        }
        if (signedParts != null) {
            if (signedParts.isBody()) {
                WSEncryptionPart bodyPart = this.convertToEncryptionPart((Element)this.saaj.getSOAPBody());
                sigParts.add(bodyPart);
            }
            for (Header header : signedParts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        if (token.isDerivedKeys()) {
            WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(wrapper, token);
            Element bstElem = encrKey.getBinarySecurityTokenElement();
            if (bstElem != null) {
                this.addTopDownElement(bstElem);
            }
            encrKey.appendToHeader(this.secHeader);
            WSSecDKSign dkSig = new WSSecDKSign(this.wssConfig);
            dkSig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
            dkSig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
            dkSig.setDerivedKeyLength(this.binding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSig.setExternalKey(encrKey.getEphemeralKey(), encrKey.getId());
            dkSig.prepare((Document)doc, this.secHeader);
            dkSig.setParts(sigParts);
            List referenceList = dkSig.addReferencesToSign(sigParts, this.secHeader);
            dkSig.appendDKElementToHeader(this.secHeader);
            dkSig.computeSignature(referenceList, false, null);
            return dkSig.getSignatureValue();
        }
        WSSecSignature sig = this.getSignatureBuilder(wrapper, token, false);
        if (sig != null) {
            sig.prependBSTElementToHeader(this.secHeader);
            List referenceList = sig.addReferencesToSign(sigParts, this.secHeader);
            if (this.bottomUpElement == null) {
                sig.computeSignature(referenceList, false, null);
            } else {
                sig.computeSignature(referenceList, true, this.bottomUpElement);
            }
            this.bottomUpElement = sig.getSignatureElement();
            this.mainSigId = sig.getId();
            return sig.getSignatureValue();
        }
        return null;
    }

    private byte[] doIssuedTokenSignature(Token token, SignedEncryptedParts signdParts, TokenWrapper wrapper, SecurityToken securityTok) throws Exception {
        SecurityToken secTok = securityTok;
        if (secTok == null) {
            secTok = this.getSecurityToken();
        }
        boolean tokenIncluded = false;
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.includeToken(token.getInclusion())) {
            Element el = this.cloneElement(secTok.getToken());
            this.addEncryptedKeyElement(el);
            tokenIncluded = true;
        }
        if (this.timestampEl != null) {
            WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
            sigParts.add(timestampPart);
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                WSEncryptionPart bodyPart = this.convertToEncryptionPart((Element)this.saaj.getSOAPBody());
                sigParts.add(bodyPart);
            }
            if (secTok.getX509Certificate() != null || securityTok != null) {
                for (Header header : signdParts.getHeaders()) {
                    WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                    sigParts.add(wep);
                }
            }
        }
        if (token.isDerivedKeys()) {
            return this.doDerivedKeySignature(tokenIncluded, secTok, token, sigParts);
        }
        return this.doSignature(tokenIncluded, secTok, token, wrapper, sigParts);
    }

    private byte[] doDerivedKeySignature(boolean tokenIncluded, SecurityToken secTok, Token token, List<WSEncryptionPart> sigParts) throws Exception {
        WSSecDKSign dkSign = new WSSecDKSign(this.wssConfig);
        AlgorithmSuite algorithmSuite = this.tbinding.getAlgorithmSuite();
        Element ref = tokenIncluded ? secTok.getAttachedReference() : secTok.getUnattachedReference();
        if (ref != null) {
            dkSign.setExternalKey(secTok.getSecret(), this.cloneElement(ref));
        } else {
            dkSign.setExternalKey(secTok.getSecret(), secTok.getId());
        }
        dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
        dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength() / 8);
        if (token.getSPConstants() == SP12Constants.INSTANCE) {
            dkSign.setWscVersion(2);
        }
        SOAPPart doc = this.saaj.getSOAPPart();
        dkSign.prepare((Document)doc, this.secHeader);
        this.addDerivedKeyElement(dkSign.getdktElement());
        dkSign.setParts(sigParts);
        List referenceList = dkSign.addReferencesToSign(sigParts, this.secHeader);
        dkSign.computeSignature(referenceList, false, null);
        return dkSign.getSignatureValue();
    }

    private byte[] doSignature(boolean tokenIncluded, SecurityToken secTok, Token token, TokenWrapper wrapper, List<WSEncryptionPart> sigParts) throws Exception {
        WSSecSignature sig = new WSSecSignature(this.wssConfig);
        Element ref = tokenIncluded ? secTok.getAttachedReference() : secTok.getUnattachedReference();
        if (ref != null) {
            SecurityTokenReference secRef = new SecurityTokenReference(this.cloneElement(ref), false);
            sig.setSecurityTokenReference(secRef);
            sig.setKeyIdentifierType(12);
        } else if (secTok.getTokenType() == null) {
            sig.setCustomTokenId(secTok.getId());
            sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            sig.setKeyIdentifierType(12);
        } else {
            String id = secTok.getWsuId();
            if (id == null) {
                sig.setCustomTokenId(secTok.getId());
                sig.setKeyIdentifierType(11);
            } else {
                sig.setCustomTokenId(secTok.getWsuId());
                sig.setKeyIdentifierType(9);
            }
            String tokenType = secTok.getTokenType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                sig.setKeyIdentifierType(12);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                sig.setKeyIdentifierType(12);
            } else {
                sig.setCustomTokenValueType(tokenType);
            }
        }
        Crypto crypto = null;
        if (secTok.getSecret() == null) {
            sig.setX509Certificate(secTok.getX509Certificate());
            crypto = secTok.getCrypto();
            String uname = crypto.getX509Identifier(secTok.getX509Certificate());
            String password = this.getPassword(uname, token, 3);
            if (password == null) {
                password = "";
            }
            sig.setUserInfo(uname, password);
            sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        } else {
            crypto = this.getSignatureCrypto(wrapper);
            sig.setSecretKey(secTok.getSecret());
            sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        }
        sig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
        SOAPPart doc = this.saaj.getSOAPPart();
        sig.prepare((Document)doc, crypto, this.secHeader);
        sig.setParts(sigParts);
        List referenceList = sig.addReferencesToSign(sigParts, this.secHeader);
        if (this.bottomUpElement == null) {
            sig.computeSignature(referenceList, false, null);
        } else {
            sig.computeSignature(referenceList, true, this.bottomUpElement);
        }
        this.bottomUpElement = sig.getSignatureElement();
        this.mainSigId = sig.getId();
        return sig.getSignatureValue();
    }
}

