/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.http.interceptor.DocumentWriterInterceptor;
import org.apache.cxf.binding.http.interceptor.URIParameterOutInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabindingOutSetupInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final WrappedOutInterceptor WRAPPED_OUT = new WrappedOutInterceptor();
    private static final XMLMessageOutInterceptor XML_OUT = new XMLMessageOutInterceptor();
    private static final StaxOutInterceptor STAX_OUT = new StaxOutInterceptor();

    public DatabindingOutSetupInterceptor() {
        super("pre-logical");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        boolean client = Boolean.TRUE.equals(message.get("org.apache.cxf.client"));
        InterceptorChain chain = message.getInterceptorChain();
        if (client) {
            boolean putOrPost;
            Document document = DOMUtils.createDocument();
            message.setContent(Node.class, document);
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(document);
            try {
                MapNamespaceContext nsMap = new MapNamespaceContext();
                nsMap.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
                writer.setNamespaceContext(nsMap);
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            message.setContent(XMLStreamWriter.class, writer);
            WrappedOutInterceptor wrappedOut = new WrappedOutInterceptor("pre-logical");
            wrappedOut.addAfter(this.getId());
            chain.add(wrappedOut);
            final XMLMessageOutInterceptor xmlOut = new XMLMessageOutInterceptor("pre-logical");
            xmlOut.addAfter(wrappedOut.getId());
            chain.add(xmlOut);
            Endpoint ep = message.getExchange().get(Endpoint.class);
            URIMapper mapper = (URIMapper)ep.getService().get(URIMapper.class.getName());
            BindingOperationInfo bop = message.getExchange().get(BindingOperationInfo.class);
            String verb = mapper.getVerb(bop);
            message.put("org.apache.cxf.request.method", verb);
            boolean bl = putOrPost = verb.equals("POST") || verb.equals("PUT");
            if (putOrPost) {
                chain.add(new URIParameterOutInterceptor());
                chain.add(new DocumentWriterInterceptor());
                chain.add((Interceptor<? extends Message>)new AbstractPhaseInterceptor<Message>("remove-writer", "prepare-send"){
                    {
                        super(x0, x1);
                        this.addAfter(xmlOut.getId());
                        this.addBefore(MessageSenderInterceptor.class.getName());
                    }

                    @Override
                    public void handleMessage(Message message) throws Fault {
                        message.removeContent(XMLStreamWriter.class);
                    }
                });
                chain.add(STAX_OUT);
            } else {
                chain.add(new URIParameterOutInterceptor());
            }
        } else {
            chain.add(STAX_OUT);
            chain.add(WRAPPED_OUT);
            chain.add(XML_OUT);
        }
    }
}

