/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBeanLocator;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.extension.BusExtension;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

@NoJSR250Annotations
public class BusExtensionPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private Bus bus;
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext ctx) {
        this.context = ctx;
    }

    public int getOrder() {
        return 1001;
    }

    public Object postProcessAfterInitialization(Object bean, String beanId) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanId) throws BeansException {
        if (null != this.getBus() && bean instanceof BusExtension) {
            Class<?> cls = ((BusExtension)bean).getRegistrationType();
            this.getBus().setExtension(bean, cls);
        }
        return bean;
    }

    private Bus getBus() {
        if (this.bus == null) {
            this.bus = (Bus)this.context.getBean("cxf");
            this.bus.setExtension(this.context, ApplicationContext.class);
            this.bus.setExtension(new SpringBeanLocator(this.context), ConfiguredBeanLocator.class);
        }
        return this.bus;
    }
}

