/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.java2ws.util.JavaFirstUtil;
import org.apache.cxf.tools.java2wsdl.processor.internal.AntGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.JaxwsClientGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.JaxwsImplGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.JaxwsSEIGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.JaxwsServerGenerator;
import org.apache.cxf.tools.wsdlto.core.AbstractGenerator;

public class JAXWSFrontEndProcessor
implements Processor {
    private static final String SEI_SUFFIX = "_PortType";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXWSFrontEndProcessor.class);
    private ToolContext context;
    private List<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();
    private List<String> infList = new ArrayList<String>();

    public void process() throws ToolException {
        this.checkJaxwsClass();
        List services = (List)this.context.get("serviceList");
        ServiceInfo serviceInfo = (ServiceInfo)services.get(0);
        JavaInterface jinf = JavaFirstUtil.serviceInfo2JavaInf(serviceInfo);
        String className = (String)this.context.get("implClass");
        if (className != null && className.equals(jinf.getFullClassName())) {
            jinf.setName(jinf.getName() + SEI_SUFFIX);
        }
        JavaModel jm = new JavaModel();
        jm.addInterface("inf", jinf);
        jinf.setJavaModel(jm);
        this.context.put(JavaModel.class, jm);
        this.context.put("serviceName", serviceInfo.getName());
        EndpointInfo endpointInfo = serviceInfo.getEndpoints().iterator().next();
        this.context.put("portName", endpointInfo.getName());
        this.generators.add(new JaxwsSEIGenerator());
        this.generators.add(new JaxwsImplGenerator());
        this.generators.add(new JaxwsServerGenerator());
        this.generators.add(new JaxwsClientGenerator());
        this.generators.add(new AntGenerator());
        for (AbstractGenerator generator : this.generators) {
            generator.generate(this.context);
        }
    }

    public void setEnvironment(ToolContext env) {
        this.context = env;
    }

    public JavaInterface serviceInfo2JavaInf(ServiceInfo service) {
        JavaInterface javaInf = new JavaInterface();
        InterfaceInfo inf = service.getInterface();
        for (OperationInfo op : inf.getOperations()) {
            JavaMethod jm = new JavaMethod();
            Method m = (Method)op.getProperty("operation.method");
            jm.setName(m.getName());
            int i = 0;
            for (Type type : m.getGenericParameterTypes()) {
                JavaParameter jp = new JavaParameter();
                jp.setClassName(this.getClassName(type));
                jp.setStyle(JavaType.Style.IN);
                jp.setName("arg" + i++);
                jm.addParameter(jp);
            }
            for (Type type : m.getGenericExceptionTypes()) {
                JavaException jex = new JavaException();
                String className = this.getClassName(type);
                jex.setClassName(className);
                jex.setName(className);
                jm.addException(jex);
            }
            JavaReturn jreturn = new JavaReturn();
            jreturn.setClassName(this.getClassName(m.getGenericReturnType()));
            jreturn.setStyle(JavaType.Style.OUT);
            jm.setReturn(jreturn);
            String pkg = PackageUtils.getPackageName(m.getDeclaringClass());
            javaInf.setPackageName(pkg.length() > 0 ? pkg : "defaultnamespace");
            javaInf.addMethod(jm);
            javaInf.setName(inf.getName().getLocalPart());
            jm.getParameterList();
        }
        return javaInf;
    }

    public String getClassName(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (clz.isArray()) {
                return clz.getComponentType().getName() + "[]";
            }
            return clz.getName();
        }
        if (type instanceof ParameterizedType) {
            return type.toString();
        }
        if (type instanceof GenericArrayType) {
            return type.toString();
        }
        return "";
    }

    public void checkJaxwsClass() {
        Class clz = this.context.get(Class.class);
        WebService webServiceAnno = clz.getAnnotation(WebService.class);
        if (webServiceAnno == null) {
            Message msg = new Message("CLASS_DOESNOT_CARRY_WEBSERVICE_ANNO", LOG, clz.getName());
            LOG.log(Level.WARNING, msg.toString());
            throw new ToolException(msg);
        }
        if (this.isImplRmiRemote(clz)) {
            Message msg = new Message("PARA_OR_RETURN_IMPL_REMOTE", LOG, clz.getName());
            LOG.log(Level.WARNING, msg.toString());
            throw new ToolException(msg);
        }
    }

    private boolean isImplRmiRemote(Class claz) {
        for (Method method : claz.getMethods()) {
            Class<?>[] paraClasses;
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().getName().equals("java.lang.Object")) continue;
            for (Class<?> clz : paraClasses = method.getParameterTypes()) {
                this.getInfClass(clz);
            }
            Class<?> returnClass = method.getReturnType();
            this.getInfClass(returnClass);
        }
        return this.infList.contains("java.rmi.Remote");
    }

    private void getInfClass(Class claz) {
        for (Class<?> inf : claz.getInterfaces()) {
            this.getInfClass(inf);
        }
        if (claz.getSuperclass() != null) {
            this.getInfClass(claz.getSuperclass());
        }
        if (claz.isInterface()) {
            this.infList.add(claz.getName());
        }
    }
}

