/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.util.UrlUtils;

public abstract class AbstractServletController {
    protected static final String DEFAULT_LISTINGS_CLASSIFIER = "/services";
    protected boolean isHideServiceList;
    protected boolean disableAddressUpdates;
    protected String forcedBaseAddress;
    protected String serviceListStyleSheet;
    protected String serviceListRelativePath = "/services";

    protected AbstractServletController() {
    }

    protected AbstractServletController(ServletConfig config) {
        this.init(config);
    }

    public void setHideServiceList(boolean generate) {
        this.isHideServiceList = generate;
    }

    public void setServiceListRelativePath(String relativePath) {
        this.serviceListRelativePath = relativePath;
    }

    public void setDisableAddressUpdates(boolean noupdates) {
        this.disableAddressUpdates = noupdates;
    }

    public void setForcedBaseAddress(String s) {
        this.forcedBaseAddress = s;
    }

    public void setServiceListStyleSheet(String serviceListStyleSheet) {
        this.serviceListStyleSheet = serviceListStyleSheet;
    }

    private void init(ServletConfig servletConfig) {
        String serviceListPath;
        String serviceListTransform;
        String isForcedBaseAddress;
        String isDisableAddressUpdates;
        if (servletConfig == null) {
            return;
        }
        String hideServiceList = servletConfig.getInitParameter("hide-service-list-page");
        if (hideServiceList != null) {
            this.isHideServiceList = Boolean.valueOf(hideServiceList);
        }
        if ((isDisableAddressUpdates = servletConfig.getInitParameter("disable-address-updates")) != null) {
            this.disableAddressUpdates = Boolean.valueOf(isDisableAddressUpdates);
        }
        if ((isForcedBaseAddress = servletConfig.getInitParameter("base-address")) != null) {
            this.forcedBaseAddress = isForcedBaseAddress;
        }
        if ((serviceListTransform = servletConfig.getInitParameter("service-list-stylesheet")) != null) {
            this.serviceListStyleSheet = serviceListTransform;
        }
        if ((serviceListPath = servletConfig.getInitParameter("service-list-path")) != null) {
            this.serviceListRelativePath = serviceListPath;
        }
    }

    protected String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            reqPrefix = UrlUtils.pathDecode(reqPrefix);
            int offset = 0;
            int index = this.getMatrixParameterIndex(reqPrefix, pathInfo);
            if (index >= pathInfo.length()) {
                offset = reqPrefix.length() - index;
            }
            reqPrefix = reqPrefix.substring(0, reqPrefix.length() - pathInfo.length() - offset);
        }
        return reqPrefix;
    }

    private int getMatrixParameterIndex(String reqPrefix, String pathInfo) {
        int index = reqPrefix.lastIndexOf(59);
        int lastIndex = -1;
        while (index >= pathInfo.length()) {
            lastIndex = index;
            if ((reqPrefix = reqPrefix.substring(0, index)).endsWith(pathInfo)) break;
            index = reqPrefix.lastIndexOf(59);
        }
        return lastIndex;
    }
}

