/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionInfo;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

public final class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static final String[] UNSUPPORTED = new String[]{"SessionCaching", "SessionCacheKey", "MaxChainLength", "CertValidator", "ProxyHost", "ProxyPort"};
    private static final String[] DERIVATIVE = new String[]{"CiphersuiteFilters"};
    HTTPConduit conduit;
    TLSClientParameters tlsClientParameters;
    SSLSocketFactory socketFactory;
    private Class deprecatedSunHttpsURLConnectionClass;
    private Class deprecatedSunHostnameVerifierClass;

    public HttpsURLConnectionFactory(TLSClientParameters params) {
        this.tlsClientParameters = params;
        assert (this.tlsClientParameters != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection createConnection(java.net.Proxy proxy, URL url) throws IOException {
        HttpURLConnection connection;
        block8: {
            if (!url.getProtocol().equals(HTTPS_URL_PROTOCOL_ID)) {
                throw new IOException("Illegal Protocol " + url.getProtocol() + " for HTTPS URLConnection Factory.");
            }
            connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            if (this.tlsClientParameters != null) {
                Exception ex = null;
                try {
                    this.decorateWithTLS(connection);
                }
                catch (Exception e) {
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block8;
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IIOException("Error while initializing secure socket", ex);
                }
            }
        }
        return connection;
    }

    protected synchronized void decorateWithTLS(HttpURLConnection connection) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        SSLSocketFactory preSetFactory;
        if (this.socketFactory == null && (preSetFactory = this.tlsClientParameters.getSSLSocketFactory()) != null) {
            this.socketFactory = preSetFactory;
        }
        if (this.socketFactory == null) {
            String provider = this.tlsClientParameters.getJsseProvider();
            String protocol = this.tlsClientParameters.getSecureSocketProtocol() != null ? this.tlsClientParameters.getSecureSocketProtocol() : "TLS";
            SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            TrustManager[] trustAllCerts = this.tlsClientParameters.getTrustManagers();
            ctx.init(this.tlsClientParameters.getKeyManagers(), trustAllCerts, this.tlsClientParameters.getSecureRandom());
            String[] cipherSuites = SSLUtils.getCiphersuites(this.tlsClientParameters.getCipherSuites(), SSLUtils.getSupportedCipherSuites(ctx), this.tlsClientParameters.getCipherSuitesFilter(), LOG, false);
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, this.tlsClientParameters.getSecureSocketProtocol());
        }
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)connection;
            if (this.tlsClientParameters.isDisableCNCheck()) {
                conn.setHostnameVerifier(CertificateHostnameVerifier.ALLOW_ALL);
            } else {
                conn.setHostnameVerifier(CertificateHostnameVerifier.DEFAULT);
            }
            conn.setSSLSocketFactory(this.socketFactory);
        } else {
            try {
                Class connectionClass = this.getDeprecatedSunHttpsURLConnectionClass();
                Class verifierClass = this.getDeprecatedSunHostnameVerifierClass();
                Method setHostnameVerifier = connectionClass.getMethod("setHostnameVerifier", verifierClass);
                InvocationHandler handler = new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return true;
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{verifierClass}, handler);
                setHostnameVerifier.invoke(connectionClass.cast(connection), verifierClass.cast(proxy));
                Method setSSLSocketFactory = connectionClass.getMethod("setSSLSocketFactory", SSLSocketFactory.class);
                setSSLSocketFactory.invoke(connectionClass.cast(connection), this.socketFactory);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), ex);
            }
        }
    }

    private Class getDeprecatedSunHttpsURLConnectionClass() throws ClassNotFoundException {
        if (this.deprecatedSunHttpsURLConnectionClass == null) {
            this.deprecatedSunHttpsURLConnectionClass = Class.forName("com.sun.net.ssl.HttpsURLConnection");
        }
        return this.deprecatedSunHttpsURLConnectionClass;
    }

    private Class getDeprecatedSunHostnameVerifierClass() throws ClassNotFoundException {
        if (this.deprecatedSunHostnameVerifierClass == null) {
            this.deprecatedSunHostnameVerifierClass = Class.forName("com.sun.net.ssl.HostnameVerifier");
        }
        return this.deprecatedSunHostnameVerifierClass;
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }

    protected String[] getUnSupported() {
        return UNSUPPORTED;
    }

    protected String[] getDerivative() {
        return DERIVATIVE;
    }

    public HttpURLConnectionInfo getConnectionInfo(HttpURLConnection connection) throws IOException {
        return new HttpsURLConnectionInfo(connection);
    }

    public String getProtocol() {
        return HTTPS_URL_PROTOCOL_ID;
    }
}

