/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.servlet.ServletDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTransportFactory
extends AbstractHTTPTransportFactory
implements DestinationFactory {
    private Map<String, ServletDestination> destinations = new ConcurrentHashMap<String, ServletDestination>();

    public ServletTransportFactory(Bus b) {
        super.setBus(b);
        List<String> ids = Arrays.asList("http://schemas.xmlsoap.org/wsdl/soap/http", "http://schemas.xmlsoap.org/soap/http", "http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://schemas.xmlsoap.org/wsdl/http/", "http://cxf.apache.org/transports/http/configuration", "http://cxf.apache.org/bindings/xformat");
        this.setTransportIds(ids);
    }

    public ServletTransportFactory() {
    }

    @Override
    @Resource(name="bus")
    public void setBus(Bus b) {
        super.setBus(b);
    }

    @PostConstruct
    public void register() {
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        if (this.activationNamespaces == null) {
            this.activationNamespaces = this.getTransportIds();
        }
        if (null != (dfm = this.bus.getExtension(DestinationFactoryManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, this);
            }
        }
    }

    public void removeDestination(String path) {
        this.destinations.remove(path);
    }

    @Override
    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        ServletDestination d = this.getDestinationForPath(endpointInfo.getAddress());
        if (d == null) {
            String path = ServletTransportFactory.getTrimmedPath(endpointInfo.getAddress());
            d = new ServletDestination(this.getBus(), null, endpointInfo, this, path);
            this.destinations.put(path, d);
        }
        return d;
    }

    public ServletDestination getDestinationForPath(String path) {
        return this.destinations.get(ServletTransportFactory.getTrimmedPath(path));
    }

    static String getTrimmedPath(String path) {
        if (path == null) {
            return "/";
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path.startsWith("http://localhost/")) {
            path = path.substring("http://localhost/".length());
        } else if (path.startsWith("https://localhost/")) {
            path = path.substring("https://localhost/".length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public Collection<ServletDestination> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations.values());
    }

    public Set<String> getDestinationsPaths() {
        return Collections.unmodifiableSet(this.destinations.keySet());
    }
}

